/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.util.Date;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import nextapp.echo2.app.ApplicationInstance;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.insurance.TestClaimBuilder;
import org.openvpms.archetype.test.builder.insurance.TestInsuranceFactory;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.patient.TestAttachmentBuilder;
import org.openvpms.archetype.test.builder.patient.TestInvestigationBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.insurance.claim.Attachment;
import org.openvpms.insurance.internal.InsuranceFactory;
import org.openvpms.insurance.service.InsuranceServices;
import org.openvpms.report.DocumentConverter;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetBuilder;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.patient.insurance.claim.AttachmentCollectionEditor;
import org.openvpms.web.workspace.patient.insurance.claim.Charges;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimAttachmentGenerator;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimContext;
import org.springframework.beans.factory.annotation.Autowired;

public class ClaimAttachmentGeneratorTestCase
extends AbstractAppTest {
    @Autowired
    private InsuranceRules insuranceRules;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestInsuranceFactory insuranceFactory;
    @Autowired
    private TestLaboratoryFactory laboratoryFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestUserFactory userFactory;
    private Party customer;
    private Party patient;
    private Party location;
    private Party insurer;
    private TestClaimBuilder claimBuilder;

    @Before
    public void setUp() {
        super.setUp();
        ((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().singletonByType().type("INSURANCE_CLAIM_MEDICAL_RECORDS").name("Medical Records")).document(this.documentFactory.createJRXML("Medical Records.jrxml"))).build();
        this.customer = this.customerFactory.createCustomer();
        this.patient = this.patientFactory.createPatient(this.customer);
        this.insurer = this.insuranceFactory.createInsurer();
        Act policy = this.insuranceFactory.createPolicy(this.customer, this.patient, this.insurer, "123456789");
        this.claimBuilder = this.insuranceFactory.newClaim();
        this.location = this.practiceFactory.createLocation();
        User clinician = this.userFactory.createClinician();
        this.claimBuilder.policy(policy).claimHandler(clinician).clinician(clinician).location(this.location);
    }

    @Test
    public void testFormGeneration() {
        Entity formTemplate = (Entity)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.patientDocumentForm").name("Z Form")).blankDocument()).build();
        DocumentAct form = this.patientFactory.createForm(this.patient, formTemplate);
        FinancialAct claim = (FinancialAct)this.claimBuilder.item().treatmentDates(new Date(), new Date()).add().attachment((Act)form).build();
        this.checkGenerate(claim, null, "Patient Form", "Z Form.pdf", null);
    }

    @Test
    public void testFormGenerationWithoutTemplate() {
        Entity formTemplate = (Entity)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.patientDocumentForm").name("Z Form")).build();
        DocumentAct form = this.patientFactory.createForm(this.patient, formTemplate);
        FinancialAct claim = (FinancialAct)this.claimBuilder.item().treatmentDates(new Date(), new Date()).add().attachment((Act)form).build();
        this.checkGenerate(claim, null, "Patient Form", null, "REPORT-0032: Template has no document: Z Form");
    }

    @Test
    public void testPatientAttachmentGeneration() {
        Document pdf = this.documentFactory.createPDF("report.pdf");
        DocumentAct attachment = (DocumentAct)((TestAttachmentBuilder)((TestAttachmentBuilder)this.patientFactory.newAttachment().patient(this.patient)).document(pdf)).build();
        FinancialAct claim = (FinancialAct)this.claimBuilder.item().treatmentDates(new Date(), new Date()).add().attachment((Act)attachment).build();
        Document generated = this.checkGenerate(claim, null, "Patient Attachment", "report.pdf", null);
        Assert.assertNotNull((Object)generated);
        Assert.assertNotEquals((Object)pdf, (Object)generated);
    }

    @Test
    public void testConvertODTToPDF() {
        Document odt = this.documentFactory.createODT("report.odt");
        DocumentAct attachment = (DocumentAct)((TestAttachmentBuilder)((TestAttachmentBuilder)this.patientFactory.newAttachment().patient(this.patient)).document(odt)).build();
        FinancialAct claim = (FinancialAct)this.claimBuilder.item().treatmentDates(new Date(), new Date()).add().attachment((Act)attachment).build();
        Document generated = this.checkGenerate(claim, null, "Patient Attachment", "report.pdf", null);
        Assert.assertNotNull((Object)generated);
        Assert.assertNotEquals((Object)odt, (Object)generated);
        Assert.assertEquals((Object)"application/pdf", (Object)generated.getMimeType());
    }

    @Test
    public void testConvertDOCToPDF() {
        Document doc = this.documentFactory.createDOC("report.doc");
        DocumentAct investigation = (DocumentAct)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(this.patient)).investigationType(this.laboratoryFactory.createInvestigationType()).report(doc).build();
        FinancialAct claim = (FinancialAct)this.claimBuilder.item().treatmentDates(new Date(), new Date()).add().attachment((Act)investigation).build();
        Document generated = this.checkGenerate(claim, null, "Patient Investigation", "report.pdf", null);
        Assert.assertNotNull((Object)generated);
        Assert.assertNotEquals((Object)doc, (Object)generated);
        Assert.assertEquals((Object)"application/pdf", (Object)generated.getMimeType());
    }

    @Test
    public void testInvoiceGeneration() {
        ((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().singletonByType().type("INSURANCE_CLAIM_INVOICE").name("Invoice")).blankDocument()).build();
        TestInvoiceBuilder invoiceBuilder = this.accountFactory.newInvoice();
        FinancialAct invoice = (FinancialAct)((TestInvoiceBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceBuilder)invoiceBuilder.customer(this.customer)).item().patient(this.patient)).product(this.productFactory.createService())).unitPrice(10)).add()).build();
        FinancialAct invoiceItem = (FinancialAct)invoiceBuilder.getItems().get(0);
        FinancialAct claim = (FinancialAct)this.claimBuilder.item(new FinancialAct[]{invoiceItem}).build();
        this.checkGenerate(claim, invoiceItem, "Customer Invoice " + invoice.getId(), "Invoice.pdf", null);
    }

    @Test
    public void testPatientAttachmentWithoutDocument() {
        DocumentAct attachment = (DocumentAct)((TestAttachmentBuilder)this.patientFactory.newAttachment().patient(this.patient)).build();
        FinancialAct claim = (FinancialAct)this.claimBuilder.item().treatmentDates(new Date(), new Date()).add().attachment((Act)attachment).build();
        this.checkGenerate(claim, null, "Patient Attachment", null, "The Attachment has no document.");
    }

    @Test
    public void testDeleteSourceDocument() {
        Entity template = this.documentFactory.createTemplate("act.patientDocumentForm");
        DocumentAct form = this.patientFactory.createForm(this.patient, template);
        FinancialAct claim = (FinancialAct)this.claimBuilder.item().treatmentDates(new Date(), new Date()).add().attachment((Act)form).build();
        this.remove((IMObject)form);
        this.checkGenerate(claim, null, "Patient Form", null, "The original document has been deleted.");
    }

    @Test
    public void testInvestigationGeneration() {
        DocumentAct investigation = (DocumentAct)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(this.patient)).investigationType(this.laboratoryFactory.createInvestigationType()).report(this.documentFactory.createPDF("Results.pdf")).build();
        FinancialAct claim = (FinancialAct)this.claimBuilder.item().treatmentDates(new Date(), new Date()).add().attachment((Act)investigation).build();
        this.checkGenerate(claim, null, "Patient Investigation", "Results.pdf", null);
    }

    @Test
    public void testInvestigationWithoutDocument() {
        DocumentAct investigation = (DocumentAct)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(this.patient)).investigationType(this.laboratoryFactory.createInvestigationType()).build();
        FinancialAct claim = (FinancialAct)this.claimBuilder.item().treatmentDates(new Date(), new Date()).add().attachment((Act)investigation).build();
        this.checkGenerate(claim, null, "Patient Investigation", null, "The Investigation has no document.");
    }

    private Document checkGenerate(FinancialAct claim, FinancialAct invoiceItem, String name, String documentName, String error) {
        Document result = null;
        ClaimContext claimContext = new ClaimContext(claim, this.customer, this.patient, this.location, this.getArchetypeService(), this.insuranceRules, (InsuranceServices)Mockito.mock(InsuranceServices.class), (InsuranceFactory)Mockito.mock(InsuranceFactory.class));
        Charges charges = new Charges(claimContext);
        if (invoiceItem != null) {
            charges.add((Act)invoiceItem);
        }
        LocalContext context = new LocalContext();
        DummyConverter converter = new DummyConverter();
        ClaimAttachmentGenerator generator = new ClaimAttachmentGenerator(this.customer, this.patient, charges, (Context)context, (DocumentConverter)converter);
        PropertySet set = new PropertySetBuilder((IMObject)claim).build();
        DefaultLayoutContext layoutContext = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        AttachmentCollectionEditor editor = new AttachmentCollectionEditor((CollectionProperty)set.get("attachments"), (Act)claim, (LayoutContext)layoutContext);
        editor.getComponent();
        Semaphore semaphore = new Semaphore(0);
        MutableBoolean success = new MutableBoolean();
        generator.generate((Act)claim, this.insurer, editor, this.location, status -> {
            success.setValue(status);
            semaphore.release();
        });
        boolean done = false;
        for (int i = 0; i < 20; ++i) {
            ApplicationInstance.getActive().getUpdateManager().processClientUpdates();
            try {
                if (!semaphore.tryAcquire(1, 1L, TimeUnit.SECONDS)) continue;
                done = true;
                break;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertTrue((boolean)done);
        List acts = editor.getCurrentActs();
        if (error == null) {
            Assert.assertEquals((long)2L, (long)acts.size());
            Assert.assertTrue((boolean)success.booleanValue());
            this.checkAttachment("Patient History", "blank.pdf", acts);
            result = this.checkAttachment(name, documentName, acts);
        } else {
            Assert.assertFalse((boolean)success.booleanValue());
            DocumentAct failed = this.getAttachment(name, acts);
            Assert.assertEquals((Object)Attachment.Status.ERROR.toString(), (Object)failed.getStatus());
            Assert.assertEquals((Object)error, (Object)this.getBean((IMObject)failed).getString("error"));
        }
        return result;
    }

    private Document checkAttachment(String name, String fileName, List<Act> attachments) {
        DocumentAct attachment = this.getAttachment(name, attachments);
        Assert.assertEquals((Object)name, (Object)attachment.getName());
        Assert.assertEquals((Object)fileName, (Object)attachment.getFileName());
        Assert.assertEquals((Object)"application/pdf", (Object)attachment.getMimeType());
        Assert.assertEquals((Object)Attachment.Status.PENDING.toString(), (Object)attachment.getStatus());
        Document document = (Document)this.get(attachment.getDocument(), Document.class);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)fileName, (Object)document.getName());
        Assert.assertEquals((Object)"application/pdf", (Object)document.getMimeType());
        return document;
    }

    private DocumentAct getAttachment(String name, List<Act> attachments) {
        DocumentAct attachment = attachments.stream().filter(act -> name.equals(act.getName())).findFirst().orElse(null);
        Assert.assertNotNull((Object)attachment);
        return attachment;
    }

    private class DummyConverter
    implements DocumentConverter {
        private DummyConverter() {
        }

        public boolean canConvert(Document document, String mimeType) {
            return "application/pdf".equals(mimeType);
        }

        public boolean canConvert(String fileName, String sourceMimeType, String targetMimeType) {
            return "application/pdf".equals(targetMimeType);
        }

        public Document convert(Document document, String mimeType) {
            return ClaimAttachmentGeneratorTestCase.this.documentFactory.createPDF(FilenameUtils.getBaseName((String)document.getName()) + ".pdf");
        }

        public Document convert(Document document, String mimeType, boolean email) {
            return this.convert(document, mimeType);
        }

        public byte[] export(Document document, String mimeType, boolean email) {
            return new byte[0];
        }
    }
}

