/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.insurance.InsuranceTestHelper;
import org.openvpms.archetype.rules.laboratory.LaboratoryTestHelper;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.AuditableIMObject;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetBuilder;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.patient.insurance.claim.AttachmentCollectionEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class AttachmentCollectionEditorTestCase
extends AbstractAppTest {
    @Autowired
    private TestDocumentFactory documentFactory;

    @Test
    public void testDeleteGeneratedDocuments() {
        Party customer = TestHelper.createCustomer();
        Party patient = TestHelper.createPatient((Party)customer);
        Party insurer = InsuranceTestHelper.createInsurer((String)"Foo");
        Party location = TestHelper.createLocation();
        User clinician = TestHelper.createClinician();
        Act policy = InsuranceTestHelper.createPolicy((Party)customer, (Party)patient, (Party)insurer, (ActIdentity)TestHelper.createActIdentity((String)"actIdentity.insurancePolicy", (String)"POL123456"));
        this.save((IMObject)policy);
        FinancialAct item = InsuranceTestHelper.createClaimItem((String)"VENOM_328", (Date)new Date(), (Date)new Date(), (FinancialAct[])new FinancialAct[0]);
        FinancialAct claim = InsuranceTestHelper.createClaim((Act)policy, (Party)location, (User)clinician, (User)clinician, (FinancialAct[])new FinancialAct[]{item});
        this.save((IMObject[])new FinancialAct[]{claim, item});
        PropertySet set = new PropertySetBuilder((IMObject)claim).build();
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        FinancialAct invoice = this.createInvoice(customer, patient);
        AttachmentCollectionEditor editor = new AttachmentCollectionEditor((CollectionProperty)set.get("attachments"), (Act)claim, (LayoutContext)context);
        editor.getComponent();
        DocumentAct patientAttachment = PatientTestHelper.createDocumentAttachment((Date)new Date(), (Party)patient);
        DocumentAct patientForm = PatientTestHelper.createDocumentForm((Party)patient);
        DocumentAct patientImage = PatientTestHelper.createDocumentImage((Date)new Date(), (Party)patient);
        DocumentAct patientLetter = PatientTestHelper.createDocumentLetter((Date)new Date(), (Party)patient, (Act[])new Act[0]);
        DocumentAct patientInvestigation = PatientTestHelper.createInvestigation((Party)patient, (Entity)LaboratoryTestHelper.createInvestigationType());
        DocumentAct customerAttachment = this.createCustomerDocument("act.customerDocumentAttachment", customer);
        DocumentAct customerForm = this.createCustomerDocument("act.customerDocumentForm", customer);
        DocumentAct customerLetter = this.createCustomerDocument("act.customerDocumentLetter", customer);
        DocumentAct historyAttachment = editor.createHistory();
        editor.add((IMObject)historyAttachment);
        DocumentAct invoiceAttachment = this.checkAddInvoice(editor, invoice);
        DocumentAct claimAttachment = this.checkAddDocument(editor, patientAttachment);
        DocumentAct formAttachment = this.checkAddDocument(editor, patientForm);
        DocumentAct letterAttachment = editor.addDocument(patientLetter);
        DocumentAct imageAttachment = editor.addDocument(patientImage);
        DocumentAct investigationAttachment = editor.addDocument(patientInvestigation);
        DocumentAct customerClaimAttachment = this.checkAddDocument(editor, customerAttachment);
        DocumentAct customerFormAttachment = this.checkAddDocument(editor, customerForm);
        DocumentAct customerLetterAttachment = this.checkAddDocument(editor, customerLetter);
        editor.save();
        this.setDocument(historyAttachment);
        this.setDocument(invoiceAttachment);
        this.setDocument(claimAttachment);
        this.setDocument(formAttachment);
        this.setDocument(letterAttachment);
        this.setDocument(imageAttachment);
        this.setDocument(investigationAttachment);
        this.setDocument(customerClaimAttachment);
        this.setDocument(customerFormAttachment);
        this.setDocument(customerLetterAttachment);
        editor.deleteGeneratedDocuments();
        Assert.assertNull((Object)historyAttachment.getDocument());
        Assert.assertNull((Object)invoiceAttachment.getDocument());
        Assert.assertNotNull((Object)claimAttachment.getDocument());
        Assert.assertNull((Object)formAttachment.getDocument());
        Assert.assertNotNull((Object)letterAttachment.getDocument());
        Assert.assertNotNull((Object)imageAttachment.getDocument());
        Assert.assertNotNull((Object)investigationAttachment.getDocument());
        Assert.assertNotNull((Object)customerClaimAttachment.getDocument());
        Assert.assertNull((Object)customerFormAttachment.getDocument());
        Assert.assertNotNull((Object)customerLetterAttachment.getDocument());
    }

    private void setDocument(DocumentAct attachment) {
        Document document = (Document)this.documentFactory.createJRXML();
        attachment.setDocument((Reference)document.getObjectReference());
        this.save((IMObject[])new AuditableIMObject[]{document, attachment});
    }

    private DocumentAct checkAddInvoice(AttachmentCollectionEditor editor, FinancialAct invoice) {
        int size = editor.getCurrentActs().size();
        DocumentAct attachment = editor.addInvoice(invoice);
        Assert.assertEquals((long)(size + 1), (long)editor.getCurrentActs().size());
        Assert.assertEquals((Object)attachment, (Object)editor.addInvoice(invoice));
        Assert.assertEquals((long)(size + 1), (long)editor.getCurrentActs().size());
        return attachment;
    }

    private DocumentAct checkAddDocument(AttachmentCollectionEditor editor, DocumentAct act) {
        int size = editor.getCurrentActs().size();
        DocumentAct attachment = editor.addDocument(act);
        Assert.assertEquals((long)(size + 1), (long)editor.getCurrentActs().size());
        Assert.assertEquals((Object)attachment, (Object)editor.addDocument(act));
        Assert.assertEquals((long)(size + 1), (long)editor.getCurrentActs().size());
        return attachment;
    }

    private FinancialAct createInvoice(Party customer, Party patient) {
        List invoice = FinancialTestHelper.createChargesInvoice((BigDecimal)BigDecimal.TEN, (Party)customer, (Party)patient, (Product)TestHelper.createProduct(), (String)"POSTED");
        this.save(invoice);
        return (FinancialAct)invoice.get(0);
    }

    private DocumentAct createCustomerDocument(String archetype, Party customer) {
        DocumentAct act = (DocumentAct)this.create(archetype, DocumentAct.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("customer", (IMObject)customer);
        bean.save();
        return act;
    }
}

