/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryFlattener;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryFlattenerTest;
import org.openvpms.web.workspace.patient.history.PatientHistoryFlattener;

public class PatientHistoryFlattenerTestCase
extends AbstractPatientHistoryFlattenerTest {
    @Test
    public void testFlattener() {
        Party customer = TestHelper.createCustomer();
        Party patient = TestHelper.createPatient((Party)customer);
        User clinician = TestHelper.createClinician();
        String include = this.getReason("INCLUDE", true);
        String exclude = this.getReason("EXCLUDE", false);
        Act communication1 = this.createCommunication(TestHelper.getDatetime((String)"2019-07-02 09:00"), customer, patient, include);
        Act communication2 = this.createCommunication(TestHelper.getDatetime((String)"2019-07-02 15:00"), customer, patient, include);
        Act communication3 = this.createCommunication(TestHelper.getDatetime((String)"2019-07-03 09:00"), customer, patient, include);
        this.createCommunication(TestHelper.getDatetime((String)"2019-07-03 09:00"), customer, patient, exclude);
        Act weight = PatientTestHelper.createWeight((Date)TestHelper.getDatetime((String)"2019-07-03 10:00:00"), (Party)patient, (User)clinician);
        Act problemNote = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2019-07-03 10:06:00"), (Party)patient, (User)clinician);
        Act problem = PatientTestHelper.createProblem((Date)TestHelper.getDatetime((String)"2019-07-03 10:05:00"), (Party)patient, (User)clinician, (Act[])new Act[]{problemNote});
        Act communication4 = this.createCommunication(TestHelper.getDatetime((String)"2019-07-03 11:00"), customer, patient, null);
        Act event = PatientTestHelper.createEvent((Date)TestHelper.getDatetime((String)"2019-07-03 10:00:00"), (Party)patient, (User)clinician, (Act[])new Act[]{weight, problem, problemNote});
        Act communication5 = this.createCommunication(TestHelper.getDatetime((String)"2019-07-03 12:00"), customer, patient, null);
        Act communication6 = this.createCommunication(TestHelper.getDatetime((String)"2019-07-03 13:00"), customer, patient, null);
        String[] archetypes = new String[]{"act.patientClinicalProblem", "act.patientWeight", "act.patientMedication", "act.customerAccountInvoiceItem", "act.patientClinicalNote"};
        List<Act> ascending = Arrays.asList(communication1, communication2, communication3, event, communication4, communication5, communication6);
        ArrayList<Act> descending = new ArrayList<Act>(ascending);
        Collections.reverse(descending);
        PatientHistoryFlattener flattener = new PatientHistoryFlattener((ArchetypeService)this.getArchetypeService());
        this.check((AbstractPatientHistoryFlattener)flattener, ascending, archetypes, true, true, communication1, communication2, communication3, event, weight, problem, problemNote, communication4, communication5, communication6);
        this.check((AbstractPatientHistoryFlattener)flattener, ascending, archetypes, true, false, communication1, communication2, communication3, event, communication6, communication5, communication4, problem, problemNote, weight);
        this.check((AbstractPatientHistoryFlattener)flattener, descending, archetypes, false, false, event, communication6, communication5, communication4, problem, problemNote, weight, communication3, communication2, communication1);
        this.check((AbstractPatientHistoryFlattener)flattener, descending, archetypes, false, true, event, weight, problem, problemNote, communication4, communication5, communication6, communication3, communication2, communication1);
    }

    @Test
    public void testSameTimestamp() {
        Party customer = TestHelper.createCustomer();
        Party patient = TestHelper.createPatient((Party)customer);
        User clinician = TestHelper.createClinician();
        Date date = TestHelper.getDatetime((String)"2019-07-05 10:00:00");
        Act communication = this.createCommunication(date, customer, patient, null);
        Act note = PatientTestHelper.createNote((Date)date, (Party)patient, (User)clinician);
        Act event = PatientTestHelper.createEvent((Date)date, (Party)patient, (User)clinician, (Act[])new Act[]{note});
        List<Act> acts = Arrays.asList(communication, event);
        String[] archetypes = new String[]{"act.patientClinicalProblem", "act.patientWeight", "act.patientMedication", "act.customerAccountInvoiceItem", "act.patientClinicalNote"};
        PatientHistoryFlattener flattener = new PatientHistoryFlattener((ArchetypeService)this.getArchetypeService());
        this.check((AbstractPatientHistoryFlattener)flattener, acts, archetypes, true, true, event, communication, note);
    }

    private String getReason(String code, boolean include) {
        Lookup lookup = TestHelper.getLookup((String)"lookup.customerCommunicationReason", (String)code);
        IMObjectBean bean = this.getBean((IMObject)lookup);
        bean.setValue("showInPatientHistory", (Object)include);
        return lookup.getCode();
    }
}

