/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.estimate;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.estimate.EstimateTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.query.ResultSetIterator;
import org.openvpms.web.workspace.patient.estimate.PatientEstimateResultSet;

public class PatientEstimateResultSetTestCase
extends ArchetypeServiceTest {
    @Test
    public void testResultSet() {
        Party patient1 = TestHelper.createPatient();
        Party patient2 = TestHelper.createPatient();
        Product product1 = TestHelper.createProduct();
        Product product2 = TestHelper.createProduct();
        Party customer = TestHelper.createCustomer();
        ShortNameConstraint shortNames = new ShortNameConstraint("act.customerEstimation");
        ParticipantConstraint customerConstraint = new ParticipantConstraint("customer", "participation.customer", (Entity)customer);
        PatientEstimateResultSet set = new PatientEstimateResultSet(patient1, shortNames, customerConstraint, null, null, new String[0], 20, null);
        ResultSetIterator iterator = new ResultSetIterator((ResultSet)set);
        Assert.assertFalse((boolean)iterator.hasNext());
        Act item1 = EstimateTestHelper.createEstimateItem((Party)patient1, (Product)product1, (BigDecimal)BigDecimal.ONE);
        Act item2 = EstimateTestHelper.createEstimateItem((Party)patient2, (Product)product2, (BigDecimal)BigDecimal.ONE);
        Act estimate1 = EstimateTestHelper.createEstimate((Party)customer, (Act[])new Act[]{item1, item2});
        Act item3 = EstimateTestHelper.createEstimateItem((Party)patient1, (Product)product1, (BigDecimal)BigDecimal.ONE);
        Act item4 = EstimateTestHelper.createEstimateItem((Party)patient1, (Product)product2, (BigDecimal)BigDecimal.ONE);
        Act estimate2 = EstimateTestHelper.createEstimate((Party)customer, (Act[])new Act[]{item3, item4});
        Act item5 = EstimateTestHelper.createEstimateItem((Party)patient2, (Product)product1, (BigDecimal)BigDecimal.ONE);
        Act item6 = EstimateTestHelper.createEstimateItem((Party)patient2, (Product)product2, (BigDecimal)BigDecimal.ONE);
        Act estimate3 = EstimateTestHelper.createEstimate((Party)customer, (Act[])new Act[]{item5, item6});
        this.save((IMObject[])new Act[]{item1, item2, item3, item4, item4, item5, item6, estimate1, estimate2, estimate3});
        set.reset();
        iterator = new ResultSetIterator((ResultSet)set);
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)estimate2, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

