/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.charge;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.security.AuthenticationContextImpl;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.charge.AbstractCustomerChargeActEditorTest;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.EditorQueue;
import org.openvpms.web.workspace.patient.charge.VisitChargeEditor;

public class VisitChargeEditorTestCase
extends AbstractCustomerChargeActEditorTest {
    private Party patient;
    private User author;
    private User clinician;
    private LayoutContext layoutContext;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Party customer = TestHelper.createCustomer();
        this.patient = TestHelper.createPatient((Party)customer);
        this.author = TestHelper.createUser();
        this.clinician = TestHelper.createClinician();
        Party location = TestHelper.createLocation();
        this.layoutContext = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        this.layoutContext.setEdit(true);
        this.layoutContext.getContext().setPractice(this.getPractice());
        this.layoutContext.getContext().setCustomer(customer);
        this.layoutContext.getContext().setPatient(this.patient);
        this.layoutContext.getContext().setUser(this.author);
        this.layoutContext.getContext().setClinician(this.clinician);
        this.layoutContext.getContext().setLocation(location);
        new AuthenticationContextImpl().setUser(this.author);
    }

    @Test
    public void testNewInstance() {
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        Act event = (Act)this.create("act.patientClinicalEvent", Act.class);
        VisitChargeEditor editor = new VisitChargeEditor(charge, event, this.layoutContext);
        IMObjectEditor newInstance = editor.newInstance();
        Assert.assertTrue((boolean)(newInstance instanceof VisitChargeEditor));
        Assert.assertEquals((Object)charge, (Object)newInstance.getObject());
    }

    @Test
    public void testDeleteDocumentOnProductChange() {
        Act event = PatientTestHelper.createEvent((Party)this.patient);
        this.save((IMObject)event);
        Product product1 = this.productFactory.createService();
        Entity template1 = this.addDocumentTemplate(product1, "act.patientDocumentForm");
        Entity template2 = this.addDocumentTemplate(product1, "act.patientDocumentLetter");
        Product product2 = this.productFactory.createService();
        Product product3 = this.productFactory.createService();
        Entity template3 = this.addDocumentTemplate(product3, "act.patientDocumentLetter");
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        VisitChargeEditor editor = new VisitChargeEditor(charge, event, this.layoutContext, false);
        EditorQueue queue = editor.getItems().getEditorQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = editor.addItem();
        this.setItem((CustomerChargeActEditor)editor, itemEditor, this.patient, product1, BigDecimal.ONE, queue);
        this.save((CustomerChargeActEditor)editor);
        FinancialAct item = itemEditor.getObject();
        IMObjectBean bean = this.getBean((IMObject)item);
        Assert.assertEquals((long)2L, (long)bean.getTargets("documents").size());
        event = (Act)this.get((IMObject)event);
        DocumentAct document1 = this.checkDocument((Act)item, this.patient, product1, template1, this.author, this.clinician, false);
        DocumentAct document2 = this.checkDocument((Act)item, this.patient, product1, template2, this.author, this.clinician, true);
        this.checkEventRelationship(event, (Act)document1);
        this.checkEventRelationship(event, (Act)document2);
        itemEditor.setProduct(product2);
        this.save((CustomerChargeActEditor)editor);
        Assert.assertTrue((boolean)bean.getTargets("documents").isEmpty());
        Assert.assertNull((Object)this.get((IMObject)document1));
        Assert.assertNull((Object)this.get((IMObject)document2));
        Assert.assertNull((Object)this.get(document2.getDocument()));
        itemEditor.setProduct(product3);
        this.save((CustomerChargeActEditor)editor);
        Assert.assertEquals((long)1L, (long)bean.getTargets("documents").size());
        this.checkDocument((Act)item, this.patient, product3, template3, this.author, this.clinician, true);
    }
}

