/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestEFTPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestEFTRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestRefundBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.delete.Deletable;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandlerFactory;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.customer.payment.PaymentDeletionHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class PaymentDeletionHandlerTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectEditorFactory factory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private CustomerAccountRules rules;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    private Party customer;
    private Entity till;

    @Before
    public void setUp() {
        super.setUp();
        this.customer = this.customerFactory.createCustomer();
        this.till = this.practiceFactory.createTill();
    }

    @Test
    public void testDelete() {
        FinancialAct payment = this.createPayment("IN_PROGRESS");
        FinancialAct refund = this.createRefund("IN_PROGRESS");
        this.checkDelete(payment);
        this.checkDelete(refund);
    }

    @Test
    public void testDeletePosted() {
        FinancialAct payment = this.createPayment("IN_PROGRESS");
        FinancialAct refund = this.createRefund("IN_PROGRESS");
        this.checkDeletePosted(payment);
        this.checkDeletePosted(refund);
    }

    @Test
    public void testDeleteWithOutstandingEFT() {
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.practiceFactory.createTill())).customer(this.customer)).location(this.practiceFactory.createLocation())).eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).addTransaction("DECLINED", terminal)).addTransaction("IN_PROGRESS", terminal)).add()).build();
        FinancialAct refund = (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.practiceFactory.createTill())).customer(this.customer)).location(this.practiceFactory.createLocation())).eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).addTransaction("DECLINED", terminal)).addTransaction("IN_PROGRESS", terminal)).add()).build();
        this.checkDeleteWithOutstandingEFT(payment);
        this.checkDeleteWithOutstandingEFT(refund);
    }

    @Test
    public void testDeleteWithApprovedEFT() {
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.practiceFactory.createTill())).customer(this.customer)).location(this.practiceFactory.createLocation())).eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).addTransaction("DECLINED", terminal)).addTransaction("APPROVED", terminal)).add()).build();
        FinancialAct refund = (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.practiceFactory.createTill())).customer(this.customer)).location(this.practiceFactory.createLocation())).eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).addTransaction("DECLINED", terminal)).addTransaction("APPROVED", terminal)).add()).build();
        this.checkDeleteWithApprovedEFT(payment);
        this.checkDeleteWithApprovedEFT(refund);
    }

    @Test
    public void testDeleteWithNoTerminalEFT() {
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.practiceFactory.createTill())).customer(this.customer)).location(this.practiceFactory.createLocation())).eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).addTransaction("DECLINED", terminal)).addTransaction("NO_TERMINAL", terminal)).add()).build();
        List<FinancialAct> paymentEFT = this.getEFTTransactions(payment);
        Assert.assertEquals((long)3L, (long)paymentEFT.size());
        FinancialAct refund = (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.practiceFactory.createTill())).customer(this.customer)).location(this.practiceFactory.createLocation())).eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).addTransaction("DECLINED", terminal)).addTransaction("NO_TERMINAL", terminal)).add()).build();
        List<FinancialAct> refundEFT = this.getEFTTransactions(refund);
        Assert.assertEquals((long)3L, (long)refundEFT.size());
        this.checkDeleteWithNoTerminalEFT(payment, paymentEFT);
        this.checkDeleteWithNoTerminalEFT(refund, refundEFT);
    }

    @Test
    public void testDeactivate() {
        FinancialAct payment = this.createPayment("IN_PROGRESS");
        FinancialAct refund = this.createPayment("IN_PROGRESS");
        this.checkDeactivate(payment);
        this.checkDeactivate(refund);
    }

    @Test
    public void testFactory() {
        FinancialAct payment = this.createPayment("POSTED");
        FinancialAct refund = this.createRefund("POSTED");
        IMObjectDeletionHandlerFactory factory = new IMObjectDeletionHandlerFactory(this.getArchetypeService());
        Assert.assertNotNull((Object)this.applicationContext);
        factory.setApplicationContext(this.applicationContext);
        Assert.assertTrue((boolean)(factory.create((IMObject)payment) instanceof PaymentDeletionHandler));
        Assert.assertTrue((boolean)(factory.create((IMObject)refund) instanceof PaymentDeletionHandler));
    }

    protected PaymentDeletionHandler createDeletionHandler(FinancialAct act) {
        return new PaymentDeletionHandler(act, this.factory, ServiceHelper.getTransactionManager(), ServiceHelper.getArchetypeService(), this.rules);
    }

    private void checkDeleteWithOutstandingEFT(FinancialAct act) {
        PaymentDeletionHandler handler = this.createDeletionHandler(act);
        Deletable deletable = handler.getDeletable();
        Assert.assertFalse((boolean)deletable.canDelete());
        Assert.assertEquals((Object)("Cannot delete " + this.getDisplayName((IMObject)act) + ". It has an outstanding EFTPOS transaction."), (Object)deletable.getReason());
        try {
            handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)this.get((IMObject)act));
    }

    private void checkDeleteWithApprovedEFT(FinancialAct act) {
        PaymentDeletionHandler handler = this.createDeletionHandler(act);
        Deletable deletable = handler.getDeletable();
        Assert.assertFalse((boolean)deletable.canDelete());
        Assert.assertEquals((Object)("Cannot delete " + this.getDisplayName((IMObject)act) + ". It has an approved EFTPOS transaction."), (Object)deletable.getReason());
        try {
            handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)this.get((IMObject)act));
    }

    private void checkDeleteWithNoTerminalEFT(FinancialAct act, List<FinancialAct> eft) {
        PaymentDeletionHandler handler = this.createDeletionHandler(act);
        Deletable deletable = handler.getDeletable();
        Assert.assertTrue((boolean)deletable.canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)act));
        for (FinancialAct transaction : eft) {
            if ("NO_TERMINAL".equals(transaction.getStatus())) {
                Assert.assertNull((Object)this.get((IMObject)transaction));
                continue;
            }
            Assert.assertNotNull((Object)this.get((IMObject)transaction));
        }
    }

    private void checkDelete(FinancialAct act) {
        act.setStatus("IN_PROGRESS");
        this.save((IMObject)act);
        PaymentDeletionHandler handler = this.createDeletionHandler(act);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)act));
    }

    private void checkDeletePosted(FinancialAct act) {
        act.setStatus("POSTED");
        this.save((IMObject)act);
        PaymentDeletionHandler handler = this.createDeletionHandler(act);
        Deletable deletable = handler.getDeletable();
        Assert.assertFalse((boolean)deletable.canDelete());
        Assert.assertEquals((Object)("Cannot delete " + this.getDisplayName((IMObject)act) + ". It has been finalised."), (Object)deletable.getReason());
        try {
            handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)this.get((IMObject)act));
    }

    private void checkDeactivate(FinancialAct act) {
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)act.getStatus());
        PaymentDeletionHandler handler1 = this.createDeletionHandler(act);
        Assert.assertFalse((boolean)handler1.canDeactivate());
        try {
            handler1.deactivate();
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        act.setStatus("POSTED");
        PaymentDeletionHandler handler2 = this.createDeletionHandler(act);
        Assert.assertFalse((boolean)handler2.canDeactivate());
        try {
            handler2.deactivate();
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private FinancialAct createPayment(String status) {
        return (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(this.customer)).till(this.till)).status(status)).eft().amount(100)).add()).build();
    }

    private FinancialAct createRefund(String status) {
        return (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().customer(this.customer)).till(this.till)).status(status)).eft().amount(100)).add()).build();
    }

    private List<FinancialAct> getEFTTransactions(FinancialAct act) {
        ArrayList<FinancialAct> result = new ArrayList<FinancialAct>();
        for (FinancialAct item : this.getBean((IMObject)act).getTargets("items", FinancialAct.class)) {
            result.addAll(this.getBean((IMObject)item).getTargets("eft", FinancialAct.class));
        }
        return result;
    }
}

