/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestEFTPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestEFTRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestRefundBuilder;
import org.openvpms.archetype.test.builder.eft.TestEFTPOSPaymentBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.customer.payment.EFTPaymentItemEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class EFTPaymentItemEditorTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Test
    public void testValidationForPostedParentWithInProgressTransaction() {
        Party customer = this.customerFactory.createCustomer();
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        FinancialAct transaction = this.createEFTPOSPayment(customer, terminal, this.practiceFactory.createLocation(), "IN_PROGRESS");
        FinancialAct item = this.createEFTPaymentItem(transaction);
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(customer)).till(this.practiceFactory.createTill())).status("POSTED")).add(new FinancialAct[]{item})).build(false);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        EFTPaymentItemEditor editor = new EFTPaymentItemEditor(item, payment, (LayoutContext)context);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"Cannot finalise Payment. It has an outstanding EFTPOS transaction.");
        payment.setStatus("IN_PROGRESS");
        Assert.assertTrue((boolean)editor.isValid());
    }

    @Test
    public void testCanDelete() {
        Party customer = this.customerFactory.createCustomer();
        Party location = this.practiceFactory.createLocation();
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        FinancialAct transaction = this.createEFTPOSPayment(customer, terminal, this.practiceFactory.createLocation(), "PENDING");
        FinancialAct item = this.createEFTPaymentItem(transaction);
        FinancialAct payment = this.createPayment(customer, location, this.practiceFactory.createTill(), item);
        this.checkCanDelete(item, payment, transaction, "PENDING", false);
        this.checkCanDelete(item, payment, transaction, "IN_PROGRESS", false);
        this.checkCanDelete(item, payment, transaction, "APPROVED", false);
        this.checkCanDelete(item, payment, transaction, "ERROR", true);
        this.checkCanDelete(item, payment, transaction, "DECLINED", true);
    }

    @Test
    public void testRequiresEFTTransaction() {
        Party customer = this.customerFactory.createCustomer();
        Party location = this.practiceFactory.createLocation();
        Entity till1 = this.practiceFactory.createTill();
        FinancialAct item1 = this.createEFTPaymentItem();
        FinancialAct payment1 = this.createPayment(customer, location, till1, item1);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)payment1.getStatus());
        EFTPaymentItemEditor editor1 = this.createEditor(item1, payment1);
        Assert.assertFalse((boolean)editor1.requiresEFTTransaction());
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        Entity till2 = (Entity)this.practiceFactory.newTill().terminals(new Entity[]{terminal}).build();
        FinancialAct item2 = this.createEFTPaymentItem();
        FinancialAct payment2 = this.createPayment(customer, location, till2, item2);
        EFTPaymentItemEditor editor2 = this.createEditor(item2, payment2);
        Assert.assertTrue((boolean)editor2.requiresEFTTransaction());
        this.checkRequiresEFTTransaction("PENDING", true);
        this.checkRequiresEFTTransaction("IN_PROGRESS", true);
        this.checkRequiresEFTTransaction("DECLINED", true);
        this.checkRequiresEFTTransaction("ERROR", true);
        this.checkRequiresEFTTransaction("APPROVED", false);
    }

    @Test
    public void testRequiresEFTTransactionForPostedAct() {
        Party customer = this.customerFactory.createCustomer();
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        Party location = this.practiceFactory.createLocation();
        Entity till = (Entity)this.practiceFactory.newTill().terminals(new Entity[]{terminal}).build();
        FinancialAct item1 = this.createEFTPaymentItem();
        FinancialAct payment1 = this.createPayment(customer, location, till, item1);
        payment1.setStatus("POSTED");
        this.save((IMObject)payment1);
        EFTPaymentItemEditor editor1 = this.createEditor(item1, payment1);
        Assert.assertFalse((boolean)editor1.requiresEFTTransaction());
    }

    @Test
    public void testNoTerminalPayment() {
        Party customer = this.customerFactory.createCustomer();
        Party location = this.practiceFactory.createLocation();
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        Entity till = (Entity)this.practiceFactory.newTill().terminals(new Entity[]{terminal}).build();
        FinancialAct item1 = this.createEFTPaymentItem();
        FinancialAct payment = this.createPayment(customer, location, till, item1);
        this.checkNoTerminalPaymentRefund(payment, item1, location);
    }

    @Test
    public void testNoTerminalRefund() {
        Party customer = this.customerFactory.createCustomer();
        Party location = this.practiceFactory.createLocation();
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        Entity till = (Entity)this.practiceFactory.newTill().terminals(new Entity[]{terminal}).build();
        FinancialAct item1 = this.createEFTRefundItem();
        FinancialAct refund = this.createRefund(customer, location, till, item1);
        this.checkNoTerminalPaymentRefund(refund, item1, location);
    }

    private void checkRequiresEFTTransaction(String status, boolean required) {
        Party customer = this.customerFactory.createCustomer();
        Party location = this.practiceFactory.createLocation();
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        FinancialAct transaction = this.createEFTPOSPayment(customer, terminal, this.practiceFactory.createLocation(), status);
        Entity till = (Entity)this.practiceFactory.newTill().terminals(new Entity[]{terminal}).build();
        FinancialAct item = this.createEFTPaymentItem(transaction);
        FinancialAct payment = this.createPayment(customer, location, till, item);
        EFTPaymentItemEditor editor = this.createEditor(item, payment);
        Assert.assertEquals((Object)required, (Object)editor.requiresEFTTransaction());
    }

    private void checkNoTerminalPaymentRefund(FinancialAct act, FinancialAct item, Party location) {
        Assert.assertNull((Object)this.getBean((IMObject)item).getTarget("eft", FinancialAct.class));
        EFTPaymentItemEditor editor = this.createEditor(item, act);
        Assert.assertTrue((boolean)editor.requiresEFTTransaction());
        Assert.assertTrue((boolean)editor.noTerminalTransactionRequired());
        editor.eft(() -> {});
        Assert.assertFalse((boolean)editor.requiresEFTTransaction());
        FinancialAct transaction = (FinancialAct)this.getBean((IMObject)item).getTarget("eft", FinancialAct.class);
        Assert.assertNotNull((Object)transaction);
        if (item.isA("act.customerAccountPaymentEFT")) {
            Assert.assertEquals((Object)"act.EFTPOSPayment", (Object)transaction.getArchetype());
        } else {
            Assert.assertEquals((Object)"act.EFTPOSRefund", (Object)transaction.getArchetype());
        }
        Assert.assertEquals((Object)"NO_TERMINAL", (Object)transaction.getStatus());
        this.checkEquals(item.getTotal(), transaction.getTotal());
        Assert.assertEquals((Object)location.getObjectReference(), (Object)this.getBean((IMObject)transaction).getTargetRef("location"));
    }

    private FinancialAct createEFTPaymentItem() {
        return (FinancialAct)((TestEFTPaymentItemBuilder)this.accountFactory.newEFTPaymentItem().amount(BigDecimal.TEN)).build(false);
    }

    private FinancialAct createEFTPaymentItem(FinancialAct transaction) {
        return (FinancialAct)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)this.accountFactory.newEFTPaymentItem().addTransaction(transaction)).amount(BigDecimal.TEN)).build(false);
    }

    private FinancialAct createEFTRefundItem() {
        return (FinancialAct)((TestEFTRefundItemBuilder)this.accountFactory.newEFTRefundItem().amount(BigDecimal.TEN)).build(false);
    }

    private FinancialAct createPayment(Party customer, Party location, Entity till, FinancialAct item) {
        return (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(customer)).location(location)).till(till)).add(new FinancialAct[]{item})).status("IN_PROGRESS")).build();
    }

    private FinancialAct createRefund(Party customer, Party location, Entity till, FinancialAct item) {
        return (FinancialAct)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().customer(customer)).location(location)).till(till)).add(new FinancialAct[]{item})).status("IN_PROGRESS")).build();
    }

    private FinancialAct createEFTPOSPayment(Party customer, Entity terminal, Party location, String status) {
        return (FinancialAct)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)this.accountFactory.newEFTPOSPayment().customer(customer)).amount(BigDecimal.TEN)).terminal(terminal)).location(location)).status(status)).build();
    }

    private EFTPaymentItemEditor createEditor(FinancialAct item, FinancialAct payment) {
        LocalContext localContext = new LocalContext();
        Party location = (Party)this.getBean((IMObject)payment).getTarget("location", Party.class);
        localContext.setLocation(location);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)localContext, new HelpContext("foo", null));
        EFTPaymentItemEditor editor = new EFTPaymentItemEditor(item, payment, (LayoutContext)context);
        editor.getComponent();
        return editor;
    }

    private void checkCanDelete(FinancialAct item, FinancialAct payment, FinancialAct transaction, String status, boolean canDelete) {
        transaction.setStatus(status);
        this.save((IMObject)transaction);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        EFTPaymentItemEditor editor = new EFTPaymentItemEditor(item, payment, (LayoutContext)context);
        Assert.assertEquals((Object)canDelete, (Object)editor.canDelete());
        if (canDelete) {
            Assert.assertNull((Object)editor.getDeletionStatus());
        } else {
            Assert.assertEquals((Object)status, (Object)editor.getDeletionStatus());
        }
    }
}

