/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestEFTPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestRefundBuilder;
import org.openvpms.archetype.test.builder.eft.TestEFTPOSPaymentBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.Editors;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.edit.payment.PaymentItemEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentEditor;
import org.openvpms.web.workspace.customer.payment.EFTPaymentItemEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomerPaymentEditorTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Test
    public void testCannotChangeTill() {
        Party customer = this.customerFactory.createCustomer();
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        FinancialAct transaction = (FinancialAct)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)this.accountFactory.newEFTPOSPayment().customer(customer)).amount(BigDecimal.TEN)).terminal(terminal)).location(this.practiceFactory.createLocation())).status("PENDING")).build();
        FinancialAct item = (FinancialAct)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)this.accountFactory.newEFTPaymentItem().addTransaction(transaction)).amount(BigDecimal.TEN)).build(false);
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(customer)).till(this.practiceFactory.createTill())).add(new FinancialAct[]{item})).build();
        CustomerPaymentEditor editor = this.createEditor(payment);
        editor.setTill(this.practiceFactory.createTill());
    }

    @Test
    public void testMakeSaveableAndPostOnCompletion() {
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(this.customerFactory.createCustomer())).till(this.practiceFactory.createTill())).status("POSTED")).build(false);
        CustomerPaymentEditor editor = this.createEditor(payment);
        Assert.assertEquals((Object)"POSTED", (Object)editor.getObject().getStatus());
        Assert.assertFalse((boolean)editor.postOnCompletion());
        Assert.assertTrue((boolean)editor.canChangeStatus());
        editor.makeSaveableAndPostOnCompletion();
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)editor.getObject().getStatus());
        Assert.assertTrue((boolean)editor.postOnCompletion());
        Assert.assertTrue((boolean)editor.canChangeStatus());
    }

    @Test
    public void testMakeSaveableAndPostOnCompletionForPostedTranaction() {
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(this.customerFactory.createCustomer())).till(this.practiceFactory.createTill())).cash(10).status("POSTED")).build();
        CustomerPaymentEditor editor = this.createEditor(payment);
        Assert.assertTrue((boolean)editor.isPosted());
        Assert.assertFalse((boolean)editor.canChangeStatus());
        try {
            editor.makeSaveableAndPostOnCompletion();
            Assert.fail((String)"Expected makeSaveableAndPostOnCompletion to throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testCanEditEFTItemForActPostedDuringEdit() {
        Party customer = this.customerFactory.createCustomer();
        Entity till = this.practiceFactory.createTill();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(customer)).till(till)).eft(10)).status("IN_PROGRESS")).build();
        this.checkCanEditEFTItemForActPostedDuringEdit(payment);
        FinancialAct refund = (FinancialAct)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().customer(customer)).till(till)).eft(10)).status("IN_PROGRESS")).build();
        this.checkCanEditEFTItemForActPostedDuringEdit(refund);
    }

    private void checkCanEditEFTItemForActPostedDuringEdit(FinancialAct act) {
        CustomerPaymentEditor editor1 = this.createEditor(act);
        Assert.assertFalse((boolean)editor1.isPosted());
        Assert.assertTrue((boolean)editor1.canChangeStatus());
        editor1.setStatus("POSTED");
        Assert.assertTrue((boolean)editor1.isPosted());
        Assert.assertTrue((boolean)editor1.canChangeStatus());
        boolean payment = act.isA("act.customerAccountPayment");
        String archetype = payment ? "act.customerAccountPaymentEFT" : "act.customerAccountRefundEFT";
        PaymentItemEditor itemEditor1 = editor1.addItem(archetype);
        Assert.assertTrue((boolean)(itemEditor1 instanceof EFTPaymentItemEditor));
        Editors editors = ((EFTPaymentItemEditor)itemEditor1).getEditors();
        if (payment) {
            Editor cashout = editors.getEditor("cashout");
            Assert.assertNotNull((Object)cashout);
        }
        Editor amount = editors.getEditor("amount");
        Assert.assertNotNull((Object)amount);
        itemEditor1.setAmount(BigDecimal.TEN);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        CustomerPaymentEditor editor2 = this.createEditor(act);
        Assert.assertTrue((boolean)editor2.isPosted());
        Assert.assertFalse((boolean)editor2.canChangeStatus());
        List eftItemEditors = editor2.getEFTItemEditors();
        Assert.assertEquals((long)2L, (long)eftItemEditors.size());
        for (EFTPaymentItemEditor editor : eftItemEditors) {
            Editors editors2 = editor.getEditors();
            if (payment) {
                Assert.assertNull((Object)editors2.getEditor("cashout"));
            }
            Assert.assertNull((Object)editors2.getEditor("amount"));
        }
    }

    private CustomerPaymentEditor createEditor(FinancialAct act) {
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        context.setEdit(true);
        CustomerPaymentEditor editor = new CustomerPaymentEditor(act, null, (LayoutContext)context);
        editor.getComponent();
        return editor;
    }
}

