/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import java.util.List;
import nextapp.echo2.app.WindowPane;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.AbstractTestEFTPaymentRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.AbstractTestPaymentRefundBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestRefundBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.error.DialogErrorHandler;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.error.ErrorHandler;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.payment.AbstractCustomerPaymentEditor;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentEditDialog;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomerPaymentEditDialogTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;

    public void setUp() {
        super.setUp();
        ErrorHandler.setInstance((ErrorHandler)new DialogErrorHandler());
    }

    @Test
    public void testConfirmOnCancel() {
        FinancialAct payment1 = this.createCashPayment("IN_PROGRESS");
        this.checkConfirmOnCancel(payment1, true);
        FinancialAct payment2 = this.createCashPayment("ON_HOLD");
        this.checkConfirmOnCancel(payment2, false);
        FinancialAct payment3 = this.createCashPayment("POSTED");
        this.checkConfirmOnCancel(payment3, false);
        FinancialAct refund1 = this.createCashRefund("IN_PROGRESS");
        this.checkConfirmOnCancel(refund1, true);
        FinancialAct refund2 = this.createCashRefund("ON_HOLD");
        this.checkConfirmOnCancel(refund2, false);
        FinancialAct refund3 = this.createCashRefund("POSTED");
        this.checkConfirmOnCancel(refund3, false);
    }

    @Test
    public void testEFTConfirmDeleteOnCancel() {
        FinancialAct payment1 = this.createEFTPayment("IN_PROGRESS");
        this.checkEFTConfirmDeleteOnCancel(payment1, true);
        FinancialAct payment2 = this.createEFTPayment("ON_HOLD");
        this.checkEFTConfirmDeleteOnCancel(payment2, false);
        FinancialAct payment3 = this.createEFTPayment("POSTED");
        this.checkEFTConfirmDeleteOnCancel(payment3, false);
        FinancialAct refund1 = this.createEFTRefund("IN_PROGRESS");
        this.checkEFTConfirmDeleteOnCancel(refund1, true);
        FinancialAct refund2 = this.createEFTRefund("ON_HOLD");
        this.checkEFTConfirmDeleteOnCancel(refund2, false);
        FinancialAct refund3 = this.createEFTRefund("POSTED");
        this.checkEFTConfirmDeleteOnCancel(refund3, false);
    }

    @Test
    public void testEFTRejectDeleteOnCancel() {
        FinancialAct payment1 = this.createEFTPayment("IN_PROGRESS");
        this.checkEFTRejectDeleteOnCancel(payment1, true);
        FinancialAct payment2 = this.createEFTPayment("ON_HOLD");
        this.checkEFTRejectDeleteOnCancel(payment2, false);
        FinancialAct payment3 = this.createEFTPayment("POSTED");
        this.checkEFTRejectDeleteOnCancel(payment3, false);
        FinancialAct refund1 = this.createEFTRefund("IN_PROGRESS");
        this.checkEFTRejectDeleteOnCancel(refund1, true);
        FinancialAct refund2 = this.createEFTRefund("ON_HOLD");
        this.checkEFTRejectDeleteOnCancel(refund2, false);
        FinancialAct refund3 = this.createEFTRefund("POSTED");
        this.checkEFTRejectDeleteOnCancel(refund3, false);
    }

    @Test
    public void testEFTAlreadyDeletedOnCancel() {
        FinancialAct payment = this.createEFTPayment("IN_PROGRESS");
        this.checkEFTAlreadyDeletedOnCancel(payment);
        FinancialAct refund = this.createEFTPayment("IN_PROGRESS");
        this.checkEFTAlreadyDeletedOnCancel(refund);
    }

    @Test
    public void testEFTDeleteOnCancelButModifiedByAnotherUser() {
        FinancialAct payment1 = this.createEFTPayment("IN_PROGRESS");
        LayoutContext context = this.createLayoutContext();
        CustomerPaymentEditor editor = this.createEditor(payment1, context);
        final MutableBoolean closed = new MutableBoolean();
        CustomerPaymentEditDialog dialog = new CustomerPaymentEditDialog((AbstractCustomerPaymentEditor)editor, context.getContext());
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                closed.setTrue();
            }
        });
        dialog.show();
        FinancialAct updated = (FinancialAct)((TestPaymentBuilder)this.accountFactory.updatePayment((FinancialAct)this.get((IMObject)payment1)).eft(100)).build();
        Assert.assertTrue((updated.getVersion() > payment1.getVersion() ? 1 : 0) != 0);
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"cancel");
        String confirmation = "This " + this.getDisplayName((IMObject)payment1) + " has been saved.\n\nDo you want to delete it?";
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)"Cancel", (String)confirmation, (String)"yes");
        Assert.assertFalse((boolean)closed.isTrue());
        EchoTestHelper.findMessageDialogAndFireButton(ErrorDialog.class, (String)"Delete failed", (String)("The " + this.getDisplayName((IMObject)payment1) + " could not be deleted. It may have been changed by another user."), (String)"ok");
        AbstractCustomerPaymentEditor newEditor = dialog.getEditor();
        Assert.assertNotSame((Object)editor, (Object)newEditor);
        Assert.assertEquals((Object)updated, (Object)newEditor.getObject());
        Assert.assertEquals((long)updated.getVersion(), (long)newEditor.getObject().getVersion());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"cancel");
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)"Cancel", (String)confirmation, (String)"yes");
        Assert.assertNull((Object)this.get((IMObject)payment1));
        Assert.assertTrue((boolean)closed.isTrue());
    }

    @Test
    public void testEditorReloadedOnEFTError() {
        this.checkEditorReloadedOnEFTError((AbstractTestPaymentRefundBuilder<?>)this.accountFactory.newPayment(), "apply");
        this.checkEditorReloadedOnEFTError((AbstractTestPaymentRefundBuilder<?>)this.accountFactory.newPayment(), "ok");
        this.checkEditorReloadedOnEFTError((AbstractTestPaymentRefundBuilder<?>)this.accountFactory.newRefund(), "apply");
        this.checkEditorReloadedOnEFTError((AbstractTestPaymentRefundBuilder<?>)this.accountFactory.newRefund(), "ok");
    }

    private void checkConfirmOnCancel(FinancialAct act, boolean prompt) {
        LayoutContext context = this.createLayoutContext();
        CustomerPaymentEditor editor = this.createEditor(act, context);
        final MutableBoolean closed = new MutableBoolean();
        CustomerPaymentEditDialog dialog = new CustomerPaymentEditDialog((AbstractCustomerPaymentEditor)editor, context.getContext());
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                closed.setTrue();
            }
        });
        dialog.show();
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"cancel");
        if (prompt) {
            EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)"Cancel", (String)("This " + this.getDisplayName((IMObject)act) + " was saved but has not been finalised.\n\nCancel editing?"), (String)"yes");
        } else {
            Assert.assertNull((Object)EchoTestHelper.findWindowPane(ConfirmationDialog.class));
        }
        Assert.assertNotNull((Object)this.get((IMObject)act));
        Assert.assertTrue((boolean)closed.isTrue());
    }

    private void checkEFTConfirmDeleteOnCancel(FinancialAct act, boolean prompt) {
        LayoutContext context = this.createLayoutContext();
        CustomerPaymentEditor editor = this.createEditor(act, context);
        final MutableBoolean closed = new MutableBoolean();
        CustomerPaymentEditDialog dialog = new CustomerPaymentEditDialog((AbstractCustomerPaymentEditor)editor, context.getContext());
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                closed.setTrue();
            }
        });
        dialog.show();
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"cancel");
        if (prompt) {
            EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)"Cancel", (String)("This " + this.getDisplayName((IMObject)act) + " has been saved.\n\nDo you want to delete it?"), (String)"yes");
            Assert.assertNull((Object)this.get((IMObject)act));
        } else {
            Assert.assertNull((Object)EchoTestHelper.findWindowPane(ConfirmationDialog.class));
            Assert.assertNotNull((Object)this.get((IMObject)act));
        }
        Assert.assertTrue((boolean)closed.isTrue());
    }

    private void checkEFTRejectDeleteOnCancel(FinancialAct act, boolean prompt) {
        LayoutContext context = this.createLayoutContext();
        CustomerPaymentEditor editor = this.createEditor(act, context);
        final MutableBoolean closed = new MutableBoolean();
        CustomerPaymentEditDialog dialog = new CustomerPaymentEditDialog((AbstractCustomerPaymentEditor)editor, context.getContext());
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                closed.setTrue();
            }
        });
        dialog.show();
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"cancel");
        if (prompt) {
            EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)"Cancel", (String)("This " + this.getDisplayName((IMObject)act) + " has been saved.\n\nDo you want to delete it?"), (String)"no");
        } else {
            Assert.assertNull((Object)EchoTestHelper.findWindowPane(ConfirmationDialog.class));
        }
        Assert.assertNotNull((Object)this.get((IMObject)act));
        Assert.assertTrue((boolean)closed.isTrue());
    }

    private void checkEFTAlreadyDeletedOnCancel(FinancialAct act) {
        LayoutContext context = this.createLayoutContext();
        CustomerPaymentEditor editor = this.createEditor(act, context);
        final MutableBoolean closed = new MutableBoolean();
        CustomerPaymentEditDialog dialog = new CustomerPaymentEditDialog((AbstractCustomerPaymentEditor)editor, context.getContext());
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                closed.setTrue();
            }
        });
        dialog.show();
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"cancel");
        this.remove((IMObject)act);
        Assert.assertNull((Object)this.get((IMObject)act));
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)"Cancel", (String)("This " + this.getDisplayName((IMObject)act) + " has been saved.\n\nDo you want to delete it?"), (String)"yes");
        Assert.assertTrue((boolean)closed.isTrue());
        Assert.assertNull((Object)this.get((IMObject)act));
        Assert.assertNull((Object)EchoTestHelper.findWindowPane(WindowPane.class));
    }

    private void checkEditorReloadedOnEFTError(AbstractTestPaymentRefundBuilder<?> builder, String button) {
        Entity till = this.practiceFactory.createTill();
        Party location = (Party)this.practiceFactory.newLocation().tills(new Entity[]{till}).build();
        FinancialAct act = (FinancialAct)((AbstractTestPaymentRefundBuilder)((AbstractTestEFTPaymentRefundItemBuilder)((AbstractTestEFTPaymentRefundItemBuilder)((AbstractTestPaymentRefundBuilder)((AbstractTestPaymentRefundBuilder)builder.customer(this.customerFactory.createCustomer())).location(location)).till(till).eft().amount(10)).addTransaction("PENDING", this.practiceFactory.createEFTPOSTerminal())).add().status("IN_PROGRESS")).build();
        List items = builder.getItems();
        Assert.assertEquals((long)1L, (long)items.size());
        FinancialAct item = (FinancialAct)items.get(0);
        LayoutContext context = this.createLayoutContext();
        context.getContext().setLocation(location);
        CustomerPaymentEditor editor = this.createEditor(act, context);
        final MutableBoolean closed = new MutableBoolean();
        CustomerPaymentEditDialog dialog = new CustomerPaymentEditDialog((AbstractCustomerPaymentEditor)editor, context.getContext());
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                closed.setTrue();
            }
        });
        dialog.show();
        this.remove((IMObject)item);
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)button);
        String displayName = this.getDisplayName((IMObject)act);
        EchoTestHelper.findMessageDialogAndFireButton(ErrorDialog.class, (String)("Failed to save " + displayName), (String)("The " + displayName + " could not be saved. It may have been changed by another user.\n\nYour changes have been reverted."), (String)"ok");
        Assert.assertFalse((boolean)closed.isTrue());
        AbstractCustomerPaymentEditor newEditor = dialog.getEditor();
        Assert.assertNotSame((Object)editor, (Object)newEditor);
    }

    private LayoutContext createLayoutContext() {
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        context.setEdit(true);
        return context;
    }

    private CustomerPaymentEditor createEditor(FinancialAct act, LayoutContext context) {
        CustomerPaymentEditor editor = new CustomerPaymentEditor(act, null, context);
        editor.getComponent();
        return editor;
    }

    private FinancialAct createCashPayment(String status) {
        return (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(this.customerFactory.createCustomer())).till(this.practiceFactory.createTill())).cash(10).status(status)).build();
    }

    private FinancialAct createEFTPayment(String status) {
        return (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(this.customerFactory.createCustomer())).till(this.practiceFactory.createTill())).eft(10)).status(status)).build();
    }

    private FinancialAct createCashRefund(String status) {
        return (FinancialAct)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().customer(this.customerFactory.createCustomer())).till(this.practiceFactory.createTill())).cash(10).status(status)).build();
    }

    private FinancialAct createEFTRefund(String status) {
        return (FinancialAct)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().customer(this.customerFactory.createCustomer())).till(this.practiceFactory.createTill())).eft(10)).status(status)).build();
    }
}

