/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.order;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.finance.order.OrderRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.hl7.TestHL7Factory;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.patient.TestInvestigationBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.security.AuthenticationContextImpl;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.charge.AbstractCustomerChargeActEditorTest;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditDialog;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeTestHelper;
import org.openvpms.web.workspace.customer.charge.TestChargeEditor;
import org.openvpms.web.workspace.customer.charge.TestPharmacyOrderService;
import org.openvpms.web.workspace.customer.order.OrderInvoicer;
import org.openvpms.web.workspace.customer.order.PharmacyOrderInvoicer;
import org.openvpms.web.workspace.customer.order.PharmacyTestHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class PharmacyOrderInvoicerTestCase
extends AbstractCustomerChargeActEditorTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestHL7Factory hl7Factory;
    @Autowired
    private TestLaboratoryFactory laboratoryFactory;
    @Autowired
    private OrderRules rules;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestUserFactory userFactory;
    private IArchetypeService service;
    private Context context;
    private Party customer;
    private Party patient;
    private User author;
    private User clinician;
    private Product product;
    private BigDecimal fixedPriceIncTax;
    private BigDecimal unitPriceIncTax;
    private Party stockLocation;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Assert.assertNotNull((Object)this.applicationContext);
        this.service = (IArchetypeService)this.applicationContext.getBean("archetypeService", IArchetypeService.class);
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal unitPrice = new BigDecimal("9.09");
        this.fixedPriceIncTax = BigDecimal.valueOf(2L);
        this.unitPriceIncTax = BigDecimal.TEN;
        this.stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party location = (Party)this.practiceFactory.newLocation().stockControl(true).stockLocation(this.stockLocation).build();
        Entity pharmacy = this.hl7Factory.createHL7Pharmacy(location, this.userFactory.createUser());
        this.product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).unitPrice(unitPrice)).concentration(1).newDose().minWeight(0).maxWeight(10).rate(10).quantity(1).add().pharmacy(pharmacy)).stockQuantity(this.stockLocation, 10)).build();
        this.clinician = this.userFactory.createClinician();
        this.customer = this.customerFactory.createCustomer();
        this.patient = this.patientFactory.createPatient(this.customer);
        this.patientFactory.createWeight(this.patient, BigDecimal.ONE, WeightUnits.KILOGRAMS);
        this.context = new LocalContext();
        this.context.setPractice(this.getPractice());
        this.context.setLocation(location);
        this.author = this.userFactory.createUser();
        this.context.setUser(this.author);
        this.context.setClinician(this.clinician);
        this.context.setPatient(this.patient);
        this.context.setCustomer(this.customer);
        new AuthenticationContextImpl().setUser(this.author);
    }

    @Test
    public void testChargeUnlinkedOrder() {
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal tax = BigDecimal.valueOf(2L);
        BigDecimal total = new BigDecimal("22");
        Date startTime = TestHelper.getDate((String)"2017-07-01");
        this.setProductPriceDates(startTime);
        FinancialAct order = PharmacyTestHelper.createOrder(startTime, this.customer, this.patient, this.product, quantity, null);
        TestPharmacyOrderInvoicer charger = new TestPharmacyOrderInvoicer(order, this.clinician, this.rules, this.service);
        Assert.assertTrue((boolean)charger.isValid());
        Assert.assertTrue((boolean)charger.canInvoice());
        Assert.assertFalse((boolean)charger.canCredit());
        Date now = new Date();
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        layoutContext.setEdit(true);
        CustomerChargeActEditDialog dialog = charger.charge(null, null, (LayoutContext)layoutContext);
        TestChargeEditor editor = (TestChargeEditor)dialog.getEditor();
        CustomerChargeTestHelper.checkSavePopup(editor.getQueue(), "act.patientMedication", false);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        FinancialAct charge = (FinancialAct)this.get((IMObject)editor.getObject());
        Assert.assertTrue((boolean)charge.isA("act.customerAccountChargesInvoice"));
        IMObjectBean item = this.checkItem(charge, "act.customerAccountInvoiceItem", this.patient, this.product, quantity, this.unitPriceIncTax, this.fixedPriceIncTax, tax, total, quantity, null);
        Assert.assertEquals((Object)startTime, (Object)item.getDate("startTime"));
        this.checkCharge(charge, this.customer, this.author, this.clinician, tax, total);
        Assert.assertTrue((DateRules.compareTo((Date)charge.getActivityStartTime(), (Date)now, (boolean)true) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreditUnlinkedReturn() {
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal tax = BigDecimal.valueOf(2L);
        BigDecimal total = new BigDecimal("22");
        Date startTime = TestHelper.getDate((String)"2017-07-01");
        this.setProductPriceDates(startTime);
        FinancialAct orderReturn = PharmacyTestHelper.createReturn(startTime, this.customer, this.patient, this.product, quantity, null);
        TestPharmacyOrderInvoicer charger = new TestPharmacyOrderInvoicer(orderReturn, this.clinician, this.rules, this.service);
        Assert.assertTrue((boolean)charger.isValid());
        Assert.assertTrue((boolean)charger.canCredit());
        Assert.assertTrue((boolean)charger.canInvoice());
        Date now = new Date();
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        layoutContext.setEdit(true);
        CustomerChargeActEditDialog dialog = charger.charge(null, null, (LayoutContext)layoutContext);
        TestChargeEditor editor = (TestChargeEditor)dialog.getEditor();
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        FinancialAct charge = (FinancialAct)this.get((IMObject)editor.getObject());
        Assert.assertTrue((boolean)charge.isA("act.customerAccountChargesCredit"));
        IMObjectBean item = this.checkItem(charge, "act.customerAccountCreditItem", this.patient, this.product, quantity, this.unitPriceIncTax, this.fixedPriceIncTax, tax, total, null, null);
        Assert.assertEquals((Object)startTime, (Object)item.getDate("startTime"));
        this.checkCharge(charge, this.customer, this.author, this.clinician, tax, total);
        Assert.assertTrue((DateRules.compareTo((Date)charge.getActivityStartTime(), (Date)now, (boolean)true) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testChargeLinkedOrderWithSameQuantity() {
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal tax = BigDecimal.valueOf(2L);
        BigDecimal total = new BigDecimal("22");
        TestChargeEditor editor1 = this.createInvoice(this.product, quantity);
        editor1.setStatus("IN_PROGRESS");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        FinancialAct invoice = editor1.getObject();
        FinancialAct invoiceItem = this.getInvoiceItem(editor1);
        FinancialAct order = PharmacyTestHelper.createOrder(this.customer, this.patient, this.product, quantity, invoiceItem);
        TestPharmacyOrderInvoicer charger = new TestPharmacyOrderInvoicer(order, this.clinician, this.rules, this.service);
        Assert.assertTrue((boolean)charger.isValid());
        Assert.assertTrue((boolean)charger.canInvoice());
        Assert.assertFalse((boolean)charger.canCredit());
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        layoutContext.setEdit(true);
        CustomerChargeActEditDialog dialog = charger.charge(invoice, null, (LayoutContext)layoutContext);
        TestChargeEditor editor2 = (TestChargeEditor)dialog.getEditor();
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor2));
        FinancialAct charge = (FinancialAct)this.get((IMObject)editor2.getObject());
        Assert.assertEquals((Object)invoice, (Object)charge);
        this.checkItem(charge, "act.customerAccountInvoiceItem", this.patient, this.product, quantity, this.unitPriceIncTax, this.fixedPriceIncTax, tax, total, quantity, null);
        this.checkCharge(charge, this.customer, this.author, this.clinician, tax, total);
    }

    @Test
    public void testChargeLinkedOrderWithGreaterQuantity() {
        BigDecimal originalQty = BigDecimal.valueOf(1L);
        BigDecimal newQty = BigDecimal.valueOf(2L);
        BigDecimal newTax = BigDecimal.valueOf(2L);
        BigDecimal newTotal = new BigDecimal("22");
        TestChargeEditor editor1 = this.createInvoice(this.product, originalQty);
        editor1.setStatus("IN_PROGRESS");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        FinancialAct invoice = editor1.getObject();
        FinancialAct invoiceItem = this.getInvoiceItem(editor1);
        FinancialAct order = PharmacyTestHelper.createOrder(this.customer, this.patient, this.product, newQty, invoiceItem);
        TestPharmacyOrderInvoicer charger = new TestPharmacyOrderInvoicer(order, this.clinician, this.rules, this.service);
        Assert.assertTrue((boolean)charger.isValid());
        Assert.assertTrue((boolean)charger.canInvoice());
        Assert.assertFalse((boolean)charger.canCredit());
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        layoutContext.setEdit(true);
        CustomerChargeActEditDialog dialog = charger.charge(invoice, null, (LayoutContext)layoutContext);
        TestChargeEditor editor2 = (TestChargeEditor)dialog.getEditor();
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor2));
        FinancialAct charge = (FinancialAct)this.get((IMObject)editor2.getObject());
        Assert.assertEquals((Object)invoice, (Object)charge);
        this.checkItem(charge, "act.customerAccountInvoiceItem", this.patient, this.product, newQty, this.unitPriceIncTax, this.fixedPriceIncTax, newTax, newTotal, newQty, null);
        this.checkCharge(charge, this.customer, this.author, this.clinician, newTax, newTotal);
    }

    @Test
    public void testChargeLinkedOrderWithGreaterQuantityToPostedInvoice() {
        BigDecimal originalQty = BigDecimal.valueOf(1L);
        BigDecimal newOrderQty = BigDecimal.valueOf(2L);
        BigDecimal newQty = BigDecimal.valueOf(1L);
        BigDecimal newTax = new BigDecimal("1.09");
        BigDecimal newTotal = BigDecimal.valueOf(12L);
        TestChargeEditor editor1 = this.createInvoice(this.product, originalQty);
        editor1.setStatus("POSTED");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        FinancialAct invoice = editor1.getObject();
        FinancialAct invoiceItem = this.getInvoiceItem(editor1);
        FinancialAct order = PharmacyTestHelper.createOrder(this.customer, this.patient, this.product, newOrderQty, invoiceItem);
        TestPharmacyOrderInvoicer charger = new TestPharmacyOrderInvoicer(order, this.clinician, this.rules, this.service);
        Assert.assertTrue((boolean)charger.isValid());
        Assert.assertTrue((boolean)charger.canInvoice());
        Assert.assertFalse((boolean)charger.canCredit());
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        layoutContext.setEdit(true);
        CustomerChargeActEditDialog dialog = charger.charge(null, null, (LayoutContext)layoutContext);
        TestChargeEditor editor = (TestChargeEditor)dialog.getEditor();
        CustomerChargeTestHelper.checkSavePopup(editor.getQueue(), "act.patientMedication", false);
        TestChargeEditor editor2 = (TestChargeEditor)dialog.getEditor();
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor2));
        FinancialAct charge = (FinancialAct)this.get((IMObject)editor2.getObject());
        Assert.assertNotEquals((Object)invoice, (Object)charge);
        this.checkItem(charge, "act.customerAccountInvoiceItem", this.patient, this.product, newQty, this.unitPriceIncTax, this.fixedPriceIncTax, new BigDecimal("1.091"), newTotal, newOrderQty, null);
        this.checkCharge(charge, this.customer, this.author, this.clinician, newTax, newTotal);
    }

    @Test
    public void testChargeLinkedOrderWithLesserQuantityToInProgressInvoice() {
        BigDecimal originalQty = BigDecimal.valueOf(2L);
        BigDecimal newQty = BigDecimal.valueOf(1L);
        BigDecimal newTax = new BigDecimal("1.09");
        BigDecimal newTotal = BigDecimal.valueOf(12L);
        TestChargeEditor editor1 = this.createInvoice(this.product, originalQty);
        editor1.setStatus("IN_PROGRESS");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        FinancialAct invoice = editor1.getObject();
        FinancialAct invoiceItem = this.getInvoiceItem(editor1);
        FinancialAct order = PharmacyTestHelper.createOrder(this.customer, this.patient, this.product, newQty, invoiceItem);
        TestPharmacyOrderInvoicer charger = new TestPharmacyOrderInvoicer(order, this.clinician, this.rules, this.service);
        Assert.assertTrue((boolean)charger.isValid());
        Assert.assertTrue((boolean)charger.canInvoice());
        Assert.assertTrue((boolean)charger.canCredit());
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        layoutContext.setEdit(true);
        CustomerChargeActEditDialog dialog = charger.charge(invoice, null, (LayoutContext)layoutContext);
        TestChargeEditor editor2 = (TestChargeEditor)dialog.getEditor();
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor2));
        FinancialAct charge = (FinancialAct)this.get((IMObject)editor2.getObject());
        Assert.assertTrue((boolean)charge.isA("act.customerAccountChargesInvoice"));
        this.checkItem(charge, "act.customerAccountInvoiceItem", this.patient, this.product, newQty, this.unitPriceIncTax, this.fixedPriceIncTax, new BigDecimal("1.091"), newTotal, newQty, null);
        this.checkCharge(charge, this.customer, this.author, this.clinician, newTax, newTotal);
    }

    @Test
    public void testChargeLinkedOrderWithLesserQuantityToPostedInvoice() {
        BigDecimal originalQty = BigDecimal.valueOf(2L);
        BigDecimal newQty = BigDecimal.valueOf(1L);
        BigDecimal newTax = new BigDecimal("1.09");
        BigDecimal newTotal = BigDecimal.valueOf(12L);
        TestChargeEditor editor1 = this.createInvoice(this.product, originalQty);
        editor1.setStatus("POSTED");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        FinancialAct invoiceItem = this.getInvoiceItem(editor1);
        FinancialAct order = PharmacyTestHelper.createOrder(this.customer, this.patient, this.product, newQty, invoiceItem);
        TestPharmacyOrderInvoicer charger = new TestPharmacyOrderInvoicer(order, this.clinician, this.rules, this.service);
        Assert.assertTrue((boolean)charger.isValid());
        Assert.assertFalse((boolean)charger.canInvoice());
        Assert.assertTrue((boolean)charger.canCredit());
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        layoutContext.setEdit(true);
        CustomerChargeActEditDialog dialog = charger.charge(null, null, (LayoutContext)layoutContext);
        TestChargeEditor editor2 = (TestChargeEditor)dialog.getEditor();
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor2));
        FinancialAct charge = (FinancialAct)this.get((IMObject)editor2.getObject());
        Assert.assertTrue((boolean)charge.isA("act.customerAccountChargesCredit"));
        this.checkItem(charge, "act.customerAccountCreditItem", this.patient, this.product, newQty, this.unitPriceIncTax, this.fixedPriceIncTax, new BigDecimal("1.091"), newTotal, newQty, null);
        this.checkCharge(charge, this.customer, this.author, this.clinician, newTax, newTotal);
    }

    @Test
    public void testMultipleLinkedOrderToInProgressInvoice() {
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal tax = BigDecimal.valueOf(2L);
        BigDecimal total = new BigDecimal("22");
        TestChargeEditor editor = this.createInvoice(this.product, quantity);
        editor.setStatus("IN_PROGRESS");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        FinancialAct invoice = editor.getObject();
        FinancialAct invoiceItem = this.getInvoiceItem(editor);
        FinancialAct order1 = PharmacyTestHelper.createOrder(this.customer, this.patient, this.product, BigDecimal.ONE, invoiceItem);
        TestPharmacyOrderInvoicer charger1 = new TestPharmacyOrderInvoicer(order1, this.clinician, this.rules, this.service);
        Assert.assertTrue((boolean)charger1.canCharge((CustomerChargeActEditor)editor));
        charger1.charge((CustomerChargeActEditor)editor);
        FinancialAct order2 = PharmacyTestHelper.createOrder(this.customer, this.patient, this.product, BigDecimal.ONE, invoiceItem);
        TestPharmacyOrderInvoicer charger2 = new TestPharmacyOrderInvoicer(order2, this.clinician, this.rules, this.service);
        Assert.assertTrue((boolean)charger2.canCharge((CustomerChargeActEditor)editor));
        charger2.charge((CustomerChargeActEditor)editor);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        this.checkItem(invoice, "act.customerAccountInvoiceItem", this.patient, this.product, quantity, this.unitPriceIncTax, this.fixedPriceIncTax, tax, total, quantity, null);
        this.checkCharge(invoice, this.customer, this.author, this.clinician, tax, total);
    }

    @Test
    public void testOrderAndReturnToInProgressInvoice() {
        TestChargeEditor editor = this.createInvoice(this.product, BigDecimal.ONE);
        editor.setStatus("IN_PROGRESS");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        FinancialAct invoice = editor.getObject();
        FinancialAct invoiceItem = this.getInvoiceItem(editor);
        FinancialAct order = PharmacyTestHelper.createOrder(this.customer, this.patient, this.product, BigDecimal.ONE, invoiceItem);
        TestPharmacyOrderInvoicer charger1 = new TestPharmacyOrderInvoicer(order, this.clinician, this.rules, this.service);
        Assert.assertTrue((boolean)charger1.canCharge((CustomerChargeActEditor)editor));
        charger1.charge((CustomerChargeActEditor)editor);
        FinancialAct orderReturn = PharmacyTestHelper.createReturn(this.customer, this.patient, this.product, BigDecimal.ONE, invoiceItem);
        TestPharmacyOrderInvoicer charger2 = new TestPharmacyOrderInvoicer(orderReturn, this.clinician, this.rules, this.service);
        Assert.assertTrue((boolean)charger2.canCharge((CustomerChargeActEditor)editor));
        charger2.charge((CustomerChargeActEditor)editor);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        this.checkItem(invoice, "act.customerAccountInvoiceItem", this.patient, this.product, BigDecimal.ZERO, this.unitPriceIncTax, this.fixedPriceIncTax, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ONE);
        this.checkCharge(invoice, this.customer, this.author, this.clinician, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    @Test
    public void testOrderToPostedInvoice() {
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal tax = BigDecimal.valueOf(2L);
        BigDecimal total = new BigDecimal("22");
        TestChargeEditor editor = this.createInvoice(this.product, quantity);
        editor.setStatus("POSTED");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        FinancialAct invoiceItem = this.getInvoiceItem(editor);
        this.checkItem(editor.getObject(), "act.customerAccountInvoiceItem", this.patient, this.product, quantity, this.unitPriceIncTax, this.fixedPriceIncTax, tax, total, null, null);
        FinancialAct order1 = PharmacyTestHelper.createOrder(this.customer, this.patient, this.product, quantity, invoiceItem);
        TestPharmacyOrderInvoicer charger1 = new TestPharmacyOrderInvoicer(order1, this.clinician, this.rules, this.service);
        Assert.assertTrue((boolean)charger1.isValid());
        Assert.assertTrue((boolean)charger1.canInvoice());
        Assert.assertFalse((boolean)charger1.canCredit());
        Assert.assertFalse((boolean)charger1.requiresEdit());
        charger1.charge();
        this.checkItem(editor.getObject(), "act.customerAccountInvoiceItem", this.patient, this.product, quantity, this.unitPriceIncTax, this.fixedPriceIncTax, tax, total, quantity, null);
        FinancialAct order2 = PharmacyTestHelper.createOrder(this.customer, this.patient, this.product, quantity, invoiceItem);
        TestPharmacyOrderInvoicer charger2 = new TestPharmacyOrderInvoicer(order2, this.clinician, this.rules, this.service);
        Assert.assertTrue((boolean)charger2.isValid());
        Assert.assertTrue((boolean)charger2.canInvoice());
        Assert.assertFalse((boolean)charger2.canCredit());
        Assert.assertTrue((boolean)charger2.requiresEdit());
        FinancialAct return1 = PharmacyTestHelper.createReturn(this.customer, this.patient, this.product, quantity, invoiceItem);
        TestPharmacyOrderInvoicer charger3 = new TestPharmacyOrderInvoicer(return1, this.clinician, this.rules, this.service);
        Assert.assertTrue((boolean)charger3.isValid());
        Assert.assertFalse((boolean)charger3.canInvoice());
        Assert.assertTrue((boolean)charger3.canCredit());
        Assert.assertTrue((boolean)charger3.requiresEdit());
    }

    @Test
    public void testReturnToPostedInvoice() {
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal tax = BigDecimal.valueOf(2L);
        BigDecimal total = new BigDecimal("22");
        TestChargeEditor editor1 = this.createInvoice(this.product, quantity);
        editor1.setStatus("IN_PROGRESS");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        FinancialAct invoiceItem = this.getInvoiceItem(editor1);
        FinancialAct order = PharmacyTestHelper.createOrder(this.customer, this.patient, this.product, quantity, invoiceItem);
        TestPharmacyOrderInvoicer charger1 = new TestPharmacyOrderInvoicer(order, this.clinician, this.rules, this.service);
        Assert.assertTrue((boolean)charger1.canCharge((CustomerChargeActEditor)editor1));
        charger1.charge((CustomerChargeActEditor)editor1);
        editor1.setStatus("POSTED");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        FinancialAct orderReturn = PharmacyTestHelper.createReturn(this.customer, this.patient, this.product, quantity, invoiceItem);
        TestPharmacyOrderInvoicer charger2 = new TestPharmacyOrderInvoicer(orderReturn, this.clinician, this.rules, this.service);
        Assert.assertFalse((boolean)charger2.canCharge((CustomerChargeActEditor)editor1));
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        layoutContext.setEdit(true);
        CustomerChargeActEditDialog dialog = charger2.charge(null, null, (LayoutContext)layoutContext);
        TestChargeEditor editor2 = (TestChargeEditor)dialog.getEditor();
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor2));
        FinancialAct charge = (FinancialAct)this.get((IMObject)editor2.getObject());
        Assert.assertTrue((boolean)charge.isA("act.customerAccountChargesCredit"));
        this.checkItem(charge, "act.customerAccountCreditItem", this.patient, this.product, quantity, this.unitPriceIncTax, this.fixedPriceIncTax, tax, total, null, null);
        this.checkCharge(charge, this.customer, this.author, this.clinician, tax, total);
    }

    @Test
    public void testRemoveUnsavedInvoiceItemLinkedToOrder() {
        BigDecimal quantity = BigDecimal.valueOf(2L);
        TestChargeEditor editor = this.createEditor();
        editor.setStatus("IN_PROGRESS");
        FinancialAct order = PharmacyTestHelper.createOrder(this.customer, this.patient, this.product, quantity, null);
        TestPharmacyOrderInvoicer charger = new TestPharmacyOrderInvoicer(order, this.clinician, this.rules, this.service);
        Assert.assertTrue((boolean)charger.canCharge((CustomerChargeActEditor)editor));
        charger.charge((CustomerChargeActEditor)editor);
        List items = editor.getItems().getCurrentActs();
        Assert.assertEquals((long)1L, (long)items.size());
        editor.getItems().remove((IMObject)items.get(0));
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        TestPharmacyOrderService pharmacyOrderService = editor.getPharmacyOrderService();
        Assert.assertTrue((boolean)pharmacyOrderService.getOrders().isEmpty());
        Assert.assertEquals((Object)"POSTED", (Object)order.getStatus());
        order = (FinancialAct)this.get((IMObject)order);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)order.getStatus());
    }

    @Test
    public void testMissingCustomer() {
        String expected = "Customer is required";
        FinancialAct act1 = PharmacyTestHelper.createOrder(null, this.patient, this.product, BigDecimal.ONE, null);
        this.checkRequired(act1, expected);
        FinancialAct act2 = PharmacyTestHelper.createReturn(null, this.patient, this.product, BigDecimal.ONE, null);
        this.checkRequired(act2, expected);
    }

    @Test
    public void testMissingPatient() {
        String expected = "Patient is required";
        FinancialAct act1 = PharmacyTestHelper.createOrder(this.customer, null, this.product, BigDecimal.ONE, null);
        this.checkRequired(act1, expected);
        FinancialAct act2 = PharmacyTestHelper.createReturn(this.customer, null, this.product, BigDecimal.ONE, null);
        this.checkRequired(act2, expected);
    }

    @Test
    public void testMissingProduct() {
        String expected = "Product is required";
        FinancialAct act1 = PharmacyTestHelper.createOrder(this.customer, this.patient, null, BigDecimal.ONE, null);
        this.checkRequired(act1, expected);
        FinancialAct act2 = PharmacyTestHelper.createReturn(this.customer, this.patient, null, BigDecimal.ONE, null);
        this.checkRequired(act2, expected);
    }

    @Test
    public void testInvalidProduct() {
        String expected = "Product does not exist or is not valid for this field";
        Product template = this.productFactory.createTemplate();
        FinancialAct act1 = PharmacyTestHelper.createOrder(this.customer, this.patient, template, BigDecimal.ONE, null);
        this.checkRequired(act1, expected);
        FinancialAct act2 = PharmacyTestHelper.createReturn(this.customer, this.patient, template, BigDecimal.ONE, null);
        this.checkRequired(act2, expected);
    }

    @Test
    public void testApplyUnlinkedOrderReturnToInvoiceWithNoMatchingLineItem() {
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal unitPrice = new BigDecimal("9.09");
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).unitPrice(unitPrice)).build();
        BigDecimal five = BigDecimal.valueOf(5L);
        FinancialAct act1 = PharmacyTestHelper.createReturn(this.customer, this.patient, product, five, null);
        TestChargeEditor editor = this.createEditor();
        editor.setStatus("IN_PROGRESS");
        Party patient2 = this.patientFactory.createPatient(this.customer);
        this.addItem((CustomerChargeActEditor)editor, patient2, product, BigDecimal.ONE, editor.getQueue());
        TestPharmacyOrderInvoicer invoicer1 = new TestPharmacyOrderInvoicer(act1, this.clinician, this.rules, this.service);
        OrderInvoicer.Status status1 = invoicer1.getChargeStatus((CustomerChargeActEditor)editor);
        Assert.assertTrue((boolean)status1.canCharge());
        invoicer1.charge((CustomerChargeActEditor)editor);
        EchoTestHelper.findEditDialog();
        Assert.assertEquals((Object)"POSTED", (Object)act1.getStatus());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        FinancialAct charge1 = (FinancialAct)this.get((IMObject)editor.getObject());
        Assert.assertTrue((boolean)charge1.isA("act.customerAccountChargesInvoice"));
        BigDecimal quantity = new BigDecimal("-5");
        this.checkItem(charge1, "act.customerAccountInvoiceItem", this.patient, product, quantity, this.unitPriceIncTax, this.fixedPriceIncTax, new BigDecimal("-4.727"), new BigDecimal("-52"), null, null);
        this.checkItem(charge1, "act.customerAccountInvoiceItem", patient2, product, BigDecimal.ONE, this.unitPriceIncTax, this.fixedPriceIncTax, new BigDecimal("1.091"), new BigDecimal("12"), null, null);
        this.checkCharge(charge1, this.customer, this.author, this.clinician, new BigDecimal("-3.64"), new BigDecimal("-40"));
    }

    @Test
    public void testApplyUnlinkedOrderReturnToInvoiceWithExistingLineItem() {
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal unitPrice = new BigDecimal("9.09");
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).unitPrice(unitPrice)).build();
        List acts = FinancialTestHelper.createChargesInvoice((Party)this.customer, (Party)this.patient, (Product)product, (BigDecimal)BigDecimal.ONE, (BigDecimal)fixedPrice, (BigDecimal)unitPrice, (BigDecimal)BigDecimal.ZERO, (String)"IN_PROGRESS");
        this.save(acts);
        DocumentAct investigation1 = this.createInvestigation();
        investigation1.setStatus("POSTED");
        DocumentAct investigation2 = this.createInvestigation();
        investigation2.setStatus("IN_PROGRESS");
        Document document = (Document)this.documentFactory.createJRXML();
        investigation2.setDocument((Reference)document.getObjectReference());
        DocumentAct investigation3 = this.createInvestigation();
        FinancialAct item1 = (FinancialAct)acts.get(1);
        IMObjectBean bean = this.getBean((IMObject)item1);
        bean.addTarget("investigations", (IMObject)investigation1, "invoiceItems");
        bean.addTarget("investigations", (IMObject)investigation2, "invoiceItems");
        bean.addTarget("investigations", (IMObject)investigation3, "invoiceItems");
        bean.save(new IMObject[]{investigation1, investigation2, investigation3, document});
        FinancialAct invoice = (FinancialAct)acts.get(0);
        TestChargeEditor editor = this.createEditor(invoice);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        FinancialAct act1 = PharmacyTestHelper.createReturn(this.customer, this.patient, product, BigDecimal.valueOf(5L), null);
        TestPharmacyOrderInvoicer invoicer1 = new TestPharmacyOrderInvoicer(act1, this.clinician, this.rules, this.service);
        OrderInvoicer.Status status1 = invoicer1.getChargeStatus((CustomerChargeActEditor)editor);
        Assert.assertTrue((boolean)status1.canCharge());
        invoicer1.charge((CustomerChargeActEditor)editor);
        Assert.assertEquals((Object)"POSTED", (Object)act1.getStatus());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        FinancialAct charge1 = (FinancialAct)this.get((IMObject)editor.getObject());
        Assert.assertTrue((boolean)charge1.isA("act.customerAccountChargesInvoice"));
        BigDecimal tax = new BigDecimal("-3.818");
        BigDecimal total = new BigDecimal("-42");
        this.checkItem(charge1, "act.customerAccountInvoiceItem", this.patient, product, new BigDecimal("-4"), this.unitPriceIncTax, this.fixedPriceIncTax, tax, total, null, null);
        Assert.assertNull((Object)this.get((IMObject)item1));
        Assert.assertNotNull((Object)this.get((IMObject)investigation1));
        Assert.assertNotNull((Object)this.get((IMObject)investigation2));
        Assert.assertNull((Object)this.get((IMObject)investigation3));
    }

    @Test
    public void testApplyUnlinkedOrderReturnToInvoiceWithExistingLineItemDeletesItemWhenQuantityFallsToZero() {
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal unitPrice = new BigDecimal("9.09");
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).unitPrice(unitPrice)).build();
        TestChargeEditor editor = this.createEditor();
        editor.setStatus("IN_PROGRESS");
        CustomerChargeActItemEditor item1 = this.addItem((CustomerChargeActEditor)editor, this.patient, product, new BigDecimal("11"), editor.getQueue());
        CustomerChargeActItemEditor item2 = this.addItem((CustomerChargeActEditor)editor, this.patient, product, BigDecimal.ONE, editor.getQueue());
        FinancialAct act1 = PharmacyTestHelper.createReturn(this.customer, this.patient, product, new BigDecimal(5), null);
        TestPharmacyOrderInvoicer invoicer1 = new TestPharmacyOrderInvoicer(act1, this.clinician, this.rules, this.service);
        OrderInvoicer.Status status1 = invoicer1.getChargeStatus((CustomerChargeActEditor)editor);
        Assert.assertTrue((boolean)status1.canCharge());
        invoicer1.charge((CustomerChargeActEditor)editor);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        this.checkPosted((Act)act1);
        FinancialAct charge1 = (FinancialAct)this.get((IMObject)editor.getObject());
        Assert.assertTrue((boolean)charge1.isA("act.customerAccountChargesInvoice"));
        this.checkItems(charge1, 2);
        IMObjectBean bean1 = this.checkItem(charge1, "act.customerAccountInvoiceItem", this.patient, product, new BigDecimal("6"), this.unitPriceIncTax, this.fixedPriceIncTax, new BigDecimal("5.636"), new BigDecimal("62"), null, null);
        Assert.assertEquals((Object)bean1.getObject(), (Object)item1.getObject());
        IMObjectBean bean2 = this.checkItem(charge1, "act.customerAccountInvoiceItem", this.patient, product, BigDecimal.ONE, this.unitPriceIncTax, this.fixedPriceIncTax, new BigDecimal("1.091"), new BigDecimal("12"), null, null);
        Assert.assertEquals((Object)bean2.getObject(), (Object)item2.getObject());
        this.checkCharge(charge1, this.customer, this.author, this.clinician, new BigDecimal("6.73"), new BigDecimal("74"));
        FinancialAct act2 = PharmacyTestHelper.createReturn(this.customer, this.patient, product, BigDecimal.ONE, null);
        TestPharmacyOrderInvoicer invoicer2 = new TestPharmacyOrderInvoicer(act2, this.clinician, this.rules, this.service);
        invoicer2.charge((CustomerChargeActEditor)editor);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        this.checkPosted((Act)act2);
        FinancialAct charge2 = (FinancialAct)this.get((IMObject)editor.getObject());
        this.checkItems(charge2, 1);
        bean1 = this.checkItem(charge1, "act.customerAccountInvoiceItem", this.patient, product, new BigDecimal("6"), this.unitPriceIncTax, this.fixedPriceIncTax, new BigDecimal("5.636"), new BigDecimal("62"), null, null);
        Assert.assertEquals((Object)item1.getObject(), (Object)bean1.getObject());
        this.checkCharge(charge2, this.customer, this.author, this.clinician, new BigDecimal("5.64"), new BigDecimal("62"));
    }

    @Test
    public void testApplyUnlinkedOrderReturnsToInvoiceWithMinimumQuantity() {
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal unitPrice = new BigDecimal("9.09");
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).unitPrice(unitPrice)).build();
        TestChargeEditor editor = this.createEditor();
        editor.setStatus("IN_PROGRESS");
        CustomerChargeActItemEditor itemEditor = this.addItem((CustomerChargeActEditor)editor, this.patient, product, BigDecimal.ONE, editor.getQueue());
        itemEditor.setMinimumQuantity(BigDecimal.ONE);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        FinancialAct act1 = PharmacyTestHelper.createReturn(this.customer, this.patient, product, BigDecimal.ONE, null);
        TestPharmacyOrderInvoicer invoicer1 = new TestPharmacyOrderInvoicer(act1, this.clinician, this.rules, this.service);
        OrderInvoicer.Status status1 = invoicer1.getChargeStatus((CustomerChargeActEditor)editor);
        Assert.assertTrue((boolean)status1.canCharge());
        invoicer1.charge((CustomerChargeActEditor)editor);
        Assert.assertEquals((Object)"POSTED", (Object)act1.getStatus());
        this.checkEquals(BigDecimal.ZERO, itemEditor.getQuantity());
        Assert.assertFalse((boolean)SaveHelper.save((IMObjectEditor)editor));
        itemEditor.setMinimumQuantity(BigDecimal.ZERO);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
    }

    @Test
    public void testReturnAndOrderToInvoiceForSameProduct() {
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal unitPrice = new BigDecimal("9.09");
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).unitPrice(unitPrice)).build();
        TestChargeEditor editor = this.createEditor();
        editor.setStatus("IN_PROGRESS");
        FinancialAct act1 = PharmacyTestHelper.createReturn(this.customer, this.patient, product, BigDecimal.ONE, null);
        TestPharmacyOrderInvoicer invoicer1 = new TestPharmacyOrderInvoicer(act1, this.clinician, this.rules, this.service);
        invoicer1.charge((CustomerChargeActEditor)editor);
        FinancialAct act2 = PharmacyTestHelper.createOrder(this.customer, this.patient, product, BigDecimal.ONE, null);
        TestPharmacyOrderInvoicer invoicer2 = new TestPharmacyOrderInvoicer(act2, this.clinician, this.rules, this.service);
        invoicer2.charge((CustomerChargeActEditor)editor);
        Assert.assertEquals((Object)"POSTED", (Object)act1.getStatus());
        Assert.assertEquals((Object)"POSTED", (Object)act2.getStatus());
        CustomerChargeTestHelper.checkSavePopup(editor.getQueue(), "act.patientMedication", false);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        FinancialAct charge = editor.getObject();
        this.checkItems(charge, 2);
        this.checkItem(charge, "act.customerAccountInvoiceItem", this.patient, product, BigDecimal.ONE, this.unitPriceIncTax, this.fixedPriceIncTax, new BigDecimal("1.091"), new BigDecimal(12), BigDecimal.ONE, null);
        this.checkItem(charge, "act.customerAccountInvoiceItem", this.patient, product, new BigDecimal(-1), this.unitPriceIncTax, this.fixedPriceIncTax, new BigDecimal("-1.091"), new BigDecimal(-12), null, null);
        this.checkCharge(charge, this.customer, this.author, this.clinician, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    @Test
    public void testOrderAndReturnToInvoiceForSameProduct() {
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal unitPrice = new BigDecimal("9.09");
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).unitPrice(unitPrice)).build();
        TestChargeEditor editor = this.createEditor();
        editor.setStatus("IN_PROGRESS");
        FinancialAct act1 = PharmacyTestHelper.createOrder(this.customer, this.patient, product, BigDecimal.ONE, null);
        TestPharmacyOrderInvoicer invoicer1 = new TestPharmacyOrderInvoicer(act1, this.clinician, this.rules, this.service);
        invoicer1.charge((CustomerChargeActEditor)editor);
        Assert.assertFalse((boolean)editor.isValid());
        FinancialAct act2 = PharmacyTestHelper.createReturn(this.customer, this.patient, product, BigDecimal.ONE, null);
        TestPharmacyOrderInvoicer invoicer2 = new TestPharmacyOrderInvoicer(act2, this.clinician, this.rules, this.service);
        invoicer2.charge((CustomerChargeActEditor)editor);
        Assert.assertEquals((Object)"POSTED", (Object)act1.getStatus());
        Assert.assertEquals((Object)"POSTED", (Object)act2.getStatus());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        FinancialAct charge = editor.getObject();
        this.checkItems(charge, 0);
        this.checkCharge(charge, this.customer, this.author, this.clinician, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    @Test
    public void testOrderAndReturnToInvoiceForSameProductFollowedByNewOrder() {
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal unitPrice = new BigDecimal("9.09");
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).unitPrice(unitPrice)).build();
        TestChargeEditor editor = this.createEditor();
        editor.setStatus("IN_PROGRESS");
        FinancialAct act1 = PharmacyTestHelper.createOrder(this.customer, this.patient, product, BigDecimal.ONE, null);
        FinancialAct act2 = PharmacyTestHelper.createReturn(this.customer, this.patient, product, BigDecimal.ONE, null);
        FinancialAct act3 = PharmacyTestHelper.createOrder(this.customer, this.patient, product, BigDecimal.ONE, null);
        TestPharmacyOrderInvoicer invoicer1 = new TestPharmacyOrderInvoicer(act1, this.clinician, this.rules, this.service);
        invoicer1.charge((CustomerChargeActEditor)editor);
        Assert.assertFalse((boolean)editor.isValid());
        TestPharmacyOrderInvoicer invoicer2 = new TestPharmacyOrderInvoicer(act2, this.clinician, this.rules, this.service);
        invoicer2.charge((CustomerChargeActEditor)editor);
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertEquals((long)0L, (long)editor.getItems().getCurrentActs().size());
        TestPharmacyOrderInvoicer invoicer3 = new TestPharmacyOrderInvoicer(act3, this.clinician, this.rules, this.service);
        invoicer3.charge((CustomerChargeActEditor)editor);
        Assert.assertFalse((boolean)editor.isValid());
        CustomerChargeTestHelper.checkSavePopup(editor.getQueue(), "act.patientMedication", false);
        Assert.assertEquals((Object)"POSTED", (Object)act1.getStatus());
        Assert.assertEquals((Object)"POSTED", (Object)act2.getStatus());
        Assert.assertEquals((Object)"POSTED", (Object)act3.getStatus());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        FinancialAct charge = editor.getObject();
        this.checkItems(charge, 1);
        this.checkItem(charge, "act.customerAccountInvoiceItem", this.patient, product, BigDecimal.ONE, this.unitPriceIncTax, this.fixedPriceIncTax, new BigDecimal("1.091"), new BigDecimal(12), BigDecimal.ONE, null);
        this.checkCharge(charge, this.customer, this.author, this.clinician, new BigDecimal("1.09"), new BigDecimal(12));
    }

    private DocumentAct createInvestigation() {
        return (DocumentAct)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(this.patient)).investigationType(this.laboratoryFactory.createInvestigationType()).build();
    }

    private void checkPosted(Act act) {
        Assert.assertEquals((Object)"POSTED", (Object)act.getStatus());
    }

    private void checkItems(FinancialAct charge, int count) {
        Assert.assertEquals((long)count, (long)this.getBean((IMObject)charge).getValues("items").size());
    }

    private void checkRequired(FinancialAct act, String expected) {
        TestPharmacyOrderInvoicer charger = new TestPharmacyOrderInvoicer(act, this.clinician, this.rules, this.service);
        Assert.assertFalse((boolean)charger.isValid());
        DefaultValidator validator = new DefaultValidator();
        Assert.assertFalse((boolean)charger.validate((Validator)validator));
        Assert.assertEquals((long)1L, (long)validator.getInvalid().size());
        Modifiable modifiable = (Modifiable)validator.getInvalid().iterator().next();
        List errors = validator.getErrors(modifiable);
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertEquals((Object)expected, (Object)((ValidatorError)errors.get(0)).getMessage());
    }

    private TestChargeEditor createInvoice(Product product, BigDecimal quantity) {
        TestChargeEditor editor = this.createEditor();
        this.addItem((CustomerChargeActEditor)editor, this.patient, product, quantity, editor.getQueue());
        return editor;
    }

    private TestChargeEditor createEditor() {
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        return this.createEditor(charge);
    }

    private TestChargeEditor createEditor(FinancialAct charge) {
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        layoutContext.setEdit(true);
        TestChargeEditor editor = new TestChargeEditor(charge, (LayoutContext)layoutContext, false);
        editor.getComponent();
        return editor;
    }

    private FinancialAct getInvoiceItem(TestChargeEditor editor) {
        List acts = editor.getItems().getCurrentActs();
        Assert.assertEquals((long)1L, (long)acts.size());
        return (FinancialAct)acts.get(0);
    }

    private IMObjectBean checkItem(FinancialAct charge, String archetype, Party patient, Product product, BigDecimal quantity, BigDecimal unitPrice, BigDecimal fixedPrice, BigDecimal tax, BigDecimal total, BigDecimal receivedQuantity, BigDecimal returnedQuantity) {
        IMObjectBean bean = this.getBean((IMObject)charge);
        List items = bean.getTargets("items", FinancialAct.class);
        int childActs = charge.isA("act.customerAccountChargesInvoice") && quantity.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0;
        IMObjectBean itemBean = this.checkItem(items, archetype, patient, product, quantity, unitPrice, fixedPrice, tax, total, childActs);
        if (bean.isA(new String[]{"act.customerAccountChargesInvoice"})) {
            this.checkEquals(receivedQuantity, itemBean.getBigDecimal("receivedQuantity"));
            this.checkEquals(returnedQuantity, itemBean.getBigDecimal("returnedQuantity"));
        }
        Assert.assertEquals((Object)this.stockLocation, (Object)itemBean.getTarget("stockLocation"));
        return itemBean;
    }

    private IMObjectBean checkItem(List<FinancialAct> items, String archetype, Party patient, Product product, BigDecimal quantity, BigDecimal unitPrice, BigDecimal fixedPrice, BigDecimal tax, BigDecimal total, int childActs) {
        return this.checkItem(items, archetype, patient, product, null, -1, this.author, this.clinician, BigDecimal.ZERO, quantity, BigDecimal.ZERO, unitPrice, BigDecimal.ZERO, fixedPrice, BigDecimal.ZERO, tax, total, true, null, childActs);
    }

    private void setProductPriceDates(Date startTime) {
        for (ProductPrice prices : this.product.getProductPrices()) {
            prices.setFromDate(startTime);
        }
        this.save((IMObject)this.product);
    }

    private static class TestPharmacyOrderInvoicer
    extends PharmacyOrderInvoicer {
        public TestPharmacyOrderInvoicer(FinancialAct act, User clinician, OrderRules rules, IArchetypeService service) {
            super(act, clinician, rules, service);
        }

        protected CustomerChargeActEditor createChargeEditor(FinancialAct charge, LayoutContext context) {
            return new TestChargeEditor(charge, context, true);
        }
    }
}

