/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.estimate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.estimate.EstimateTestHelper;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.test.builder.lookup.TestCurrencyBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestMerchandiseProductBuilder;
import org.openvpms.component.business.service.security.AuthenticationContextImpl;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.charge.ChargeEditContext;
import org.openvpms.web.workspace.customer.estimate.AbstractEstimateEditorTestCase;
import org.openvpms.web.workspace.customer.estimate.EstimateItemEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class EstimateItemEditorTestCase
extends AbstractEstimateEditorTestCase {
    private final List<String> errors = new ArrayList<String>();
    @Autowired
    private TestLookupFactory lookupFactory;
    private Party customer;
    private Party patient;
    private User author;
    private Party location;
    private LayoutContext layout;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.customer = this.customerFactory.createCustomer();
        this.patient = this.patientFactory.createPatient();
        this.author = this.userFactory.createUser();
        this.location = this.practiceFactory.createLocation();
        this.initErrorHandler(this.errors);
        LocalContext context = new LocalContext();
        context.setPractice(this.getPractice());
        context.setLocation(this.location);
        context.setUser(this.author);
        this.layout = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        new AuthenticationContextImpl().setUser(this.author);
    }

    @Test
    public void testDiscounts() {
        BigDecimal lowQuantity = BigDecimal.ONE;
        BigDecimal highQuantity = BigDecimal.valueOf(2L);
        BigDecimal unitCost = BigDecimal.valueOf(5L);
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal unitPriceIncTax = BigDecimal.TEN;
        BigDecimal fixedCost = BigDecimal.valueOf(1L);
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal fixedPriceIncTax = BigDecimal.valueOf(2L);
        Entity discount = (Entity)this.productFactory.newDiscount().percentage(10).discountFixedPrice(true).build();
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedCost, fixedPrice)).unitPrice(unitCost, unitPrice)).addDiscounts(new Entity[]{discount})).build();
        this.addDiscount((Entity)this.patient, discount);
        Act item = (Act)this.create("act.customerEstimationItem", Act.class);
        Act estimate = EstimateTestHelper.createEstimate((Party)this.customer, (Act[])new Act[]{item});
        EstimateItemEditor editor = new EstimateItemEditor(item, estimate, new ChargeEditContext(this.customer, this.location, this.layout), this.layout);
        editor.getComponent();
        Assert.assertFalse((boolean)editor.isValid());
        editor.setPatient(this.patient);
        editor.setProduct(product);
        editor.setLowQuantity(lowQuantity);
        editor.setHighQuantity(highQuantity);
        Assert.assertTrue((boolean)editor.isValid());
        this.checkSave(estimate, editor);
        item = (Act)this.get((IMObject)item);
        BigDecimal lowDiscount1 = new BigDecimal("1.20");
        BigDecimal highDiscount1 = new BigDecimal("2.20");
        BigDecimal lowTotal1 = new BigDecimal("10.80");
        BigDecimal highTotal1 = new BigDecimal("19.80");
        this.checkItem(item, this.patient, product, this.author, lowQuantity, highQuantity, unitPriceIncTax, unitPriceIncTax, fixedPriceIncTax, lowDiscount1, highDiscount1, lowTotal1, highTotal1);
        editor.setLowQuantity(BigDecimal.ZERO);
        this.checkSave(estimate, editor);
        item = (Act)this.get((IMObject)item);
        this.checkItem(item, this.patient, product, this.author, BigDecimal.ZERO, highQuantity, unitPriceIncTax, unitPriceIncTax, fixedPriceIncTax, BigDecimal.ZERO, highDiscount1, BigDecimal.ZERO, highTotal1);
        editor.setLowQuantity(lowQuantity);
        editor.setLowDiscount(BigDecimal.ZERO);
        editor.setHighDiscount(BigDecimal.ZERO);
        this.checkSave(estimate, editor);
        item = (Act)this.get((IMObject)item);
        BigDecimal lowTotal2 = new BigDecimal("12.00");
        BigDecimal highTotal2 = new BigDecimal("22.00");
        this.checkItem(item, this.patient, product, this.author, lowQuantity, highQuantity, unitPriceIncTax, unitPriceIncTax, fixedPriceIncTax, BigDecimal.ZERO, BigDecimal.ZERO, lowTotal2, highTotal2);
    }

    @Test
    public void testDiscountWithNegativeQuantity() {
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal unitCost = BigDecimal.valueOf(5L);
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal unitPriceIncTax = BigDecimal.TEN;
        BigDecimal fixedCost = BigDecimal.valueOf(1L);
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal fixedPriceIncTax = BigDecimal.valueOf(2L);
        Entity discountType = (Entity)this.productFactory.newDiscount().percentage(10).discountFixedPrice(true).build();
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedCost, fixedPrice)).unitPrice(unitCost, unitPrice)).addDiscounts(new Entity[]{discountType})).build();
        this.addDiscount((Entity)this.patient, discountType);
        Act item = (Act)this.create("act.customerEstimationItem", Act.class);
        Act estimate = EstimateTestHelper.createEstimate((Party)this.customer, (Act[])new Act[]{item});
        EstimateItemEditor editor = new EstimateItemEditor(item, estimate, new ChargeEditContext(this.customer, this.location, this.layout), this.layout);
        editor.getComponent();
        Assert.assertFalse((boolean)editor.isValid());
        editor.setPatient(this.patient);
        editor.setProduct(product);
        editor.setLowQuantity(quantity);
        editor.setHighQuantity(quantity);
        this.checkSave(estimate, editor);
        item = (Act)this.get((IMObject)item);
        BigDecimal discount = new BigDecimal("2.20");
        BigDecimal total = new BigDecimal("19.80");
        this.checkItem(item, this.patient, product, this.author, quantity, quantity, unitPriceIncTax, unitPriceIncTax, fixedPriceIncTax, discount, discount, total, total);
        BigDecimal negativeQty = quantity.negate();
        editor.setLowQuantity(negativeQty);
        editor.setHighQuantity(negativeQty);
        this.checkSave(estimate, editor);
        item = (Act)this.get((IMObject)item);
        this.checkItem(item, this.patient, product, this.author, negativeQty, negativeQty, unitPriceIncTax, unitPriceIncTax, fixedPriceIncTax, discount, discount, total.negate(), total.negate());
    }

    @Test
    public void testDisableDiscounts() {
        this.practiceFactory.updateLocation(this.layout.getContext().getLocation()).disableDiscounts(true).build();
        BigDecimal lowQuantity = BigDecimal.ONE;
        BigDecimal highQuantity = BigDecimal.valueOf(2L);
        BigDecimal unitCost = BigDecimal.valueOf(5L);
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal unitPriceIncTax = BigDecimal.TEN;
        BigDecimal fixedCost = BigDecimal.valueOf(1L);
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal fixedPriceIncTax = BigDecimal.valueOf(2L);
        Entity discount = (Entity)this.productFactory.newDiscount().percentage(10).discountFixedPrice(true).build();
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedCost, fixedPrice)).unitPrice(unitCost, unitPrice)).addDiscounts(new Entity[]{discount})).build();
        this.addDiscount((Entity)this.patient, discount);
        Act item = (Act)this.create("act.customerEstimationItem", Act.class);
        Act estimate = EstimateTestHelper.createEstimate((Party)this.customer, (Act[])new Act[]{item});
        EstimateItemEditor editor = new EstimateItemEditor(item, estimate, new ChargeEditContext(this.customer, this.location, this.layout), this.layout);
        editor.getComponent();
        Assert.assertFalse((boolean)editor.isValid());
        editor.setPatient(this.patient);
        editor.setProduct(product);
        editor.setLowQuantity(lowQuantity);
        editor.setHighQuantity(highQuantity);
        Assert.assertTrue((boolean)editor.isValid());
        this.checkSave(estimate, editor);
        item = (Act)this.get((IMObject)item);
        BigDecimal lowDiscount1 = BigDecimal.ZERO;
        BigDecimal highDiscount1 = BigDecimal.ZERO;
        BigDecimal lowTotal1 = new BigDecimal("12.00");
        BigDecimal highTotal1 = new BigDecimal("22.00");
        this.checkItem(item, this.patient, product, this.author, lowQuantity, highQuantity, unitPriceIncTax, unitPriceIncTax, fixedPriceIncTax, lowDiscount1, highDiscount1, lowTotal1, highTotal1);
    }

    @Test
    public void testTaxExemption() {
        this.addTaxExemption(this.customer);
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal unitCost = BigDecimal.valueOf(5L);
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal fixedCost = BigDecimal.valueOf(1L);
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal discount = BigDecimal.ZERO;
        Product product = (Product)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().fixedPrice(fixedCost, fixedPrice)).unitPrice(unitCost, unitPrice)).build();
        Act item = (Act)this.create("act.customerEstimationItem", Act.class);
        Act estimate = EstimateTestHelper.createEstimate((Party)this.customer, (Act[])new Act[]{item});
        EstimateItemEditor editor = new EstimateItemEditor(item, estimate, new ChargeEditContext(this.customer, this.location, this.layout), this.layout);
        editor.getComponent();
        Assert.assertFalse((boolean)editor.isValid());
        editor.setQuantity(quantity);
        editor.setPatient(this.patient);
        editor.setProduct(product);
        Assert.assertTrue((boolean)editor.isValid());
        this.checkSave(estimate, editor);
        estimate = (Act)this.get((IMObject)estimate);
        item = (Act)this.get((IMObject)item);
        Assert.assertNotNull((Object)estimate);
        Assert.assertNotNull((Object)item);
        BigDecimal totalExTax = new BigDecimal("20");
        this.checkItem(item, this.patient, product, this.author, quantity, quantity, unitPrice, unitPrice, fixedPrice, discount, discount, totalExTax, totalExTax);
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    @Test
    public void testTaxExemptionWithServiceRatios() {
        this.addTaxExemption(this.customer);
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal unitCost = BigDecimal.valueOf(5L);
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal fixedCost = BigDecimal.ONE;
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal discount = BigDecimal.ZERO;
        BigDecimal ratio = BigDecimal.valueOf(2L);
        Entity productType = this.productFactory.createProductType("Z Product Type");
        Product product = (Product)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().fixedPrice(fixedCost, fixedPrice)).unitPrice(unitCost, unitPrice)).type(productType)).build();
        this.practiceFactory.updateLocation(this.layout.getContext().getLocation()).addServiceRatio(productType, ratio).build();
        Act item = (Act)this.create("act.customerEstimationItem", Act.class);
        Act estimate = EstimateTestHelper.createEstimate((Party)this.customer, (Act[])new Act[]{item});
        EstimateItemEditor editor = new EstimateItemEditor(item, estimate, new ChargeEditContext(this.customer, this.location, this.layout), this.layout);
        editor.getComponent();
        Assert.assertFalse((boolean)editor.isValid());
        editor.setQuantity(quantity);
        editor.setPatient(this.patient);
        editor.setProduct(product);
        Assert.assertTrue((boolean)editor.isValid());
        this.checkSave(estimate, editor);
        estimate = (Act)this.get((IMObject)estimate);
        item = (Act)this.get((IMObject)item);
        Assert.assertNotNull((Object)estimate);
        Assert.assertNotNull((Object)item);
        BigDecimal fixedPriceWithRatio = new BigDecimal("1.82").multiply(ratio);
        BigDecimal unitPriceWithRatio = new BigDecimal("9.09").multiply(ratio);
        BigDecimal total = new BigDecimal("40");
        this.checkItem(item, this.patient, product, this.author, quantity, quantity, unitPriceWithRatio, unitPriceWithRatio, fixedPriceWithRatio, discount, discount, total, total);
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    @Test
    public void testServiceRatioWithMinPrice() {
        ((TestCurrencyBuilder)this.lookupFactory.newCurrency().code("AUD")).minPrice(new BigDecimal("0.20")).build();
        BigDecimal quantity = BigDecimal.ONE;
        BigDecimal unitCost = BigDecimal.valueOf(5L);
        BigDecimal unitPrice = BigDecimal.valueOf(5.05);
        BigDecimal fixedCost = BigDecimal.valueOf(0.5);
        BigDecimal fixedPrice = BigDecimal.valueOf(5.05);
        BigDecimal discount = BigDecimal.ZERO;
        BigDecimal ratio = BigDecimal.valueOf(2L);
        Entity productType = ProductTestHelper.createProductType((String)"Z Product Type");
        Product product = (Product)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().fixedPrice(fixedCost, fixedPrice)).unitPrice(unitCost, unitPrice)).type(productType)).build();
        this.practiceFactory.updateLocation(this.layout.getContext().getLocation()).addServiceRatio(productType, ratio).build();
        Act item = (Act)this.create("act.customerEstimationItem", Act.class);
        Act estimate = EstimateTestHelper.createEstimate((Party)this.customer, (Act[])new Act[]{item});
        EstimateItemEditor editor = new EstimateItemEditor(item, estimate, new ChargeEditContext(this.customer, this.location, this.layout), this.layout);
        editor.getComponent();
        editor.setQuantity(quantity);
        editor.setPatient(this.patient);
        editor.setProduct(product);
        this.checkSave(estimate, editor);
        item = (Act)this.get((IMObject)item);
        BigDecimal roundedPrice = BigDecimal.valueOf(11.2);
        BigDecimal total = BigDecimal.valueOf(22.4);
        this.checkItem(item, this.patient, product, this.author, quantity, quantity, roundedPrice, roundedPrice, roundedPrice, discount, discount, total, total);
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    @Test
    public void testProductDose() {
        BigDecimal unitCost = BigDecimal.valueOf(5L);
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal unitPriceIncTax = BigDecimal.TEN;
        BigDecimal fixedCost = BigDecimal.valueOf(1L);
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal fixedPriceIncTax = BigDecimal.valueOf(2L);
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedCost, fixedPrice)).unitPrice(unitCost, unitPrice)).concentration(1).newDose().weightRange(0, 10).rate(1).quantity(1).add().build();
        this.patientFactory.createWeight(this.patient, new BigDecimal("4.2"));
        Act item = (Act)this.create("act.customerEstimationItem", Act.class);
        Act estimate = EstimateTestHelper.createEstimate((Party)this.customer, (Act[])new Act[]{item});
        EstimateItemEditor editor = new EstimateItemEditor(item, estimate, new ChargeEditContext(this.customer, this.location, this.layout), this.layout);
        editor.getComponent();
        Assert.assertFalse((boolean)editor.isValid());
        editor.setPatient(this.patient);
        editor.setProduct(product);
        Assert.assertTrue((boolean)editor.isValid());
        this.checkSave(estimate, editor);
        item = (Act)this.get((IMObject)item);
        BigDecimal lowQuantity = new BigDecimal("4.2");
        BigDecimal highQuantity = new BigDecimal("4.2");
        BigDecimal lowDiscount = BigDecimal.ZERO;
        BigDecimal highDiscount = BigDecimal.ZERO;
        BigDecimal lowTotal1 = new BigDecimal("44.00");
        BigDecimal highTotal1 = new BigDecimal("44.00");
        this.checkItem(item, this.patient, product, this.author, lowQuantity, highQuantity, unitPriceIncTax, unitPriceIncTax, fixedPriceIncTax, lowDiscount, highDiscount, lowTotal1, highTotal1);
    }

    @Test
    public void testMinimumQuantities() {
        BigDecimal two = BigDecimal.valueOf(2L);
        Product product = this.productFactory.createMedication();
        Act item = (Act)this.create("act.customerEstimationItem", Act.class);
        Act estimate = EstimateTestHelper.createEstimate((Party)this.customer, (Act[])new Act[]{item});
        EstimateItemEditor editor = new EstimateItemEditor(item, estimate, new ChargeEditContext(this.customer, this.location, this.layout), this.layout);
        editor.getComponent();
        Assert.assertFalse((boolean)editor.isValid());
        editor.setPatient(this.patient);
        editor.setProduct(product);
        editor.setMinimumQuantity(two);
        editor.setLowQuantity(two);
        editor.setHighQuantity(two);
        Assert.assertTrue((boolean)editor.isValid());
        editor.setLowQuantity(BigDecimal.ONE);
        Assert.assertFalse((boolean)editor.isValid());
        editor.setLowQuantity(two);
        Assert.assertTrue((boolean)editor.isValid());
    }

    @Test
    public void testMinimumQuantitiesOverride() {
        Lookup userType = this.lookupFactory.getLookup("lookup.userType", "MINIMUM_QTY_OVERRIDE");
        Party practice = this.getPractice();
        this.practiceFactory.updatePractice(this.getPractice()).minimumQuantitiesOverride(userType.getCode()).build();
        this.author.addClassification(userType);
        BigDecimal two = BigDecimal.valueOf(2L);
        Product product = this.productFactory.createMedication();
        Act item = (Act)this.create("act.customerEstimationItem", Act.class);
        Act estimate = EstimateTestHelper.createEstimate((Party)this.customer, (Act[])new Act[]{item});
        EstimateItemEditor editor = new EstimateItemEditor(item, estimate, new ChargeEditContext(this.customer, this.location, this.layout), this.layout);
        editor.getComponent();
        Assert.assertFalse((boolean)editor.isValid());
        editor.setPatient(this.patient);
        editor.setProduct(product);
        editor.setLowQuantity(two);
        editor.setHighQuantity(BigDecimal.TEN);
        editor.setMinimumQuantity(two);
        Assert.assertTrue((boolean)editor.isValid());
        editor.setLowQuantity(BigDecimal.TEN);
        this.checkEquals(two, editor.getMinimumQuantity());
        editor.setLowQuantity(BigDecimal.ONE);
        this.checkEquals(BigDecimal.ONE, editor.getMinimumQuantity());
        Assert.assertTrue((boolean)editor.isValid());
        editor.setLowQuantity(BigDecimal.valueOf(-1L));
        Assert.assertTrue((boolean)editor.isValid());
        this.checkEquals(BigDecimal.valueOf(-1L), editor.getMinimumQuantity());
        editor.setLowQuantity(BigDecimal.ZERO);
        this.checkEquals(BigDecimal.ZERO, editor.getMinimumQuantity());
        Assert.assertTrue((boolean)editor.isValid());
        editor.setLowQuantity(BigDecimal.ONE);
        this.checkEquals(BigDecimal.ZERO, editor.getMinimumQuantity());
        Assert.assertTrue((boolean)editor.isValid());
    }

    @Test
    public void testZeroQuantities() {
        BigDecimal lowQuantity = BigDecimal.ONE;
        BigDecimal highQuantity = BigDecimal.valueOf(2L);
        BigDecimal unitCost = BigDecimal.valueOf(5L);
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal unitPriceIncTax = BigDecimal.TEN;
        BigDecimal fixedCost = BigDecimal.valueOf(1L);
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal fixedPriceIncTax = BigDecimal.valueOf(2L);
        Entity discount = (Entity)this.productFactory.newDiscount().percentage(10).discountFixedPrice(true).build();
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedCost, fixedPrice)).unitPrice(unitCost, unitPrice)).addDiscounts(new Entity[]{discount})).build();
        this.addDiscount((Entity)this.patient, discount);
        Act item = (Act)this.create("act.customerEstimationItem", Act.class);
        Act estimate = EstimateTestHelper.createEstimate((Party)this.customer, (Act[])new Act[]{item});
        EstimateItemEditor editor = new EstimateItemEditor(item, estimate, new ChargeEditContext(this.customer, this.location, this.layout), this.layout);
        editor.getComponent();
        Assert.assertFalse((boolean)editor.isValid());
        editor.setPatient(this.patient);
        editor.setProduct(product);
        editor.setLowQuantity(lowQuantity);
        editor.setHighQuantity(highQuantity);
        Assert.assertTrue((boolean)editor.isValid());
        this.checkSave(estimate, editor);
        item = (Act)this.get((IMObject)item);
        BigDecimal lowDiscount1 = new BigDecimal("1.20");
        BigDecimal highDiscount1 = new BigDecimal("2.20");
        BigDecimal lowTotal1 = new BigDecimal("10.80");
        BigDecimal highTotal1 = new BigDecimal("19.80");
        this.checkItem(item, this.patient, product, this.author, lowQuantity, highQuantity, unitPriceIncTax, unitPriceIncTax, fixedPriceIncTax, lowDiscount1, highDiscount1, lowTotal1, highTotal1);
        editor.setLowQuantity(BigDecimal.ZERO);
        this.checkSave(estimate, editor);
        item = (Act)this.get((IMObject)item);
        this.checkItem(item, this.patient, product, this.author, BigDecimal.ZERO, highQuantity, unitPriceIncTax, unitPriceIncTax, fixedPriceIncTax, BigDecimal.ZERO, highDiscount1, BigDecimal.ZERO, highTotal1);
        editor.setHighQuantity(BigDecimal.ZERO);
        this.checkSave(estimate, editor);
        item = (Act)this.get((IMObject)item);
        this.checkItem(item, this.patient, product, this.author, BigDecimal.ZERO, BigDecimal.ZERO, unitPriceIncTax, unitPriceIncTax, fixedPriceIncTax, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    private void checkSave(Act estimate, EstimateItemEditor editor) {
        boolean saved = SaveHelper.save((IMObjectEditor)editor, () -> this.save((IMObject)estimate));
        Assert.assertTrue((boolean)saved);
    }
}

