/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.estimate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.tax.TaxRules;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.component.business.service.security.AuthenticationContextImpl;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.charge.AbstractCustomerChargeActEditorTest;
import org.openvpms.web.workspace.customer.charge.ChargeItemRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditDialog;
import org.openvpms.web.workspace.customer.charge.CustomerChargeTestHelper;
import org.openvpms.web.workspace.customer.charge.DefaultCustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.DefaultEditorQueue;
import org.openvpms.web.workspace.customer.charge.EditorQueue;
import org.openvpms.web.workspace.customer.estimate.EstimateInvoicer;
import org.springframework.beans.factory.annotation.Autowired;

public class EstimateInvoicerTestCase
extends AbstractCustomerChargeActEditorTest {
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private CustomerAccountRules accountRules;
    private TaxRules taxRules;
    private Party customer;
    private Party patient;
    private User author;
    private User clinician;
    private DefaultLayoutContext context;

    @Override
    public void setUp() {
        super.setUp();
        this.taxRules = new TaxRules(this.getPractice(), (ArchetypeService)this.getArchetypeService());
        this.customer = this.customerFactory.createCustomer();
        this.patient = this.patientFactory.createPatient(this.customer);
        this.patientFactory.createWeight(this.patient, BigDecimal.TEN);
        this.author = this.userFactory.createClinician();
        new AuthenticationContextImpl().setUser(this.author);
        this.clinician = this.userFactory.createClinician();
        this.context = new DefaultLayoutContext(true, (Context)new LocalContext(), new HelpContext("foo", null));
        this.context.getContext().setPractice(this.getPractice());
        this.context.getContext().setUser(this.author);
        this.context.getContext().setClinician(this.clinician);
        this.context.getContext().setLocation(this.practiceFactory.createLocation());
        this.context.getContext().setCustomer(this.customer);
        this.context.getContext().setPatient(this.patient);
    }

    @Test
    public void testInvoice() {
        Product product1 = this.createMedicationWithDose();
        Product product2 = this.productFactory.createService();
        Product product3 = this.productFactory.createMerchandise();
        Product product4 = this.productFactory.createMedication();
        Product product5 = this.productFactory.createService();
        Product template1 = this.createTemplate("Template1 Invoice Note", "Template1 Visit Note");
        Product template2 = this.createTemplate(null, "Template2 Visit Note");
        BigDecimal price1 = new BigDecimal("10.00");
        BigDecimal price2 = new BigDecimal("20.00");
        BigDecimal price3 = new BigDecimal("30.00");
        BigDecimal price4 = new BigDecimal("20.00");
        BigDecimal quantity1 = BigDecimal.ONE;
        BigDecimal quantity2 = BigDecimal.ONE;
        BigDecimal quantity3 = BigDecimal.valueOf(2L);
        BigDecimal quantity4 = BigDecimal.valueOf(4L);
        BigDecimal amount1 = quantity1.multiply(price1);
        BigDecimal amount2 = quantity2.multiply(price2);
        BigDecimal amount3 = quantity3.multiply(price3);
        BigDecimal amount4 = quantity4.multiply(price4);
        BigDecimal tax1 = this.calculateTax(product1, amount1);
        BigDecimal tax2 = this.calculateTax(product2, amount2);
        BigDecimal tax3 = this.calculateTax(product3, amount3);
        BigDecimal tax4 = this.calculateTax(product4, amount4);
        Act estimate = (Act)this.accountFactory.newEstimate().customer(this.customer).item().patient(this.patient).product(product1).lowQuantity(1).highQuantity(quantity1).highUnitPrice(price1).add().item().patient(this.patient).product(product2).lowQuantity(1).highQuantity(quantity2).highUnitPrice(price2).add().item().patient(this.patient).product(product3).template(template1).group(0).lowQuantity(1).highQuantity(quantity3).highUnitPrice(price3).add().item().patient(this.patient).product(product4).template(template2).group(1).lowQuantity(1).highQuantity(quantity4).highUnitPrice(price4).add().item().patient(this.patient).product(product5).template(template2).group(1).lowQuantity(1).highQuantity(1).highUnitPrice(0).print(false).add().build();
        TestEstimateInvoicer invoicer = this.createEstimateInvoicer();
        CustomerChargeActEditDialog dialog = invoicer.invoice(estimate, null, (LayoutContext)this.context);
        IMObjectEditor editor = dialog.getEditor();
        CustomerChargeTestHelper.checkSavePopup(invoicer.getEditorQueue(), "act.patientMedication", false);
        CustomerChargeTestHelper.checkSavePopup(invoicer.getEditorQueue(), "act.patientMedication", false);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        FinancialAct invoice = (FinancialAct)editor.getObject();
        BigDecimal total = this.sum(amount1, amount2, amount3, amount4);
        BigDecimal tax = this.sum(tax1, tax2, tax3, tax4);
        this.checkEquals(total, invoice.getTotal());
        Assert.assertEquals((Object)"INVOICED", (Object)estimate.getStatus());
        Assert.assertEquals((Object)this.getBean((IMObject)estimate).getTarget("invoice"), (Object)invoice);
        IMObjectBean bean = this.getBean((IMObject)invoice);
        Assert.assertEquals((Object)"Template1 Invoice Note", (Object)bean.getString("notes"));
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)5L, (long)items.size());
        List estimates = bean.getSources("estimates", Act.class);
        Assert.assertEquals((long)1L, (long)estimates.size());
        Assert.assertTrue((boolean)estimates.contains(estimate));
        this.checkCharge(invoice, this.customer, this.author, this.clinician, tax, total);
        BigDecimal discount = BigDecimal.ZERO;
        IMObjectBean charge1 = this.checkItem(items, "act.customerAccountInvoiceItem", this.patient, product1, null, -1, this.author, this.clinician, BigDecimal.ONE, quantity1, BigDecimal.ZERO, price1, BigDecimal.ZERO, BigDecimal.ZERO, discount, tax1, amount1, true, null, 1);
        IMObjectBean charge2 = this.checkItem(items, "act.customerAccountInvoiceItem", this.patient, product2, null, -1, this.author, this.clinician, BigDecimal.ONE, quantity2, BigDecimal.ZERO, price2, BigDecimal.ZERO, BigDecimal.ZERO, discount, tax2, amount2, true, null, 0);
        IMObjectBean charge3 = this.checkItem(items, "act.customerAccountInvoiceItem", this.patient, product3, template1, 0, this.author, this.clinician, BigDecimal.ONE, quantity3, BigDecimal.ZERO, price3, BigDecimal.ZERO, BigDecimal.ZERO, discount, tax3, amount3, true, null, 0);
        IMObjectBean charge4 = this.checkItem(items, "act.customerAccountInvoiceItem", this.patient, product4, template2, 1, this.author, this.clinician, BigDecimal.ONE, quantity4, BigDecimal.ZERO, price4, BigDecimal.ZERO, BigDecimal.ZERO, discount, tax4, amount4, true, null, 1);
        IMObjectBean charge5 = this.checkItem(items, "act.customerAccountInvoiceItem", this.patient, product5, template2, 1, this.author, this.clinician, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, false, null, 0);
        Act event = this.getEvent(charge1);
        Assert.assertEquals((Object)event, (Object)this.getEvent(charge2));
        Assert.assertEquals((Object)event, (Object)this.getEvent(charge3));
        Assert.assertEquals((Object)event, (Object)this.getEvent(charge4));
        Assert.assertEquals((Object)event, (Object)this.getEvent(charge5));
        this.checkEventNote(event, this.patient, "Template1 Visit Note");
        this.checkEventNote(event, this.patient, "Template2 Visit Note");
    }

    @Test
    public void testTemplateExpansionGroups() {
        Product product1 = this.productFactory.createService();
        Product template1 = this.productFactory.createTemplate();
        Product product2 = this.productFactory.createService();
        Product template2 = this.productFactory.createTemplate();
        Product product3 = this.productFactory.createService();
        Product template3 = this.productFactory.createTemplate();
        FinancialAct invoice = (FinancialAct)((TestInvoiceBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceBuilder)this.accountFactory.newInvoice().customer(this.customer)).item().patient(this.patient)).product(product1)).template(template1)).group(0)).add()).item().patient(this.patient)).product(product2)).template(template2)).group(1)).add()).build();
        Act estimate = (Act)this.accountFactory.newEstimate().customer(this.customer).item().patient(this.patient).product(product3).template(template3).group(0).add().build();
        TestEstimateInvoicer invoicer = this.createEstimateInvoicer();
        CustomerChargeActEditDialog dialog = invoicer.invoice(estimate, invoice, (LayoutContext)this.context);
        IMObjectEditor editor = dialog.getEditor();
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        IMObjectBean bean = this.getBean(this.get((IMObject)invoice));
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)3L, (long)items.size());
        this.checkItem(items, "act.customerAccountInvoiceItem", this.patient, product1, template1, 0, this.author, null, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, true, null, 0);
        this.checkItem(items, "act.customerAccountInvoiceItem", this.patient, product2, template2, 1, this.author, null, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, true, null, 0);
        this.checkItem(items, "act.customerAccountInvoiceItem", this.patient, product3, template3, 2, this.author, this.clinician, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, true, null, 0);
    }

    @Test
    public void testNegativeQuantity() {
        Product product = this.productFactory.createMedication();
        Act estimate = (Act)this.accountFactory.newEstimate().customer(this.customer).item().patient(this.patient).product(product).lowQuantity(-2).highQuantity(-1).fixedPrice(5).lowUnitPrice(4).highUnitPrice(5).add().build();
        TestEstimateInvoicer invoicer = this.createEstimateInvoicer();
        CustomerChargeActEditDialog dialog = invoicer.invoice(estimate, null, (LayoutContext)this.context);
        IMObjectEditor editor = dialog.getEditor();
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        FinancialAct invoice = (FinancialAct)editor.getObject();
        IMObjectBean bean = this.getBean(this.get((IMObject)invoice));
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)1L, (long)items.size());
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)this.accountRules.getBalance(this.customer));
        invoice.setStatus("POSTED");
        this.save((IMObject)invoice);
        this.checkEquals(BigDecimal.valueOf(-10L), this.accountRules.getBalance(this.customer));
        this.checkItem(items, "act.customerAccountInvoiceItem", this.patient, product, null, 0, this.author, this.clinician, BigDecimal.valueOf(-2L), BigDecimal.valueOf(-1L), BigDecimal.ZERO, BigDecimal.valueOf(5L), BigDecimal.ZERO, BigDecimal.valueOf(5L), BigDecimal.ZERO, new BigDecimal("-0.909"), BigDecimal.valueOf(-10L), true, null, 0);
        this.accountRules.reverse(invoice, new Date());
        this.checkEquals(BigDecimal.ZERO, this.accountRules.getBalance(this.customer));
    }

    protected Party getPatient() {
        return this.patient;
    }

    protected TestEstimateInvoicer createEstimateInvoicer() {
        return new TestEstimateInvoicer();
    }

    protected BigDecimal calculateTax(Product product, BigDecimal amount) {
        return this.taxRules.calculateTax(amount, product, true);
    }

    protected BigDecimal sum(BigDecimal ... amounts) {
        BigDecimal result = BigDecimal.ZERO;
        for (BigDecimal amount : amounts) {
            result = result.add(MathRules.round((BigDecimal)amount));
        }
        return result;
    }

    protected Product createMedicationWithDose() {
        return (Product)this.productFactory.newMedication().concentration(1).newDose().minWeight(0).maxWeight(5).rate(1).quantity(1).add().newDose().minWeight(5).maxWeight(15).rate(2).quantity(2).add().build();
    }

    private Product createTemplate(String invoiceNote, String visitNote) {
        return (Product)this.productFactory.newTemplate().invoiceNote(invoiceNote).visitNote(visitNote).build();
    }

    private static class TestEstimateInvoicer
    extends EstimateInvoicer {
        private EditorQueue queue;

        private TestEstimateInvoicer() {
        }

        public EditorQueue getEditorQueue() {
            return this.queue;
        }

        protected DefaultCustomerChargeActEditor createChargeEditor(FinancialAct invoice, LayoutContext context) {
            this.queue = new DefaultEditorQueue(context.getContext());
            return new DefaultCustomerChargeActEditor(invoice, null, context){

                protected ActRelationshipCollectionEditor createItemsEditor(Act act, CollectionProperty items) {
                    ActRelationshipCollectionEditor editor = super.createItemsEditor(act, items);
                    if (editor instanceof ChargeItemRelationshipCollectionEditor) {
                        ((ChargeItemRelationshipCollectionEditor)editor).setEditorQueue(queue);
                    }
                    return editor;
                }
            };
        }
    }
}

