/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.estimate;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.account.TestEstimateItemVerifier;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestServiceProductBuilder;
import org.openvpms.component.business.service.security.AuthenticationContextImpl;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.estimate.AbstractEstimateEditorTestCase;
import org.openvpms.web.workspace.customer.estimate.EstimateEditor;
import org.openvpms.web.workspace.customer.estimate.EstimateItemEditor;

public class EstimateEditorTestCase
extends AbstractEstimateEditorTestCase {
    private Context context;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.context = new LocalContext();
        this.context.setPractice(this.getPractice());
        this.context.setClinician(this.userFactory.createClinician());
        User user = this.userFactory.createUser();
        this.context.setUser(user);
        new AuthenticationContextImpl().setUser(user);
    }

    @Test
    public void testTemplateExpansion() {
        Entity discount = (Entity)this.productFactory.newDiscount().percentage(10).discountFixedPrice(true).build();
        Party customer = (Party)this.customerFactory.newCustomer().addDiscounts(new Entity[]{discount}).build();
        Party patient = this.patientFactory.createPatient(customer);
        this.patientFactory.createWeight(patient, new BigDecimal("4.2"));
        this.context.setCustomer(customer);
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        layout.setEdit(true);
        BigDecimal fixedPrice = new BigDecimal("0.91");
        BigDecimal unitPrice = new BigDecimal("0.91");
        BigDecimal fixedPriceIncTax = BigDecimal.ONE;
        BigDecimal unitPriceIncTax = BigDecimal.ONE;
        Product product1 = (Product)((TestServiceProductBuilder)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice(fixedPrice)).unitPrice(unitPrice)).build();
        Product product2 = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).unitPrice(unitPrice)).concentration(1).newDose().minWeight(0).maxWeight(10).rate(1).quantity(1).add().build();
        Product product3 = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).unitPrice(unitPrice)).build();
        Product product4 = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).unitPrice(unitPrice)).addDiscounts(new Entity[]{discount})).build();
        Product template = (Product)this.productFactory.newTemplate().newInclude().product(product1).lowQuantity(1).highQuantity(1).add().newInclude().product(product2).lowQuantity(0).highQuantity(2).add().newInclude().product(product3).lowQuantity(2).highQuantity(4).add().newInclude().product(product4).lowQuantity(3).highQuantity(6).print(false).zeroPrice().add().build();
        Act estimate = (Act)this.create("act.customerEstimation", Act.class);
        EstimateEditor editor = new EstimateEditor(estimate, null, (LayoutContext)layout);
        editor.getComponent();
        Assert.assertFalse((boolean)editor.isValid());
        IMObjectEditor itemEditor = editor.getItems().add();
        Assert.assertTrue((boolean)(itemEditor instanceof EstimateItemEditor));
        EstimateItemEditor estimateItemEditor = (EstimateItemEditor)itemEditor;
        estimateItemEditor.setPatient(patient);
        estimateItemEditor.setProduct(template);
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        estimate = (Act)this.get((IMObject)estimate);
        List<Act> items = this.getItems(estimate);
        Assert.assertEquals((long)4L, (long)items.size());
        User author = this.context.getUser();
        this.checkEstimate(estimate, customer, author, new BigDecimal("5.00"), new BigDecimal("12.20"));
        TestEstimateItemVerifier verifier = new TestEstimateItemVerifier((ArchetypeService)this.getArchetypeService());
        verifier.patient(patient).template(template).group(0).createdBy(author);
        verifier.product(product1).minimumQuantity(1).lowQuantity(1).highQuantity(1).fixedPrice(fixedPriceIncTax).lowUnitPrice(unitPriceIncTax).highUnitPrice(unitPriceIncTax).lowDiscount(0).highDiscount(0).lowTotal(2).highTotal(2).verify(items);
        verifier.product(product2).minimumQuantity(0).lowQuantity(0).highQuantity(new BigDecimal("4.2")).fixedPrice(1).lowUnitPrice(unitPriceIncTax).highUnitPrice(unitPriceIncTax).lowDiscount(0).highDiscount(0).lowTotal(0).highTotal(new BigDecimal("5.2")).verify(items);
        verifier.product(product3).minimumQuantity(2).lowQuantity(2).highQuantity(4).fixedPrice(fixedPriceIncTax).lowUnitPrice(unitPriceIncTax).highUnitPrice(unitPriceIncTax).lowDiscount(0).highDiscount(0).lowTotal(3).highTotal(5).verify(items);
        verifier.product(product4).minimumQuantity(3).lowQuantity(3).highQuantity(6).fixedPrice(0).lowUnitPrice(0).highUnitPrice(0).lowDiscount(0).highDiscount(0).print(false).lowTotal(0).highTotal(0).verify(items);
    }

    @Test
    public void testTemplateExpansionGroup() {
        Product product1 = this.productFactory.createService();
        Product product2 = this.productFactory.createService();
        Product product3 = this.productFactory.createService();
        Product template1 = (Product)this.productFactory.newTemplate().newInclude().product(product1).highQuantity(1).add().build();
        Product template2 = (Product)this.productFactory.newTemplate().newInclude().product(product2).highQuantity(1).add().build();
        Product template3 = (Product)this.productFactory.newTemplate().newInclude().product(product3).highQuantity(1).add().build();
        Party customer = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient(customer);
        this.context.setCustomer(customer);
        this.context.setPatient(patient);
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        layout.setEdit(true);
        Act estimate = (Act)this.create("act.customerEstimation", Act.class);
        EstimateEditor editor = new EstimateEditor(estimate, null, (LayoutContext)layout);
        editor.getComponent();
        Assert.assertFalse((boolean)editor.isValid());
        this.addItem(editor, template1);
        this.addItem(editor, template2);
        this.addItem(editor, template3);
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        List<Act> items = this.getItems(estimate);
        Assert.assertEquals((long)3L, (long)items.size());
        TestEstimateItemVerifier verifier = new TestEstimateItemVerifier((ArchetypeService)this.getArchetypeService());
        verifier.patient(patient).createdBy(this.context.getUser());
        verifier.product(product1).template(template1).group(0).minimumQuantity(1).verify(items);
        verifier.product(product2).template(template2).group(1).minimumQuantity(1).verify(items);
        verifier.product(product3).template(template3).group(2).minimumQuantity(1).verify(items);
    }

    private List<Act> getItems(Act estimate) {
        IMObjectBean bean = this.getBean((IMObject)estimate);
        return bean.getTargets("items", Act.class);
    }

    private void addItem(EstimateEditor editor, Product product) {
        IMObjectEditor itemEditor = editor.getItems().add();
        Assert.assertTrue((boolean)(itemEditor instanceof EstimateItemEditor));
        EstimateItemEditor estimateItemEditor = (EstimateItemEditor)itemEditor;
        estimateItemEditor.setProduct(product);
    }

    private void checkEstimate(Act estimate, Party customer, User author, BigDecimal lowTotal, BigDecimal highTotal) {
        IMObjectBean bean = this.getBean((IMObject)estimate);
        Assert.assertEquals((Object)customer.getObjectReference(), (Object)bean.getTargetRef("customer"));
        Assert.assertEquals((Object)author.getObjectReference(), (Object)estimate.getCreatedBy());
        this.checkEquals(lowTotal, bean.getBigDecimal("lowTotal"));
        this.checkEquals(highTotal, bean.getBigDecimal("highTotal"));
    }
}

