/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.communication;

import org.apache.commons.lang3.RandomStringUtils;
import org.hibernate.validator.internal.util.Contracts;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.TextDocumentHandler;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.springframework.beans.factory.annotation.Autowired;

public class CommunicationLoggerTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    private TestLogger logger;
    private Party customer;
    private Party location;

    @Before
    public void setUp() {
        super.setUp();
        this.logger = new TestLogger(this.getArchetypeService());
        this.customer = this.customerFactory.createCustomer();
        this.location = this.practiceFactory.createLocation();
    }

    @Test
    public void testLogEmail() {
        Party patient = this.patientFactory.createPatient(this.customer);
        this.logger.logEmail(this.customer, patient, "from@mail.com", new String[]{"to@mail.com"}, new String[]{"cc1@mail.com", "cc2@mail.com"}, new String[]{"bcc@mail.com"}, "a subject \ud83d\ude02", "a reason", "<html><body>a message \ud83d\ude02<body></html>", "a note", "some attachments", this.location);
        IMObjectBean log = this.logger.getLog();
        Assert.assertTrue((boolean)log.isA(new String[]{"act.customerCommunicationEmail"}));
        Assert.assertEquals((Object)this.customer, (Object)log.getTarget("customer"));
        Assert.assertEquals((Object)patient, (Object)log.getTarget("patient"));
        Assert.assertEquals((Object)"from@mail.com", (Object)log.getString("from"));
        Assert.assertEquals((Object)"to@mail.com", (Object)log.getString("address"));
        Assert.assertEquals((Object)"cc1@mail.com\ncc2@mail.com", (Object)log.getString("cc"));
        Assert.assertEquals((Object)"bcc@mail.com", (Object)log.getString("bcc"));
        Assert.assertEquals((Object)"a subject \ufffd", (Object)log.getString("description"));
        Assert.assertEquals((Object)"a reason", (Object)log.getString("reason"));
        Assert.assertEquals((Object)"a message \ufffd", (Object)log.getString("message"));
        Assert.assertEquals((Object)"a note", (Object)log.getString("note"));
        Assert.assertEquals((Object)"some attachments", (Object)log.getString("attachments"));
        Assert.assertEquals((Object)this.location, (Object)log.getTarget("location"));
        Assert.assertNull((Object)log.getObject("document"));
    }

    @Test
    public void testLongEmail() {
        String message = RandomStringUtils.randomAlphabetic((int)50000) + "\ud83d\ude02";
        this.logger.logEmail(this.customer, null, "from@mail.com", new String[]{"to@mail.com"}, null, null, "a subject", "a reason", "<html><body>" + message + "<body></html>", "a note", "some attachments", this.location);
        IMObjectBean log = this.logger.getLog();
        Assert.assertNull((Object)log.getString("message"));
        org.openvpms.component.model.document.Document document = (org.openvpms.component.model.document.Document)log.getObject("document", org.openvpms.component.model.document.Document.class);
        Contracts.assertNotNull((Object)document);
        Assert.assertTrue((boolean)document.isA("document.text"));
        TextDocumentHandler handler = new TextDocumentHandler((ArchetypeService)this.getArchetypeService());
        String actual = handler.toString((Document)document);
        Assert.assertEquals((Object)message, (Object)actual);
    }

    @Test
    public void testLogMail() {
        Party patient = this.patientFactory.createPatient(this.customer);
        this.logger.logMail(this.customer, patient, "an address", "a subject", "a reason", "a message", "a note", this.location);
        IMObjectBean log = this.logger.getLog();
        Assert.assertTrue((boolean)log.isA(new String[]{"act.customerCommunicationMail"}));
        Assert.assertEquals((Object)this.customer, (Object)log.getTarget("customer"));
        Assert.assertEquals((Object)patient, (Object)log.getTarget("patient"));
        Assert.assertEquals((Object)"an address", (Object)log.getString("address"));
        Assert.assertEquals((Object)"a subject", (Object)log.getString("description"));
        Assert.assertEquals((Object)"a reason", (Object)log.getString("reason"));
        Assert.assertEquals((Object)"a message", (Object)log.getString("message"));
        Assert.assertEquals((Object)"a note", (Object)log.getString("note"));
        Assert.assertEquals((Object)this.location, (Object)log.getTarget("location"));
        Assert.assertNull((Object)log.getObject("document"));
    }

    @Test
    public void testLogPhone() {
        Party patient = this.patientFactory.createPatient(this.customer);
        this.logger.logPhone(this.customer, patient, "12345678", "a subject", "a reason", "a message", "a note", this.location);
        IMObjectBean log = this.logger.getLog();
        Assert.assertTrue((boolean)log.isA(new String[]{"act.customerCommunicationPhone"}));
        Assert.assertEquals((Object)this.customer, (Object)log.getTarget("customer"));
        Assert.assertEquals((Object)patient, (Object)log.getTarget("patient"));
        Assert.assertEquals((Object)"12345678", (Object)log.getString("address"));
        Assert.assertEquals((Object)"a subject", (Object)log.getString("description"));
        Assert.assertEquals((Object)"a reason", (Object)log.getString("reason"));
        Assert.assertEquals((Object)"a message", (Object)log.getString("message"));
        Assert.assertEquals((Object)"a note", (Object)log.getString("note"));
        Assert.assertEquals((Object)this.location, (Object)log.getTarget("location"));
        Assert.assertNull((Object)log.getObject("document"));
    }

    private static class TestLogger
    extends CommunicationLogger {
        private IMObjectBean log;

        public TestLogger(IArchetypeService service) {
            super((ArchetypeService)service);
        }

        public IMObjectBean getLog() {
            return this.log;
        }

        protected void saveLog(String message, IMObjectBean bean, String fileName) {
            super.saveLog(message, bean, fileName);
            this.log = bean;
        }
    }
}

