/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge.department;

import nextapp.echo2.app.TextField;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.practice.TestDepartmentBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.combo.ComboBox;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.customer.charge.department.DepartmentReferenceEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class DepartmentReferenceEditorTestCase
extends AbstractAppTest {
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestUserFactory userFactory;

    @Test
    public void testUpdateContext() {
        LocalContext context = new LocalContext();
        context.setUser((User)this.userFactory.newUser().build(false));
        DefaultLayoutContext layout = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        SimpleProperty property = new SimpleProperty("reference", Reference.class);
        Entity department1 = this.practiceFactory.createDepartment();
        Entity department2 = this.practiceFactory.createDepartment();
        DepartmentReferenceEditor editor = new DepartmentReferenceEditor((Property)property, null, (LayoutContext)layout);
        editor.getComponent();
        Assert.assertNull((Object)editor.getObject());
        Assert.assertNull((Object)context.getDepartment());
        editor.setObject((IMObject)department1);
        Assert.assertEquals((Object)department1, (Object)editor.getObject());
        Assert.assertEquals((Object)department1, (Object)context.getDepartment());
        editor.setObject((IMObject)department2);
        Assert.assertEquals((Object)department2, (Object)editor.getObject());
        Assert.assertEquals((Object)department2, (Object)context.getDepartment());
        editor.setObject(null);
        Assert.assertNull((Object)editor.getObject());
        Assert.assertNull((Object)context.getDepartment());
        TextField field = ((ComboBox)editor.getComponent()).getTextField();
        field.setText(department1.getName());
        Assert.assertEquals((Object)department1, (Object)editor.getObject());
        Assert.assertEquals((Object)department1, (Object)context.getDepartment());
    }

    @Test
    public void testInactiveDepartment() {
        User user = (User)this.userFactory.newUser().build(false);
        Entity inactiveDepartment = (Entity)((TestDepartmentBuilder)this.practiceFactory.newDepartment().active(false)).build();
        Entity activeDepartment = this.practiceFactory.createDepartment();
        this.checkInaccessibleDepartment(user, inactiveDepartment, activeDepartment);
    }

    @Test
    public void testDepartmentNotAccessibleToUser() {
        Entity department1 = this.practiceFactory.createDepartment();
        Entity department2 = this.practiceFactory.createDepartment();
        User user = (User)this.userFactory.newUser().addDepartments(new Entity[]{department2}).build(false);
        this.checkInaccessibleDepartment(user, department1, department2);
    }

    private void checkInaccessibleDepartment(User user, Entity inaccessibleDepartment, Entity accessibleDepartment) {
        LocalContext context = new LocalContext();
        context.setUser(user);
        DefaultLayoutContext layout = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        SimpleProperty property = new SimpleProperty("reference", Reference.class);
        property.setValue((Object)inaccessibleDepartment.getObjectReference());
        DepartmentReferenceEditor editor = new DepartmentReferenceEditor((Property)property, null, (LayoutContext)layout);
        editor.getComponent();
        Assert.assertEquals((Object)inaccessibleDepartment, (Object)editor.getObject());
        Assert.assertNull((Object)context.getDepartment());
        editor.setObject((IMObject)accessibleDepartment);
        Assert.assertEquals((Object)accessibleDepartment, (Object)editor.getObject());
        Assert.assertEquals((Object)accessibleDepartment, (Object)context.getDepartment());
        editor.setObject((IMObject)inaccessibleDepartment);
        Assert.assertEquals((Object)inaccessibleDepartment, (Object)editor.getObject());
        Assert.assertEquals((Object)accessibleDepartment, (Object)context.getDepartment());
    }
}

