/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.hl7.patient.PatientContext;
import org.openvpms.hl7.pharmacy.PharmacyOrderService;

public class TestPharmacyOrderService
implements PharmacyOrderService {
    private List<Order> orders = new ArrayList<Order>();

    public boolean createOrder(PatientContext context, Product product, BigDecimal quantity, long placerOrderNumber, Date date, Entity pharmacy) {
        this.orders.add(new Order(Order.Type.CREATE, context.getPatient(), product, quantity, placerOrderNumber, date, context.getClinician(), pharmacy));
        return true;
    }

    public void updateOrder(PatientContext context, Product product, BigDecimal quantity, long placerOrderNumber, Date date, Entity pharmacy) {
        this.orders.add(new Order(Order.Type.UPDATE, context.getPatient(), product, quantity, placerOrderNumber, date, context.getClinician(), pharmacy));
    }

    public void cancelOrder(PatientContext context, Product product, BigDecimal quantity, long placerOrderNumber, Date date, Entity pharmacy) {
        this.orders.add(new Order(Order.Type.CANCEL, context.getPatient(), product, quantity, placerOrderNumber, date, context.getClinician(), pharmacy));
    }

    public void discontinueOrder(PatientContext context, Product product, BigDecimal quantity, long placerOrderNumber, Date date, Entity pharmacy) {
        this.orders.add(new Order(Order.Type.DISCONTINUE, context.getPatient(), product, quantity, placerOrderNumber, date, context.getClinician(), pharmacy));
    }

    public List<Order> getOrders() {
        return this.getOrders(false);
    }

    public List<Order> getOrders(boolean sort) {
        ArrayList<Order> result = new ArrayList<Order>(this.orders);
        if (sort) {
            result.sort((o1, o2) -> {
                long id2;
                long id1 = o1.getProduct().getId();
                return id1 < (id2 = o2.getProduct().getId()) ? -1 : (id1 == id2 ? o1.getType().compareTo(o2.getType()) : 1);
            });
        }
        return result;
    }

    public void clear() {
        this.orders.clear();
    }

    public static class Order {
        private final Type type;
        private final Party patient;
        private final Product product;
        private final BigDecimal quantity;
        private final long placerOrderNumber;
        private final Date date;
        private final User clinician;
        private final Entity pharmacy;

        public Order(Type type, Party patient, Product product, BigDecimal quantity, long placerOrderNumber, Date date, User clinician, Entity pharmacy) {
            this.type = type;
            this.patient = patient;
            this.product = product;
            this.quantity = quantity;
            this.placerOrderNumber = placerOrderNumber;
            this.date = date;
            this.clinician = clinician;
            this.pharmacy = pharmacy;
        }

        public Type getType() {
            return this.type;
        }

        public Party getPatient() {
            return this.patient;
        }

        public Product getProduct() {
            return this.product;
        }

        public BigDecimal getQuantity() {
            return this.quantity;
        }

        public long getPlacerOrderNumber() {
            return this.placerOrderNumber;
        }

        public Date getDate() {
            return this.date;
        }

        public User getClinician() {
            return this.clinician;
        }

        public Entity getPharmacy() {
            return this.pharmacy;
        }

        static enum Type {
            CREATE,
            UPDATE,
            CANCEL,
            DISCONTINUE;

        }
    }
}

