/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.laboratory.internal.dispatcher.Confirmation;
import org.openvpms.laboratory.internal.dispatcher.OrderDispatcher;
import org.openvpms.laboratory.internal.dispatcher.OrderService;

public class TestOrderDispatcher
implements OrderDispatcher {
    private final ArchetypeService service;
    private final OrderService orderService;

    public TestOrderDispatcher(IArchetypeService service) {
        this.service = service;
        this.orderService = new OrderService((ArchetypeService)service, new LaboratoryRules(service));
    }

    public void create(Act investigation) {
        IMObjectBean bean = this.service.getBean((IMObject)investigation);
        boolean confirmOrder = bean.getBoolean("confirmOrder");
        Act order = (Act)bean.getTarget("order", Act.class);
        if (order == null) {
            if (confirmOrder) {
                this.orderService.createOrder(investigation, false);
            } else {
                this.orderService.createOrder(investigation, true);
            }
        }
    }

    public Confirmation order(Act investigation) {
        throw new UnsupportedOperationException();
    }

    public void cancel(Act investigation) {
        IMObjectBean bean = this.service.getBean((IMObject)investigation);
        Act order = (Act)bean.getTarget("order", Act.class);
        if (order != null) {
            this.orderService.cancel(order);
        }
    }
}

