/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.hl7.laboratory.LaboratoryOrderService;
import org.openvpms.hl7.patient.PatientContext;

public class TestLaboratoryOrderService
implements LaboratoryOrderService {
    private List<LabOrder> orders = new ArrayList<LabOrder>();

    public boolean createOrder(PatientContext context, long placerOrderNumber, String serviceId, Date date, Entity laboratory) {
        this.orders.add(new LabOrder(LabOrder.Type.CREATE, context.getPatient(), placerOrderNumber, date, context.getClinician(), laboratory));
        return true;
    }

    public boolean cancelOrder(PatientContext context, long placerOrderNumber, String serviceId, Date date, Entity laboratory) {
        this.orders.add(new LabOrder(LabOrder.Type.CANCEL, context.getPatient(), placerOrderNumber, date, context.getClinician(), laboratory));
        return true;
    }

    public List<LabOrder> getOrders() {
        return this.orders;
    }

    public void clear() {
        this.orders.clear();
    }

    public static class LabOrder {
        private final Type type;
        private final Party patient;
        private final long placerOrderNumber;
        private final Date date;
        private final User clinician;
        private final Entity laboratory;

        public LabOrder(Type type, Party patient, long placerOrderNumber, Date date, User clinician, Entity laboratory) {
            this.type = type;
            this.patient = patient;
            this.placerOrderNumber = placerOrderNumber;
            this.date = date;
            this.clinician = clinician;
            this.laboratory = laboratory;
        }

        public Type getType() {
            return this.type;
        }

        public Party getPatient() {
            return this.patient;
        }

        public long getPlacerOrderNumber() {
            return this.placerOrderNumber;
        }

        public Date getDate() {
            return this.date;
        }

        public User getClinician() {
            return this.clinician;
        }

        public Entity getLaboratory() {
            return this.laboratory;
        }

        static enum Type {
            CREATE,
            CANCEL;

        }
    }
}

