/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import org.mockito.Mockito;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.hl7.laboratory.Laboratories;
import org.openvpms.hl7.laboratory.LaboratoryOrderService;
import org.openvpms.hl7.patient.PatientContextFactory;
import org.openvpms.hl7.patient.PatientInformationService;
import org.openvpms.hl7.pharmacy.Pharmacies;
import org.openvpms.hl7.pharmacy.PharmacyOrderService;
import org.openvpms.laboratory.internal.dispatcher.OrderDispatcher;
import org.openvpms.laboratory.internal.service.LaboratoryServicesImpl;
import org.openvpms.laboratory.service.LaboratoryServices;
import org.openvpms.plugin.manager.PluginManager;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.DefaultCustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.EditorQueue;
import org.openvpms.web.workspace.customer.charge.OrderPlacer;
import org.openvpms.web.workspace.customer.charge.OrderServices;
import org.openvpms.web.workspace.customer.charge.TestChargeItemRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.charge.TestLaboratoryOrderService;
import org.openvpms.web.workspace.customer.charge.TestOrderDispatcher;
import org.openvpms.web.workspace.customer.charge.TestPharmacyOrderService;

public class TestChargeEditor
extends DefaultCustomerChargeActEditor {
    private TestPharmacyOrderService pharmacyOrderService;
    private TestLaboratoryOrderService laboratoryOrderService;

    public TestChargeEditor(FinancialAct act, LayoutContext context, boolean addDefaultItem) {
        super(act, null, context, addDefaultItem);
    }

    public void delete(Act item) {
        this.getItems().remove((IMObject)item);
    }

    public CustomerChargeActItemEditor getCurrentEditor() {
        return (CustomerChargeActItemEditor)this.getItems().getCurrentEditor();
    }

    public CustomerChargeActItemEditor getEditor(Act object) {
        return this.getItems().getEditor((IMObject)object);
    }

    public EditorQueue getQueue() {
        return this.getItems().getEditorQueue();
    }

    public TestPharmacyOrderService getPharmacyOrderService() {
        return this.pharmacyOrderService;
    }

    public TestLaboratoryOrderService getLaboratoryOrderService() {
        return this.laboratoryOrderService;
    }

    public TestChargeItemRelationshipCollectionEditor getItems() {
        return (TestChargeItemRelationshipCollectionEditor)super.getItems();
    }

    public IMObjectEditor newInstance() {
        return new TestChargeEditor((FinancialAct)this.reload((IMObject)this.getObject()), this.getLayoutContext(), this.getAddDefaultIem());
    }

    protected ActRelationshipCollectionEditor createItemsEditor(Act act, CollectionProperty items) {
        return new TestChargeItemRelationshipCollectionEditor(items, act, this.getLayoutContext());
    }

    protected OrderPlacer createOrderPlacer(Party customer, Party practice, Party location, User user) {
        this.pharmacyOrderService = new TestPharmacyOrderService();
        this.laboratoryOrderService = new TestLaboratoryOrderService();
        TestOrderDispatcher dispatcher = new TestOrderDispatcher((IArchetypeService)ServiceHelper.getArchetypeService());
        LaboratoryRules laboratoryRules = (LaboratoryRules)ServiceHelper.getBean(LaboratoryRules.class);
        LaboratoryServicesImpl laboratoryServices = new LaboratoryServicesImpl((PluginManager)Mockito.mock(PluginManager.class), laboratoryRules);
        OrderServices services = new OrderServices((PharmacyOrderService)this.pharmacyOrderService, (Pharmacies)ServiceHelper.getBean(Pharmacies.class), (LaboratoryOrderService)this.laboratoryOrderService, (Laboratories)ServiceHelper.getBean(Laboratories.class), (LaboratoryServices)laboratoryServices, (OrderDispatcher)dispatcher, (PatientContextFactory)ServiceHelper.getBean(PatientContextFactory.class), (PatientInformationService)ServiceHelper.getBean(PatientInformationService.class), (MedicalRecordRules)ServiceHelper.getBean(MedicalRecordRules.class), (PracticeRules)ServiceHelper.getBean(PracticeRules.class));
        return new OrderPlacer(customer, location, user, practice, this.getLayoutContext().getCache(), services, (IArchetypeService)ServiceHelper.getArchetypeService());
    }
}

