/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.charge.AbstractCustomerChargeActEditorTest;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeTestHelper;
import org.openvpms.web.workspace.customer.charge.DefaultCustomerChargeActEditDialog;
import org.openvpms.web.workspace.customer.charge.DefaultCustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.TestChargeEditor;
import org.openvpms.web.workspace.customer.order.PharmacyTestHelper;

public class DefaultCustomerChargeActEditDialogTestCase
extends AbstractCustomerChargeActEditorTest {
    private LayoutContext layoutContext;
    private Party customer;
    private Party patient;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.customer = this.customerFactory.createCustomer();
        this.patient = this.patientFactory.createPatient(this.customer);
        this.layoutContext = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        this.layoutContext.setEdit(true);
        this.layoutContext.getContext().setPractice(this.getPractice());
        this.layoutContext.getContext().setCustomer(this.customer);
        this.layoutContext.getContext().setPatient(this.patient);
        this.layoutContext.getContext().setUser(TestHelper.createUser());
        this.layoutContext.getContext().setClinician(TestHelper.createClinician());
        this.layoutContext.getContext().setLocation(TestHelper.createLocation());
    }

    @Test
    public void testOrderCharger() {
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        Product product = this.productFactory.createMedication();
        FinancialAct order1 = PharmacyTestHelper.createOrder(this.customer, this.patient, product, BigDecimal.ONE, null);
        FinancialAct order2 = PharmacyTestHelper.createOrder(this.customer, this.patient, product, BigDecimal.ONE, null);
        TestChargeEditor editor = new TestChargeEditor(charge, this.layoutContext, false);
        DefaultCustomerChargeActEditDialog dialog = new DefaultCustomerChargeActEditDialog((CustomerChargeActEditor)editor, this.layoutContext.getContext());
        Assert.assertEquals((long)0L, (long)editor.getItems().getActs().size());
        dialog.show();
        CustomerChargeTestHelper.checkSavePopup(editor.getQueue(), "act.patientMedication", false);
        CustomerChargeTestHelper.checkSavePopup(editor.getQueue(), "act.patientMedication", false);
        Assert.assertEquals((long)2L, (long)editor.getItems().getActs().size());
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertTrue((boolean)dialog.save());
        order1 = (FinancialAct)this.get((IMObject)order1);
        order2 = (FinancialAct)this.get((IMObject)order2);
        Assert.assertEquals((Object)"POSTED", (Object)order1.getStatus());
        Assert.assertEquals((Object)"POSTED", (Object)order2.getStatus());
    }

    @Test
    public void testReloadWithChargedOrders() {
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        IMObjectBean bean = this.getBean((IMObject)charge);
        bean.setTarget("customer", (IMObject)this.customer);
        bean.save();
        Product product = this.productFactory.createMedication();
        FinancialAct order = PharmacyTestHelper.createOrder(this.customer, this.patient, product, BigDecimal.ONE, null);
        TestChargeEditor editor1 = new TestChargeEditor(charge, this.layoutContext, false);
        DefaultCustomerChargeActEditDialog dialog = new DefaultCustomerChargeActEditDialog((CustomerChargeActEditor)editor1, this.layoutContext.getContext());
        dialog.show();
        CustomerChargeTestHelper.checkSavePopup(editor1.getQueue(), "act.patientMedication", false);
        Assert.assertEquals((long)1L, (long)editor1.getItems().getActs().size());
        FinancialAct copy = (FinancialAct)this.get((IMObject)charge);
        copy.setStatus("COMPLETED");
        this.save((IMObject)copy);
        Assert.assertFalse((boolean)dialog.save());
        ErrorDialog error = (ErrorDialog)EchoTestHelper.getWindowPane(ErrorDialog.class);
        Assert.assertEquals((Object)"The Invoice could not be saved. It may have been changed by another user.\n\nYour changes have been reverted.", (Object)error.getMessage());
        Assert.assertNotNull((Object)error);
        EchoTestHelper.fireDialogButton((PopupDialog)error, (String)"ok");
        order = (FinancialAct)this.get((IMObject)order);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)order.getStatus());
        CustomerChargeActEditor editor2 = dialog.getEditor();
        Assert.assertNotEquals((Object)((Object)editor1), (Object)editor2);
        Assert.assertEquals((long)0L, (long)editor2.getItems().getActs().size());
        editor2.setStatus("IN_PROGRESS");
        Assert.assertTrue((boolean)dialog.save());
        order = (FinancialAct)this.get((IMObject)order);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)order.getStatus());
    }

    @Test
    public void testAutoSave() {
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = new TestChargeEditor(charge, this.layoutContext, false);
        DefaultCustomerChargeActEditDialog dialog = new DefaultCustomerChargeActEditDialog((CustomerChargeActEditor)editor, this.layoutContext.getContext());
        Assert.assertEquals((long)0L, (long)editor.getItems().getActs().size());
        dialog.show();
        CustomerChargeActItemEditor item1 = (CustomerChargeActItemEditor)editor.getItems().onAdd();
        Assert.assertNotNull((Object)item1);
        Assert.assertTrue((boolean)editor.getObject().isNew());
        item1.setProduct(this.productFactory.createMedication());
        item1.setQuantity(BigDecimal.TEN);
        CustomerChargeTestHelper.checkSavePopup(editor.getQueue(), "act.patientMedication", false);
        CustomerChargeActItemEditor item2 = (CustomerChargeActItemEditor)editor.getItems().onAdd();
        Assert.assertNotNull((Object)item2);
        Assert.assertTrue((boolean)editor.getObject().isNew());
        Assert.assertTrue((boolean)dialog.save());
        Product product2 = this.productFactory.createMedication();
        item2.setProduct(product2);
        item2.setQuantity(BigDecimal.ONE);
        CustomerChargeTestHelper.checkSavePopup(editor.getQueue(), "act.patientMedication", false);
        CustomerChargeActItemEditor item3 = (CustomerChargeActItemEditor)editor.getItems().onAdd();
        Assert.assertNotNull((Object)item3);
        this.checkInvoice(editor, "IN_PROGRESS", 2);
        item3.setProduct(this.productFactory.createMedication());
        item3.setQuantity(BigDecimal.TEN);
        CustomerChargeTestHelper.checkSavePopup(editor.getQueue(), "act.patientMedication", false);
        item2.setProduct(null);
        CustomerChargeActItemEditor item4 = (CustomerChargeActItemEditor)editor.getItems().onAdd();
        Assert.assertNotNull((Object)item4);
        item4.setProduct(this.productFactory.createMedication());
        item4.setQuantity(BigDecimal.ONE);
        CustomerChargeTestHelper.checkSavePopup(editor.getQueue(), "act.patientMedication", false);
        this.checkInvoice(editor, "IN_PROGRESS", 2);
        item2.setProduct(this.productFactory.createMedication());
        CustomerChargeTestHelper.checkSavePopup(editor.getQueue(), "act.patientMedication", false);
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor item5 = (CustomerChargeActItemEditor)editor.getItems().onAdd();
        Assert.assertNotNull((Object)item5);
        this.checkInvoice(editor, "IN_PROGRESS", 4);
        item5.setProduct(this.productFactory.createMedication());
        item5.setQuantity(BigDecimal.TEN);
        CustomerChargeTestHelper.checkSavePopup(editor.getQueue(), "act.patientMedication", false);
        editor.setStatus("POSTED");
        CustomerChargeActItemEditor item6 = (CustomerChargeActItemEditor)editor.getItems().onAdd();
        Assert.assertNotNull((Object)item6);
        this.checkInvoice(editor, "IN_PROGRESS", 4);
        Assert.assertTrue((boolean)dialog.save());
        this.checkInvoice(editor, "POSTED", 5);
        Assert.assertFalse((boolean)dialog.save());
    }

    private void checkInvoice(DefaultCustomerChargeActEditor editor, String status, int items) {
        FinancialAct charge = (FinancialAct)this.get((IMObject)editor.getObject());
        Assert.assertNotNull((Object)charge);
        Assert.assertEquals((Object)status, (Object)charge.getStatus());
        IMObjectBean bean = this.getBean((IMObject)charge);
        Assert.assertEquals((long)items, (long)bean.getTargets("items").size());
    }
}

