/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.patient.PatientHistoryChanges;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.rules.stock.StockRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerChargeBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemVerifier;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.lookup.TestCurrencyBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientAlertTypeBuilder;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderFactory;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderTypeBuilder;
import org.openvpms.archetype.test.builder.product.TestFixedPriceBuilder;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestMerchandiseProductBuilder;
import org.openvpms.archetype.test.builder.product.TestServiceProductBuilder;
import org.openvpms.archetype.test.builder.product.TestTemplateProductBuilder;
import org.openvpms.archetype.test.builder.product.TestUnitPriceBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestTaskTypeBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestTaskVerifier;
import org.openvpms.archetype.test.builder.scheduling.TestWorkListBuilder;
import org.openvpms.archetype.test.builder.user.TestUserBuilder;
import org.openvpms.component.business.service.security.AuthenticationContext;
import org.openvpms.component.business.service.security.AuthenticationContextImpl;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.charge.AbstractCustomerChargeActEditorTest;
import org.openvpms.web.workspace.customer.charge.ChargeSaveContext;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeEditContext;
import org.openvpms.web.workspace.customer.charge.CustomerChargeTestHelper;
import org.openvpms.web.workspace.customer.charge.DefaultCustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.EditorQueue;
import org.openvpms.web.workspace.patient.mr.PatientMedicationActEditor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionTemplate;

public class CustomerChargeActItemEditorTestCase
extends AbstractCustomerChargeActEditorTest {
    private final List<String> errors = new ArrayList<String>();
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestLaboratoryFactory laboratoryFactory;
    @Autowired
    private TestLookupFactory lookupFactory;
    @Autowired
    private TestReminderFactory reminderFactory;
    private Party customer;
    private User user;
    private Context context;
    private AuthenticationContext authenticationContext;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.customer = this.customerFactory.createCustomer();
        this.initErrorHandler(this.errors);
        this.context = new LocalContext();
        this.context.setPractice(this.getPractice());
        this.context.setCustomer(this.customer);
        Party location = (Party)this.practiceFactory.newLocation().stockControl().build();
        this.context.setLocation(location);
        this.context.setStockLocation(this.practiceFactory.createStockLocation(new Party[]{location}));
        ((TestCurrencyBuilder)this.lookupFactory.newCurrency().code("AUD")).minPrice(new BigDecimal("0.20")).build();
        this.authenticationContext = new AuthenticationContextImpl();
        this.user = this.userFactory.createUser();
        this.context.setUser(this.user);
        this.authenticationContext.setUser(this.user);
    }

    @Test
    public void testInvoiceItemMedication() {
        this.checkInvoiceItem("product.medication");
    }

    @Test
    public void testInvoiceItemMerchandise() {
        this.checkInvoiceItem("product.merchandise");
    }

    @Test
    public void testInvoiceItemService() {
        this.checkInvoiceItem("product.service");
    }

    @Test
    public void testInvoiceItemTemplate() {
        this.checkItemWithTemplate(this.createInvoice());
    }

    @Test
    public void testCounterSaleItemMedication() {
        this.checkCounterSaleItem("product.medication");
    }

    @Test
    public void testCounterSaleItemMerchandise() {
        this.checkCounterSaleItem("product.merchandise");
    }

    @Test
    public void testCounterSaleItemService() {
        this.checkCounterSaleItem("product.service");
    }

    @Test
    public void testCounterSaleItemTemplate() {
        this.checkItemWithTemplate(this.createCounterSale());
    }

    @Test
    public void testCreditItemMedication() {
        this.checkCreditItem("product.medication");
    }

    @Test
    public void testCreditItemMerchandise() {
        this.checkCreditItem("product.merchandise");
    }

    @Test
    public void testCreditItemService() {
        this.checkCreditItem("product.service");
    }

    @Test
    public void testCreditItemTemplate() {
        this.checkItemWithTemplate(this.createCredit());
    }

    @Test
    public void testClearClinician() {
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        Party patient = this.patientFactory.createPatient(this.customer);
        User clinician = this.userFactory.createClinician();
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal unitCost = BigDecimal.valueOf(5L);
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal fixedCost = BigDecimal.valueOf(1L);
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal discount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.valueOf(2L);
        BigDecimal total = new BigDecimal("22");
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        Product product = (Product)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().fixedPrice(fixedCost, fixedPrice)).unitPrice(unitCost, unitPrice)).build();
        this.addDocumentTemplate(product, "act.patientDocumentForm");
        this.addDocumentTemplate(product, "act.patientDocumentLetter");
        CustomerChargeEditContext editContext = this.createEditContext((LayoutContext)layout);
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, editContext, (LayoutContext)layout);
        Assert.assertFalse((boolean)editor.isValid());
        editor.setQuantity(quantity);
        editor.setPatient(patient);
        editor.setClinician(clinician);
        editor.setProduct(product);
        EditorTestHelper.assertValid((Modifiable)editor);
        editor.setClinician(null);
        this.checkSave(charge, editor);
        charge = (FinancialAct)this.get((IMObject)charge);
        item = (FinancialAct)this.get((IMObject)item);
        Assert.assertNotNull((Object)charge);
        Assert.assertNotNull((Object)item);
        FinancialTestHelper.checkItem((FinancialAct)item, (String)"act.customerAccountInvoiceItem", (Party)patient, (Product)product, null, (int)-1, (User)this.user, null, (BigDecimal)BigDecimal.ZERO, (BigDecimal)quantity, (BigDecimal)unitCost, (BigDecimal)new BigDecimal(10), (BigDecimal)fixedCost, (BigDecimal)new BigDecimal(2), (BigDecimal)discount, (BigDecimal)tax, (BigDecimal)total, (boolean)true);
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    @Test
    public void testServiceRatios() {
        this.practiceFactory.updatePractice(this.context.getPractice()).departments(true).build();
        Entity productType = this.productFactory.createProductType();
        this.practiceFactory.updateLocation(this.context.getLocation()).addServiceRatio(productType, 3).build();
        Entity department1 = this.practiceFactory.createDepartment();
        Entity department2 = (Entity)this.practiceFactory.newDepartment().addServiceRatio(productType, 2).build();
        this.userFactory.updateUser(this.user).addDepartments(new Entity[]{department1, department2}).build();
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        Party patient = this.patientFactory.createPatient(this.customer);
        this.context.setDepartment(department1);
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal unitCost = BigDecimal.valueOf(5L);
        BigDecimal fixedCost = BigDecimal.valueOf(1L);
        Product product1 = (Product)((TestServiceProductBuilder)((TestFixedPriceBuilder)((TestServiceProductBuilder)((TestUnitPriceBuilder)((TestServiceProductBuilder)this.productFactory.newService().type(productType)).newUnitPrice().costAndPrice(5, "9.09")).add()).newFixedPrice().costAndPrice(1, "1.82")).add()).build();
        Product product2 = (Product)((TestServiceProductBuilder)((TestFixedPriceBuilder)((TestServiceProductBuilder)((TestUnitPriceBuilder)this.productFactory.newService().newUnitPrice().costAndPrice(5, "9.09")).add()).newFixedPrice().costAndPrice(1, "1.82")).add()).build();
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, (LayoutContext)layout);
        Assert.assertEquals((Object)department1, (Object)editor.getDepartment());
        editor.setQuantity(quantity);
        editor.setPatient(patient);
        editor.setProduct(product1);
        EditorTestHelper.assertValid((Modifiable)editor);
        this.checkSave(charge, editor);
        TestInvoiceItemVerifier verifier = (TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)new TestInvoiceItemVerifier((ArchetypeService)this.getArchetypeService()).patient(patient)).product(product1)).department(department1)).createdBy(this.user)).quantity(quantity)).serviceRatio(3)).fixedCost(fixedCost)).fixedPrice(6)).unitCost(unitCost)).unitPrice(30)).tax(6)).total(66);
        verifier.verify(this.get((IMObject)item));
        editor.setDepartment(department2);
        this.checkSave(charge, editor);
        ((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)verifier.department(department2)).serviceRatio(2)).fixedPrice(4)).unitPrice(20)).tax(4)).total(44)).verify(this.get((IMObject)item));
        editor.setDepartment(null);
        this.checkSave(charge, editor);
        ((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)verifier.department((Reference)null)).serviceRatio(3)).fixedPrice(6)).unitPrice(30)).tax(6)).total(66)).verify(this.get((IMObject)item));
        editor.setProduct(product2);
        this.checkSave(charge, editor);
        ((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)verifier.product(product2)).serviceRatio(null)).fixedPrice(2)).unitPrice(10)).tax(2)).total(22)).verify(this.get((IMObject)item));
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    @Test
    public void testCalendarBasedServiceRatios() {
        Entity productType = this.productFactory.createProductType();
        Entity calendar = this.productFactory.createServiceRatioCalendar();
        this.practiceFactory.updateLocation(this.context.getLocation()).addServiceRatio(productType, 2, calendar).build();
        Date tomorrow = DateRules.getTomorrow();
        this.schedulingFactory.createCalendarEvent(calendar, tomorrow, DateRules.getNextDate((Date)tomorrow));
        Product product1 = (Product)((TestServiceProductBuilder)((TestFixedPriceBuilder)((TestServiceProductBuilder)((TestUnitPriceBuilder)((TestServiceProductBuilder)this.productFactory.newService().type(productType)).newUnitPrice().costAndPrice(5, "9.09")).add()).newFixedPrice().costAndPrice(1, "1.82")).add()).build();
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, (LayoutContext)layout);
        editor.setQuantity(BigDecimal.ONE);
        Party patient = this.patientFactory.createPatient(this.customer);
        editor.setPatient(patient);
        editor.setProduct(product1);
        EditorTestHelper.assertValid((Modifiable)editor);
        this.checkSave(charge, editor);
        TestInvoiceItemVerifier verifier = (TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)new TestInvoiceItemVerifier((ArchetypeService)this.getArchetypeService()).patient(patient)).product(product1)).quantity(1)).serviceRatio(null)).createdBy(this.user)).fixedCost(1)).fixedPrice(2)).unitCost(5)).unitPrice(10)).tax(new BigDecimal("1.091"))).total(12);
        verifier.verify(this.get((IMObject)item));
        editor.setStartTime(tomorrow);
        this.checkSave(charge, editor);
        ((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)verifier.serviceRatio(2)).fixedPrice(4)).unitPrice(20)).tax(new BigDecimal("2.182"))).total(24)).verify(this.get((IMObject)item));
    }

    @Test
    public void testTaxExemption() {
        this.addTaxExemption(this.customer);
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        Party patient = this.patientFactory.createPatient(this.customer);
        User clinician = this.userFactory.createClinician();
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal unitCost = BigDecimal.valueOf(5L);
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal fixedCost = BigDecimal.valueOf(1L);
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal discount = BigDecimal.ZERO;
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        Product product = (Product)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().fixedPrice(fixedCost, fixedPrice)).unitPrice(unitCost, unitPrice)).build();
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, (LayoutContext)layout);
        Assert.assertFalse((boolean)editor.isValid());
        editor.setQuantity(quantity);
        editor.setPatient(patient);
        editor.setClinician(clinician);
        editor.setProduct(product);
        EditorTestHelper.assertValid((Modifiable)editor);
        editor.setClinician(null);
        this.checkSave(charge, editor);
        charge = (FinancialAct)this.get((IMObject)charge);
        item = (FinancialAct)this.get((IMObject)item);
        Assert.assertNotNull((Object)charge);
        Assert.assertNotNull((Object)item);
        BigDecimal unitPriceExTax = new BigDecimal("9.00");
        BigDecimal fixedPriceExTax = new BigDecimal("1.80");
        FinancialTestHelper.checkItem((FinancialAct)item, (String)"act.customerAccountInvoiceItem", (Party)patient, (Product)product, null, (int)-1, (User)this.user, null, (BigDecimal)BigDecimal.ZERO, (BigDecimal)quantity, (BigDecimal)unitCost, (BigDecimal)unitPriceExTax, (BigDecimal)fixedCost, (BigDecimal)fixedPriceExTax, (BigDecimal)discount, (BigDecimal)BigDecimal.ZERO, (BigDecimal)new BigDecimal("19.80"), (boolean)true);
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    @Test
    public void testTaxExemptionWithServiceRatio() {
        this.addTaxExemption(this.customer);
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        Party patient = this.patientFactory.createPatient(this.customer);
        User clinician = this.userFactory.createClinician();
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal unitCost = BigDecimal.valueOf(5L);
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal fixedCost = BigDecimal.valueOf(1L);
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal discount = BigDecimal.ZERO;
        BigDecimal ratio = BigDecimal.valueOf(2L);
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        Entity productType = this.productFactory.createProductType();
        Product product = (Product)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().fixedPrice(fixedCost, fixedPrice)).unitPrice(unitCost, unitPrice)).type(productType)).build();
        this.practiceFactory.updateLocation(this.context.getLocation()).addServiceRatio(productType, ratio).build();
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, (LayoutContext)layout);
        Assert.assertFalse((boolean)editor.isValid());
        editor.setQuantity(quantity);
        editor.setPatient(patient);
        editor.setClinician(clinician);
        editor.setProduct(product);
        EditorTestHelper.assertValid((Modifiable)editor);
        this.checkSave(charge, editor);
        charge = (FinancialAct)this.get((IMObject)charge);
        item = (FinancialAct)this.get((IMObject)item);
        Assert.assertNotNull((Object)charge);
        Assert.assertNotNull((Object)item);
        BigDecimal fixedPriceExTax = new BigDecimal("3.60");
        BigDecimal unitPriceExTax = new BigDecimal("18.20");
        BigDecimal totalExTax = unitPriceExTax.multiply(quantity).add(fixedPriceExTax);
        FinancialTestHelper.checkItem((FinancialAct)item, (String)"act.customerAccountInvoiceItem", (Party)patient, (Product)product, null, (int)-1, (User)this.user, (User)clinician, (BigDecimal)BigDecimal.ZERO, (BigDecimal)quantity, (BigDecimal)unitCost, (BigDecimal)unitPriceExTax, (BigDecimal)fixedCost, (BigDecimal)fixedPriceExTax, (BigDecimal)discount, (BigDecimal)BigDecimal.ZERO, (BigDecimal)totalExTax, (boolean)true);
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    @Test
    public void testInvoiceItemDiscounts() {
        Charge invoice = this.createInvoice();
        this.checkDiscounts(invoice.getCharge(), invoice.getItem(), false);
    }

    @Test
    public void testNegativeInvoiceItemDiscounts() {
        Charge invoice = this.createInvoice();
        this.checkDiscounts(invoice.getCharge(), invoice.getItem(), true);
    }

    @Test
    public void testCounterSaleItemDiscounts() {
        Charge charge = this.createCounterSale();
        this.checkDiscounts(charge.getCharge(), charge.getItem(), false);
    }

    @Test
    public void testNegativeCounterSaleItemDiscounts() {
        Charge counterSale = this.createCounterSale();
        this.checkDiscounts(counterSale.getCharge(), counterSale.getItem(), true);
    }

    @Test
    public void testCreditItemDiscounts() {
        Charge credit = this.createCredit();
        this.checkDiscounts(credit.getCharge(), credit.getItem(), false);
    }

    @Test
    public void testNegativeCreditDiscounts() {
        Charge credit = this.createCredit();
        this.checkDiscounts(credit.getCharge(), credit.getItem(), true);
    }

    @Test
    public void testDisableDiscounts() {
        this.practiceFactory.updateLocation(this.context.getLocation()).disableDiscounts(true).build();
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal unitCost = BigDecimal.valueOf(5L);
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal unitPriceIncTax = BigDecimal.TEN;
        BigDecimal fixedCost = BigDecimal.valueOf(1L);
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal fixedPriceIncTax = BigDecimal.valueOf(2L);
        User clinician = this.userFactory.createClinician();
        Entity discount = (Entity)this.productFactory.newDiscount().percentage(BigDecimal.TEN).discountFixedPrice(true).build();
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedCost, fixedPrice)).unitPrice(unitCost, unitPrice)).build();
        Party patient = (Party)this.patientFactory.newPatient().owner(this.customer).addDiscounts(new Entity[]{discount}).build();
        this.customerFactory.updateCustomer(this.customer).addDiscounts(new Entity[]{discount}).build();
        this.productFactory.updateProduct(product).addDiscounts(new Entity[]{discount}).build();
        this.context.setClinician(clinician);
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        CustomerChargeEditContext editContext = this.createEditContext((LayoutContext)layout);
        editContext.setEditorQueue(null);
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, editContext, (LayoutContext)layout);
        Assert.assertFalse((boolean)editor.isValid());
        if (!item.isA("act.customerAccountCounterItem")) {
            editor.setPatient(patient);
        }
        editor.setProduct(product);
        editor.setQuantity(quantity);
        EditorTestHelper.assertValid((Modifiable)editor);
        this.checkSave(charge, editor);
        item = (FinancialAct)this.get((IMObject)item);
        BigDecimal discount1 = BigDecimal.ZERO;
        BigDecimal tax1 = new BigDecimal("2.00");
        BigDecimal total1 = new BigDecimal("22.00");
        FinancialTestHelper.checkItem((FinancialAct)item, (String)"act.customerAccountInvoiceItem", (Party)patient, (Product)product, null, (int)-1, (User)this.user, (User)clinician, (BigDecimal)BigDecimal.ZERO, (BigDecimal)quantity, (BigDecimal)unitCost, (BigDecimal)unitPriceIncTax, (BigDecimal)fixedCost, (BigDecimal)fixedPriceIncTax, (BigDecimal)discount1, (BigDecimal)tax1, (BigDecimal)total1, (boolean)true);
    }

    @Test
    public void testInvoiceProductDose() {
        Charge invoice = this.createInvoice();
        this.checkProductDose(invoice.getCharge(), invoice.getItem());
    }

    @Test
    public void testCreditProductDose() {
        Charge credit = this.createCredit();
        this.checkProductDose(credit.getCharge(), credit.getItem());
    }

    @Test
    public void testCounterProductDose() {
        Charge counter = this.createCounterSale();
        FinancialAct charge = counter.getCharge();
        FinancialAct item = counter.getItem();
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        Party patient = this.patientFactory.createPatient(this.customer);
        this.patientFactory.createWeight(patient, new BigDecimal("4.2"));
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal unitCost = BigDecimal.valueOf(5L);
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal fixedCost = BigDecimal.valueOf(1L);
        BigDecimal fixedPrice = new BigDecimal("1.82");
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedCost, fixedPrice)).unitPrice(unitCost, unitPrice)).newDose().weightRange(0, 10).rate(1).quantity(1).add().build();
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, (LayoutContext)layout);
        Assert.assertFalse((boolean)editor.isValid());
        Assert.assertFalse((boolean)editor.isDefaultQuantity());
        editor.setQuantity(quantity);
        Assert.assertFalse((boolean)editor.isDefaultQuantity());
        editor.setProduct(product);
        this.checkEquals(quantity, item.getQuantity());
        Assert.assertFalse((boolean)editor.isDefaultQuantity());
    }

    @Test
    public void testMicrochip() {
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        Party patient = this.patientFactory.createPatient(this.customer);
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        Product product = (Product)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().patientIdentity("entityIdentity.microchip")).build();
        CustomerChargeEditContext editContext = this.createEditContext((LayoutContext)layout);
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, editContext, (LayoutContext)layout);
        editor.setQuantity(BigDecimal.ONE);
        editor.setPatient(patient);
        editor.setProduct(product);
        Assert.assertFalse((boolean)editor.isValid());
        Assert.assertTrue((boolean)(editContext.getEditorQueue().getCurrent() instanceof EditDialog));
        EditDialog dialog = (EditDialog)editContext.getEditorQueue().getCurrent();
        IMObjectEditor microchip = dialog.getEditor();
        microchip.getProperty("identity").setValue((Object)"123456789");
        CustomerChargeTestHelper.checkSavePopup(editContext.getEditorQueue(), "entityIdentity.microchip", false);
        this.checkSave(charge, editor);
        patient = (Party)this.get((IMObject)patient);
        Assert.assertEquals((long)1L, (long)patient.getIdentities().size());
        EntityIdentity identity = (EntityIdentity)patient.getIdentities().iterator().next();
        Assert.assertEquals((Object)"123456789", (Object)identity.getIdentity());
        Assert.assertEquals((Object)"  (Microchip: 123456789)", (Object)patient.getDescription());
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    @Test
    public void testMinimumQuantities() {
        BigDecimal two = BigDecimal.valueOf(2L);
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        Party patient = this.patientFactory.createPatient(this.customer);
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        Product product = this.productFactory.createService();
        CustomerChargeEditContext editContext = this.createEditContext((LayoutContext)layout);
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, editContext, (LayoutContext)layout);
        editor.setPatient(patient);
        editor.setProduct(product);
        editor.setMinimumQuantity(two);
        editor.setQuantity(two);
        EditorTestHelper.assertValid((Modifiable)editor);
        editor.setQuantity(BigDecimal.ONE);
        Assert.assertFalse((boolean)editor.isValid());
        editor.setQuantity(two);
        EditorTestHelper.assertValid((Modifiable)editor);
    }

    @Test
    public void testMinimumQuantitiesOverride() {
        BigDecimal two = BigDecimal.valueOf(2L);
        Lookup userType = this.lookupFactory.getLookup("lookup.userType", "MINIMUM_QTY_OVERRIDE");
        this.practiceFactory.updatePractice(this.context.getPractice()).minimumQuantitiesOverride(userType.getCode()).build();
        ((TestUserBuilder)this.userFactory.updateUser(this.user).addClassifications(new Lookup[]{userType})).build();
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        Party patient = this.patientFactory.createPatient(this.customer);
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        Product product = this.productFactory.createService();
        CustomerChargeEditContext editContext = this.createEditContext((LayoutContext)layout);
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, editContext, (LayoutContext)layout);
        editor.setPatient(patient);
        editor.setProduct(product);
        editor.setMinimumQuantity(two);
        editor.setQuantity(two);
        EditorTestHelper.assertValid((Modifiable)editor);
        editor.setQuantity(BigDecimal.TEN);
        this.checkEquals(two, editor.getMinimumQuantity());
        editor.setQuantity(BigDecimal.ONE);
        this.checkEquals(1, editor.getMinimumQuantity());
        EditorTestHelper.assertValid((Modifiable)editor);
        BigDecimal minusOne = BigDecimal.valueOf(-1L);
        editor.setQuantity(minusOne);
        this.checkEquals(minusOne, editor.getMinimumQuantity());
        EditorTestHelper.assertValid((Modifiable)editor);
        editor.setQuantity(BigDecimal.ZERO);
        this.checkEquals(0, editor.getMinimumQuantity());
        EditorTestHelper.assertValid((Modifiable)editor);
        editor.setQuantity(BigDecimal.ONE);
        this.checkEquals(0, editor.getMinimumQuantity());
        EditorTestHelper.assertValid((Modifiable)editor);
    }

    @Test
    public void testDefaultFixedPrice() {
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        Party patient = this.patientFactory.createPatient(this.customer);
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        Product product = (Product)((TestServiceProductBuilder)((TestFixedPriceBuilder)((TestServiceProductBuilder)((TestFixedPriceBuilder)this.productFactory.newService().newFixedPrice().price(0)).defaultPrice(false).add()).newFixedPrice().price("0.909")).defaultPrice(true).add()).build();
        TestCustomerChargeActItemEditor editor1 = this.createEditor(charge, item, this.createEditContext((LayoutContext)layout), (LayoutContext)layout);
        editor1.setPatient(patient);
        editor1.setProduct(product);
        editor1.setQuantity(BigDecimal.ONE);
        EditorTestHelper.assertValid((Modifiable)editor1);
        this.save(charge, editor1);
        this.checkEquals(1, editor1.getFixedPrice());
        this.checkEquals(1, editor1.getTotal());
        charge = (FinancialAct)this.get((IMObject)charge);
        item = (FinancialAct)this.get((IMObject)item);
        TestCustomerChargeActItemEditor editor2 = this.createEditor(charge, item, this.createEditContext((LayoutContext)layout), (LayoutContext)layout);
        this.checkEquals(1, editor2.getFixedPrice());
        this.checkEquals(1, editor2.getTotal());
    }

    @Test
    public void testUpdateStock() {
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        Party patient = this.patientFactory.createPatient(this.customer);
        Product product = (Product)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().fixedPrice(10)).build();
        this.checkStock(product, BigDecimal.ZERO);
        TestInvoiceBuilder builder = this.accountFactory.newInvoice();
        FinancialAct charge = (FinancialAct)((TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceBuilder)builder.customer(this.customer)).item().patient(patient)).product(product)).quantity(0)).unitPrice(1)).stockLocation(this.context.getStockLocation())).add()).status("IN_PROGRESS")).build();
        FinancialAct item = (FinancialAct)builder.getItems().get(0);
        TestCustomerChargeActItemEditor editor1 = this.createEditor(charge, item, this.createEditContext((LayoutContext)layout), (LayoutContext)layout);
        EditorTestHelper.assertValid((Modifiable)editor1);
        this.save(charge, editor1);
        this.checkStock(product, BigDecimal.ZERO);
        charge = (FinancialAct)this.get((IMObject)charge);
        item = (FinancialAct)this.get((IMObject)item);
        TestCustomerChargeActItemEditor editor2 = this.createEditor(charge, item, this.createEditContext((LayoutContext)layout), (LayoutContext)layout);
        editor2.setQuantity(BigDecimal.TEN);
        this.save(charge, editor2);
        this.checkStock(product, BigDecimal.TEN.negate());
        editor2.setQuantity(BigDecimal.ZERO);
        this.save(charge, editor2);
        this.checkStock(product, BigDecimal.ZERO);
        editor2.setQuantity(BigDecimal.ONE);
        this.save(charge, editor2);
        this.checkStock(product, BigDecimal.ONE.negate());
    }

    @Test
    public void testFixedPriceMaximumDiscount() {
        Entity discount = (Entity)this.productFactory.newDiscount().percentage(100).discountFixedPrice(true).build();
        Party patient = (Party)this.patientFactory.newPatient().addDiscounts(new Entity[]{discount}).build();
        Product product = (Product)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestMerchandiseProductBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newMerchandise().newFixedPrice().costAndPrice(10, 20)).maxDiscount(75)).defaultPrice(true).add()).newFixedPrice().costAndPrice(20, 40)).maxDiscount(50)).defaultPrice(false).add()).addDiscounts(new Entity[]{discount})).build();
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, this.createEditContext((LayoutContext)layout), (LayoutContext)layout);
        editor.setPatient(patient);
        editor.setProduct(product);
        this.checkEquals("22.0", editor.getFixedPrice());
        this.checkEquals("5.50", editor.getTotal());
        editor.setFixedPrice(new BigDecimal("44.0"));
        this.checkEquals("22.00", editor.getTotal());
        editor.setFixedPrice(new BigDecimal("11.0"));
        this.checkEquals(0, editor.getTotal());
    }

    @Test
    public void testReminderForDifferentSpecies() {
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        Party patient1 = this.patientFactory.createPatient(this.customer);
        User clinician1 = this.userFactory.createClinician();
        this.context.setClinician(clinician1);
        BigDecimal quantity1 = BigDecimal.valueOf(2L);
        BigDecimal unitCost1 = BigDecimal.valueOf(5L);
        BigDecimal unitPrice1 = new BigDecimal("9.09");
        BigDecimal unitPrice1IncTax = BigDecimal.TEN;
        BigDecimal fixedCost1 = BigDecimal.ONE;
        BigDecimal fixedPrice1 = new BigDecimal("1.82");
        BigDecimal fixedPrice1IncTax = BigDecimal.valueOf(2L);
        BigDecimal discount1 = BigDecimal.ZERO;
        BigDecimal tax1 = BigDecimal.valueOf(2L);
        BigDecimal total1 = BigDecimal.valueOf(22L);
        Product product = (Product)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().fixedPrice(fixedCost1, fixedPrice1)).unitPrice(unitCost1, unitPrice1)).build();
        Entity reminderType1 = this.addReminderType("ZReminderType1", product, new String[0]);
        Entity reminderType2 = this.addReminderType("ZReminderType2", product, "FELINE");
        Entity reminderType3 = this.addReminderType("ZReminderType3", product, "CANINE");
        Entity reminderType4 = this.addReminderType("ZReminderType4", product, "CANINE", "FELINE");
        CustomerChargeEditContext editContext = this.createEditContext((LayoutContext)layout);
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, editContext, (LayoutContext)layout);
        Assert.assertFalse((boolean)editor.isValid());
        editor.setQuantity(quantity1);
        editor.setPatient(patient1);
        editor.setProduct(product);
        EditorTestHelper.assertValid((Modifiable)editor);
        this.checkSave(charge, editor);
        charge = (FinancialAct)this.get((IMObject)charge);
        item = (FinancialAct)this.get((IMObject)item);
        Assert.assertNotNull((Object)charge);
        Assert.assertNotNull((Object)item);
        FinancialTestHelper.checkItem((FinancialAct)item, (String)"act.customerAccountInvoiceItem", (Party)patient1, (Product)product, null, (int)-1, (User)this.user, (User)clinician1, (BigDecimal)BigDecimal.ZERO, (BigDecimal)quantity1, (BigDecimal)unitCost1, (BigDecimal)unitPrice1IncTax, (BigDecimal)fixedCost1, (BigDecimal)fixedPrice1IncTax, (BigDecimal)discount1, (BigDecimal)tax1, (BigDecimal)total1, (boolean)true);
        IMObjectBean itemBean = this.getBean((IMObject)item);
        Assert.assertTrue((boolean)itemBean.getTargets("dispensing").isEmpty());
        Assert.assertEquals((long)3L, (long)itemBean.getTargets("reminders").size());
        this.checkReminder((Act)item, patient1, product, reminderType1, this.user, clinician1);
        this.checkReminder((Act)item, patient1, product, reminderType3, this.user, clinician1);
        this.checkReminder((Act)item, patient1, product, reminderType4, this.user, clinician1);
        Party patient2 = this.patientFactory.createPatient(this.customer);
        IMObjectBean bean = this.getBean((IMObject)patient2);
        bean.setValue("species", (Object)"FELINE");
        bean.save();
        editor.setPatient(patient2);
        this.checkSave(charge, editor);
        item = (FinancialAct)this.get((IMObject)item);
        FinancialTestHelper.checkItem((FinancialAct)item, (String)"act.customerAccountInvoiceItem", (Party)patient2, (Product)product, null, (int)-1, (User)this.user, (User)clinician1, (BigDecimal)BigDecimal.ZERO, (BigDecimal)quantity1, (BigDecimal)unitCost1, (BigDecimal)unitPrice1IncTax, (BigDecimal)fixedCost1, (BigDecimal)fixedPrice1IncTax, (BigDecimal)discount1, (BigDecimal)tax1, (BigDecimal)total1, (boolean)true);
        itemBean = this.getBean((IMObject)item);
        Assert.assertEquals((long)3L, (long)itemBean.getTargets("reminders").size());
        this.checkReminder((Act)item, patient2, product, reminderType1, this.user, clinician1);
        this.checkReminder((Act)item, patient2, product, reminderType2, this.user, clinician1);
        this.checkReminder((Act)item, patient2, product, reminderType4, this.user, clinician1);
    }

    @Test
    public void testInactiveReminderTypeDoesntCreateReminder() {
        Party patient = this.patientFactory.createPatient(this.customer);
        Product product = this.productFactory.createService();
        Entity reminderType1 = this.addReminderType("ZReminderType1", product, new String[0]);
        Entity reminderType2 = this.addReminderType("ZReminderType2", product, new String[0]);
        reminderType2.setActive(false);
        this.save((IMObject)reminderType2);
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        CustomerChargeEditContext editContext = this.createEditContext((LayoutContext)layout);
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, editContext, (LayoutContext)layout);
        editor.setPatient(patient);
        editor.setProduct(product);
        EditorTestHelper.assertValid((Modifiable)editor);
        this.checkSave(charge, editor);
        Assert.assertEquals((long)1L, (long)this.getBean((IMObject)item).getTargets("reminders", Act.class).size());
        this.checkReminder((Act)this.get((IMObject)item), patient, product, reminderType1, this.user, null);
    }

    @Test
    public void testBatch() {
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        Party patient1 = this.patientFactory.createPatient(this.customer);
        User clinician1 = this.userFactory.createClinician();
        this.context.setClinician(clinician1);
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal unitCost = BigDecimal.valueOf(5L);
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal unitPriceIncTax = BigDecimal.TEN;
        BigDecimal fixedCost = BigDecimal.ONE;
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal fixedPriceIncTax = BigDecimal.valueOf(2L);
        BigDecimal discount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.valueOf(2L);
        BigDecimal total = BigDecimal.valueOf(22L);
        Product product1 = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedCost, fixedPrice)).unitPrice(unitCost, unitPrice)).build();
        Date batchExpiry1 = DateRules.getTomorrow();
        Date batchExpiry2 = DateRules.getNextDate((Date)batchExpiry1);
        Entity batch1 = this.productFactory.createBatch(product1, "Z-923456789", batchExpiry1);
        Entity batch2 = this.productFactory.createBatch(product1, "Z-123456789", batchExpiry2);
        Product product2 = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedCost, fixedPrice)).unitPrice(unitCost, unitPrice)).build();
        CustomerChargeEditContext editContext = this.createEditContext((LayoutContext)layout);
        TestCustomerChargeActItemEditor editor1 = this.createEditor(charge, item, editContext, (LayoutContext)layout);
        Assert.assertFalse((boolean)editor1.isValid());
        editor1.setQuantity(quantity);
        editor1.setPatient(patient1);
        editor1.setProduct(product1);
        Assert.assertEquals((Object)batch1, (Object)editor1.getBatch());
        Assert.assertFalse((boolean)editor1.isValid());
        EditDialog medicationEditDialog = EchoTestHelper.findEditDialog();
        Assert.assertTrue((boolean)(medicationEditDialog.getEditor() instanceof PatientMedicationActEditor));
        PatientMedicationActEditor medicationEditor1 = (PatientMedicationActEditor)medicationEditDialog.getEditor();
        Assert.assertEquals((Object)batch1, (Object)medicationEditor1.getBatch());
        Assert.assertEquals((Object)batchExpiry1, (Object)medicationEditor1.getExpiryDate());
        medicationEditor1.setBatch(batch2);
        Assert.assertEquals((Object)batch2, (Object)medicationEditor1.getBatch());
        Assert.assertEquals((Object)batchExpiry2, (Object)medicationEditor1.getExpiryDate());
        Assert.assertEquals((Object)batch1, (Object)editor1.getBatch());
        EchoTestHelper.fireDialogButton((PopupDialog)medicationEditDialog, (String)"ok");
        Assert.assertEquals((Object)batch2, (Object)editor1.getBatch());
        EditorTestHelper.assertValid((Modifiable)editor1);
        this.checkSave(charge, editor1);
        charge = (FinancialAct)this.get((IMObject)charge);
        item = (FinancialAct)this.get((IMObject)item);
        Assert.assertNotNull((Object)charge);
        Assert.assertNotNull((Object)item);
        FinancialTestHelper.checkItem((FinancialAct)item, (String)"act.customerAccountInvoiceItem", (Party)patient1, (Product)product1, null, (int)-1, (User)this.user, (User)clinician1, (BigDecimal)BigDecimal.ZERO, (BigDecimal)quantity, (BigDecimal)unitCost, (BigDecimal)unitPriceIncTax, (BigDecimal)fixedCost, (BigDecimal)fixedPriceIncTax, (BigDecimal)discount, (BigDecimal)tax, (BigDecimal)total, (boolean)true);
        this.checkBatch(item, batch2);
        this.checkMedication(item, patient1, product1, this.user, clinician1, batch2, batchExpiry2);
        TestCustomerChargeActItemEditor editor2 = this.createEditor(charge, item, editContext, (LayoutContext)layout);
        editor2.setProduct(product2);
        Assert.assertNull((Object)editor2.getBatch());
        Assert.assertEquals((Object)batchExpiry2, (Object)medicationEditor1.getExpiryDate());
        List medication = editor2.getDispensingEditor().getCurrentActs();
        Assert.assertEquals((long)1L, (long)medication.size());
        PatientMedicationActEditor medicationEditor2 = (PatientMedicationActEditor)editor2.getDispensingEditor().getEditor((IMObject)medication.get(0));
        Assert.assertNotNull((Object)medicationEditor2);
        Assert.assertNull((Object)medicationEditor2.getBatch());
        Assert.assertNull((Object)medicationEditor2.getExpiryDate());
        editor2.setProduct(product1);
        Assert.assertNull((Object)editor2.getBatch());
        editor2.setBatch(batch1);
        Assert.assertEquals((Object)editor2.getBatch(), (Object)batch1);
        Assert.assertEquals((Object)batch1, (Object)medicationEditor2.getBatch());
        Assert.assertEquals((Object)batchExpiry1, (Object)medicationEditor2.getExpiryDate());
    }

    @Test
    public void testDeleteDocumentOnProductChange() {
        Product product1 = this.productFactory.createService();
        Entity template1 = this.addDocumentTemplate(product1, "act.patientDocumentForm");
        Entity template2 = this.addDocumentTemplate(product1, "act.patientDocumentLetter");
        Product product2 = this.productFactory.createService();
        Product product3 = this.productFactory.createService();
        Entity template3 = this.addDocumentTemplate(product3, "act.patientDocumentLetter");
        User clinician = this.userFactory.createClinician();
        this.context.setClinician(clinician);
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        Party patient = this.patientFactory.createPatient(this.customer);
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        CustomerChargeEditContext editContext = this.createEditContext((LayoutContext)layout);
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, editContext, (LayoutContext)layout);
        editor.setPatient(patient);
        editor.setProduct(product1);
        editor.setQuantity(BigDecimal.ONE);
        this.save(charge, editor);
        IMObjectBean bean = this.getBean((IMObject)item);
        Assert.assertEquals((long)2L, (long)bean.getTargets("documents").size());
        DocumentAct document1 = this.checkDocument((Act)item, patient, product1, template1, this.user, clinician, false);
        DocumentAct document2 = this.checkDocument((Act)item, patient, product1, template2, this.user, clinician, false);
        editor.setProduct(product2);
        this.save(charge, editor);
        Assert.assertTrue((boolean)bean.getTargets("documents").isEmpty());
        Assert.assertNull((Object)this.get((IMObject)document1));
        Assert.assertNull((Object)this.get((IMObject)document2));
        editor.setProduct(product3);
        this.save(charge, editor);
        Assert.assertEquals((long)1L, (long)bean.getTargets("documents").size());
        this.checkDocument((Act)item, patient, product3, template3, this.user, clinician, false);
    }

    @Test
    public void testInactiveDocumentTemplateDoesntCreateDocument() {
        Party patient = this.patientFactory.createPatient(this.customer);
        Product product = this.productFactory.createService();
        Entity template1 = this.addDocumentTemplate(product, "act.patientDocumentForm");
        Entity template2 = this.addDocumentTemplate(product, "act.patientDocumentForm");
        template2.setActive(false);
        this.save((IMObject)template2);
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        CustomerChargeEditContext editContext = this.createEditContext((LayoutContext)layout);
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, editContext, (LayoutContext)layout);
        editor.setPatient(patient);
        editor.setProduct(product);
        EditorTestHelper.assertValid((Modifiable)editor);
        this.checkSave(charge, editor);
        Assert.assertEquals((long)1L, (long)this.getBean((IMObject)item).getTargets("documents", Act.class).size());
        this.checkDocument((Act)item, patient, product, template1, this.user, null, false);
    }

    @Test
    public void testZeroQuantity() {
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal unitCost = BigDecimal.valueOf(5L);
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal unitPriceIncTax = BigDecimal.TEN;
        BigDecimal fixedCost = BigDecimal.valueOf(1L);
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal fixedPriceIncTax = new BigDecimal(2);
        User clinician = this.userFactory.createClinician();
        Entity discount = (Entity)this.productFactory.newDiscount().percentage(10).discountFixedPrice(true).build();
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedCost, fixedPrice)).unitPrice(unitCost, unitPrice)).build();
        Party patient = this.patientFactory.createPatient(this.customer);
        this.customerFactory.updateCustomer(this.customer).addDiscounts(new Entity[]{discount}).build();
        this.productFactory.updateProduct(product).addDiscounts(new Entity[]{discount}).build();
        this.context.setClinician(clinician);
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        CustomerChargeEditContext context = this.createEditContext((LayoutContext)layout);
        context.setEditorQueue(null);
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, context, (LayoutContext)layout);
        editor.setPatient(patient);
        editor.setProduct(product);
        editor.setQuantity(quantity);
        this.checkSave(charge, editor);
        item = (FinancialAct)this.get((IMObject)item);
        BigDecimal discount1 = new BigDecimal("2.20");
        BigDecimal tax1 = new BigDecimal("1.80");
        BigDecimal total1 = new BigDecimal("19.80");
        FinancialTestHelper.checkItem((FinancialAct)item, (String)item.getArchetype(), (Party)patient, (Product)product, null, (int)-1, (User)this.user, (User)clinician, (BigDecimal)BigDecimal.ZERO, (BigDecimal)quantity, (BigDecimal)unitCost, (BigDecimal)unitPriceIncTax, (BigDecimal)fixedCost, (BigDecimal)fixedPriceIncTax, (BigDecimal)discount1, (BigDecimal)tax1, (BigDecimal)total1, (boolean)true);
        editor.setQuantity(BigDecimal.ZERO);
        this.checkSave(charge, editor);
        item = (FinancialAct)this.get((IMObject)item);
        FinancialTestHelper.checkItem((FinancialAct)item, (String)item.getArchetype(), (Party)patient, (Product)product, null, (int)-1, (User)this.user, (User)clinician, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)unitCost, (BigDecimal)unitPriceIncTax, (BigDecimal)fixedCost, (BigDecimal)fixedPriceIncTax, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (boolean)true);
    }

    @Test
    public void testInvoiceRestrictedDrug() {
        Party patient = this.patientFactory.createPatient(this.customer);
        Charge invoice1 = this.createInvoice(patient);
        Charge invoice2 = this.createInvoice(patient);
        this.checkPreventDispenseRestrictedDrugsOTC(invoice1.getCharge(), invoice1.getItem(), false);
        this.checkDispenseRestrictedDrugs(invoice2.getCharge(), invoice2.getItem());
    }

    @Test
    public void testCreditRestrictedDrug() {
        Party patient = this.patientFactory.createPatient(this.customer);
        Charge credit1 = this.createCredit(patient);
        Charge credit2 = this.createCredit(patient);
        this.checkPreventDispenseRestrictedDrugsOTC(credit1.getCharge(), credit1.getItem(), false);
        this.checkDispenseRestrictedDrugs(credit2.getCharge(), credit2.getItem());
    }

    @Test
    public void testSellRestrictedDrugOverTheCounter() {
        Charge counter1 = this.createCounterSale();
        this.checkPreventDispenseRestrictedDrugsOTC(counter1.getCharge(), counter1.getItem(), true);
        Charge counter2 = this.createCounterSale();
        this.checkDispenseRestrictedDrugs(counter2.getCharge(), counter1.getItem());
    }

    @Test
    public void testChangePatientRecreatesAlert() {
        Party patient1 = this.patientFactory.createPatient(this.customer);
        Party patient2 = this.patientFactory.createPatient(this.customer);
        Entity alertType = (Entity)this.patientFactory.newAlertType().interactive(true).build();
        Product product = (Product)((TestServiceProductBuilder)this.productFactory.newService().addAlertTypes(new Entity[]{alertType})).build();
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        CustomerChargeEditContext editContext = this.createEditContext((LayoutContext)layout);
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, editContext, (LayoutContext)layout);
        editor.setPatient(patient1);
        editor.setProduct(product);
        Assert.assertFalse((boolean)editor.isValid());
        CustomerChargeTestHelper.checkSavePopup(editor.getEditorQueue(), "act.patientAlert", false);
        EditorTestHelper.assertValid((Modifiable)editor);
        this.checkSave(charge, editor);
        Act alert1 = this.checkAlert((Act)item, patient1, product, alertType, this.user, null);
        editor.setPatient(patient2);
        this.checkSave(charge, editor);
        this.checkAlert((Act)item, patient2, product, alertType, this.user, null);
        Assert.assertNull((Object)this.get((IMObject)alert1));
    }

    @Test
    public void testInactiveAlertTypeDoesNotCreateAlert() {
        Party patient = this.patientFactory.createPatient(this.customer);
        Entity alertType1 = this.patientFactory.createAlertType();
        Entity alertType2 = (Entity)((TestPatientAlertTypeBuilder)this.patientFactory.newAlertType().active(false)).build();
        Product product = (Product)((TestServiceProductBuilder)this.productFactory.newService().addAlertTypes(new Entity[]{alertType1, alertType2})).build();
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        CustomerChargeEditContext editContext = this.createEditContext((LayoutContext)layout);
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, editContext, (LayoutContext)layout);
        editor.setPatient(patient);
        editor.setProduct(product);
        EditorTestHelper.assertValid((Modifiable)editor);
        this.checkSave(charge, editor);
        Assert.assertEquals((long)1L, (long)this.getBean((IMObject)item).getTargets("alerts", Act.class).size());
        this.checkAlert((Act)item, patient, product, alertType1, this.user, null);
    }

    @Test
    public void testProductTask() {
        Party patient1 = this.patientFactory.createPatient(this.customer);
        Party patient2 = this.patientFactory.createPatient(this.customer);
        Entity taskType = this.schedulingFactory.createTaskType();
        Entity worklist = (Entity)this.schedulingFactory.newWorkList().taskTypes(new Entity[]{taskType}).build();
        Product product = (Product)((TestServiceProductBuilder)this.productFactory.newService().newProductTask().taskType(taskType).workList(worklist).start(1, DateUnits.DAYS).interactive(true).add()).build();
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        CustomerChargeEditContext editContext = this.createEditContext((LayoutContext)layout);
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, editContext, (LayoutContext)layout);
        editor.setPatient(patient1);
        editor.setProduct(product);
        Assert.assertFalse((boolean)editor.isValid());
        CustomerChargeTestHelper.checkSavePopup(editor.getEditorQueue(), "act.customerTask", false);
        EditorTestHelper.assertValid((Modifiable)editor);
        this.checkSave(charge, editor);
        List tasks1 = this.getBean((IMObject)item).getTargets("tasks", Act.class);
        Assert.assertEquals((long)1L, (long)tasks1.size());
        Act task1 = (Act)tasks1.get(0);
        Date startTime = DateUtils.truncate((Date)item.getActivityStartTime(), (int)12);
        TestTaskVerifier verifier = new TestTaskVerifier((ArchetypeService)this.getArchetypeService());
        ((TestTaskVerifier)verifier.startTime(DateRules.getDate((Date)startTime, (int)1, (DateUnits)DateUnits.DAYS))).worklist(worklist).taskType(taskType).customer(this.customer).patient(patient1).verify((IMObject)task1);
        editor.setPatient(patient2);
        CustomerChargeTestHelper.checkSavePopup(editor.getEditorQueue(), "act.customerTask", false);
        EditorTestHelper.assertValid((Modifiable)editor);
        this.checkSave(charge, editor);
        Assert.assertNull((Object)this.get((IMObject)task1));
        List tasks2 = this.getBean((IMObject)item).getTargets("tasks", Act.class);
        Assert.assertEquals((long)1L, (long)tasks2.size());
        Act task2 = (Act)tasks2.get(0);
        verifier.patient(patient2).verify((IMObject)task2);
        editor.setProduct(this.productFactory.createService());
        EditorTestHelper.assertValid((Modifiable)editor);
        this.checkSave(charge, editor);
        Assert.assertNull((Object)this.get((IMObject)task2));
        List tasks3 = this.getBean((IMObject)item).getTargets("tasks", Act.class);
        Assert.assertEquals((long)0L, (long)tasks3.size());
    }

    @Test
    public void testInactiveTaskTypeDoesNotCreateType() {
        Party patient = this.patientFactory.createPatient(this.customer);
        Entity taskType1 = this.schedulingFactory.createTaskType();
        Entity worklist1 = (Entity)this.schedulingFactory.newWorkList().taskTypes(new Entity[]{taskType1}).build();
        Entity taskType2 = (Entity)((TestTaskTypeBuilder)this.schedulingFactory.newTaskType().active(false)).build();
        Entity taskType3 = this.schedulingFactory.createTaskType();
        Entity worklist3 = (Entity)((TestWorkListBuilder)this.schedulingFactory.newWorkList().taskTypes(new Entity[]{taskType3}).active(false)).build();
        Product product = (Product)((TestServiceProductBuilder)((TestServiceProductBuilder)((TestServiceProductBuilder)this.productFactory.newService().newProductTask().taskType(taskType1).workList(worklist1).interactive(false).start(1, DateUnits.DAYS).add()).newProductTask().taskType(taskType2).start(0, DateUnits.DAYS).add()).newProductTask().taskType(taskType3).workList(worklist3).add()).build();
        Charge invoice = this.createInvoice();
        FinancialAct charge = invoice.getCharge();
        FinancialAct item = invoice.getItem();
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        CustomerChargeEditContext editContext = this.createEditContext((LayoutContext)layout);
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, editContext, (LayoutContext)layout);
        editor.setPatient(patient);
        editor.setProduct(product);
        EditorTestHelper.assertValid((Modifiable)editor);
        this.checkSave(charge, editor);
        List tasks = this.getBean((IMObject)item).getTargets("tasks", Act.class);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Act task = (Act)tasks.get(0);
        Date startTime = DateUtils.truncate((Date)item.getActivityStartTime(), (int)12);
        TestTaskVerifier verifier = new TestTaskVerifier((ArchetypeService)this.getArchetypeService());
        ((TestTaskVerifier)verifier.startTime(DateRules.getDate((Date)startTime, (int)1, (DateUnits)DateUnits.DAYS))).taskType(taskType1).customer(this.customer).patient(patient).worklist(worklist1).verify((IMObject)task);
    }

    private void checkPreventDispenseRestrictedDrugsOTC(FinancialAct charge, FinancialAct item, boolean expectRestricted) {
        this.practiceFactory.updatePractice(this.getPractice()).sellRestrictedDrugsOTC(false).build();
        Product restricted = (Product)this.productFactory.newMedication().drugSchedule(true).build();
        Product unrestricted = (Product)this.productFactory.newMedication().drugSchedule(false).build();
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        CustomerChargeEditContext context1 = this.createEditContext((LayoutContext)layout);
        context1.setEditorQueue(null);
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, context1, (LayoutContext)layout);
        editor.setProduct(restricted);
        if (expectRestricted) {
            DefaultValidator validator = new DefaultValidator();
            Assert.assertFalse((boolean)editor.validate((Validator)validator));
            List errors = validator.getErrors((Modifiable)editor);
            Assert.assertEquals((long)1L, (long)errors.size());
            Assert.assertEquals((Object)(restricted.getName() + " cannot be sold over the counter.\nIt must be invoiced instead."), (Object)((ValidatorError)errors.get(0)).getMessage());
        } else {
            EditorTestHelper.assertValid((Modifiable)editor);
        }
        editor.setProduct(unrestricted);
        EditorTestHelper.assertValid((Modifiable)editor);
    }

    private void checkDispenseRestrictedDrugs(FinancialAct charge, FinancialAct item) {
        this.practiceFactory.updatePractice(this.getPractice()).sellRestrictedDrugsOTC(true).build();
        Product restricted = (Product)this.productFactory.newMedication().drugSchedule(true).build();
        Product unrestricted = (Product)this.productFactory.newMedication().drugSchedule(false).build();
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        CustomerChargeEditContext context = this.createEditContext((LayoutContext)layout);
        context.setEditorQueue(null);
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, context, (LayoutContext)layout);
        editor.setProduct(restricted);
        EditorTestHelper.assertValid((Modifiable)editor);
        editor.setProduct(unrestricted);
        EditorTestHelper.assertValid((Modifiable)editor);
    }

    private Entity addReminderType(String name, Product product, String ... species) {
        Entity reminderType = (Entity)((TestReminderTypeBuilder)this.reminderFactory.newReminderType().name(name)).addSpecies(species).defaultInterval(1, DateUnits.MONTHS).cancelInterval(2, DateUnits.MONTHS).build();
        this.productFactory.updateProduct(product).newProductReminder().reminderType(reminderType).add().build();
        return reminderType;
    }

    private void checkStock(Product product, BigDecimal expected) {
        StockRules rules = new StockRules(this.getArchetypeService());
        Party stockLocation = this.context.getStockLocation();
        Assert.assertNotNull((Object)stockLocation);
        BigDecimal stock = rules.getStock(product.getObjectReference(), stockLocation.getObjectReference());
        this.checkEquals(expected, stock);
    }

    private CustomerChargeEditContext createEditContext(LayoutContext layout) {
        return new CustomerChargeEditContext(this.customer, layout.getContext().getLocation(), layout);
    }

    private TestCustomerChargeActItemEditor createEditor(FinancialAct charge, FinancialAct item, LayoutContext context) {
        return this.createEditor(charge, item, this.createEditContext(context), context);
    }

    private TestCustomerChargeActItemEditor createEditor(FinancialAct charge, FinancialAct item, CustomerChargeEditContext context, LayoutContext layoutContext) {
        TestCustomerChargeActItemEditor editor = new TestCustomerChargeActItemEditor(item, (Act)charge, context, layoutContext);
        editor.getComponent();
        return editor;
    }

    private void checkInvoiceItem(String productShortName) {
        Charge invoice = this.createInvoice();
        this.checkItem(invoice.getCharge(), invoice.getItem(), productShortName);
    }

    private void checkCounterSaleItem(String productShortName) {
        Charge counter = this.createCounterSale();
        this.checkItem(counter.getCharge(), counter.getItem(), productShortName);
    }

    private void checkCreditItem(String productShortName) {
        Charge credit = this.createCredit();
        this.checkItem(credit.getCharge(), credit.getItem(), productShortName);
    }

    private void checkItem(FinancialAct charge, FinancialAct item, String productArchetype) {
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        Party patient1 = this.patientFactory.createPatient(this.customer);
        Party patient2 = this.patientFactory.createPatient(this.customer);
        User user2 = this.userFactory.createUser();
        User clinician1 = this.userFactory.createClinician();
        User clinician2 = this.userFactory.createClinician();
        BigDecimal quantity1 = BigDecimal.valueOf(2L);
        BigDecimal unitCost1 = BigDecimal.valueOf(5L);
        BigDecimal unitPrice1 = new BigDecimal("9.09");
        BigDecimal unitPrice1IncTax = BigDecimal.TEN;
        BigDecimal fixedCost1 = BigDecimal.ONE;
        BigDecimal fixedPrice1 = new BigDecimal("1.82");
        BigDecimal fixedPrice1IncTax = BigDecimal.valueOf(2L);
        BigDecimal discount1 = BigDecimal.ZERO;
        BigDecimal tax1 = BigDecimal.valueOf(2L);
        BigDecimal total1 = BigDecimal.valueOf(22L);
        Entity productType = this.productFactory.createProductType();
        Entity batch1 = null;
        Date batchExpiry1 = DateRules.getTomorrow();
        Date batchExpiry2 = DateRules.getNextDate((Date)batchExpiry1);
        Entity investigationType = this.laboratoryFactory.createInvestigationType();
        Entity alertType = (Entity)this.patientFactory.newAlertType().interactive(true).build();
        Entity taskType = this.schedulingFactory.createTaskType();
        Entity worklist = (Entity)this.schedulingFactory.newWorkList().taskTypes(new Entity[]{taskType}).build();
        Product product1 = (Product)this.productFactory.newProduct(productArchetype).fixedPrice(fixedCost1, fixedPrice1).unitPrice(unitCost1, unitPrice1).addTests(new Entity[]{this.laboratoryFactory.createTest(investigationType)}).addAlertTypes(new Entity[]{alertType}).newProductTask().taskType(taskType).workList(worklist).start(0, DateUnits.DAYS).interactive(true).add().build();
        if (product1.isA(new String[]{"product.medication", "product.merchandise"})) {
            batch1 = this.productFactory.createBatch(product1, "Z-923456789", batchExpiry1);
            this.productFactory.createBatch(product1, "Z-123456789", batchExpiry2);
        }
        Entity reminderType = this.addReminder(product1);
        Entity template1 = this.addDocumentTemplate(product1, "act.patientDocumentForm");
        Entity template2 = this.addDocumentTemplate(product1, "act.patientDocumentLetter");
        BigDecimal quantity2 = BigDecimal.ONE;
        BigDecimal unitCost2 = BigDecimal.valueOf(5L);
        BigDecimal unitPrice2 = BigDecimal.valueOf(5.05);
        BigDecimal fixedCost2 = BigDecimal.valueOf(0.5);
        BigDecimal fixedPrice2 = BigDecimal.valueOf(5.05);
        BigDecimal discount2 = BigDecimal.ZERO;
        BigDecimal ratio = BigDecimal.valueOf(2L);
        BigDecimal tax2 = BigDecimal.valueOf(2.036);
        BigDecimal roundedPrice = BigDecimal.valueOf(11.2);
        BigDecimal total2 = BigDecimal.valueOf(22.4);
        Product product2 = (Product)this.productFactory.newProduct(productArchetype).type(productType).fixedPrice(fixedCost2, fixedPrice2).unitPrice(unitCost2, unitPrice2).build();
        this.practiceFactory.updateLocation(this.context.getLocation()).addServiceRatio(productType, ratio).build();
        layout.getContext().setClinician(clinician1);
        CustomerChargeEditContext editContext = this.createEditContext((LayoutContext)layout);
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, editContext, (LayoutContext)layout);
        Assert.assertFalse((boolean)editor.isValid());
        editor.setQuantity(quantity1);
        if (!item.isA("act.customerAccountCounterItem")) {
            editor.setPatient(patient1);
        }
        editor.setProduct(product1);
        EditorQueue queue = editContext.getEditorQueue();
        if (item.isA("act.customerAccountInvoiceItem")) {
            if (product1.isA("product.medication")) {
                Assert.assertFalse((boolean)editor.isValid());
                CustomerChargeTestHelper.checkSavePopup(queue, "act.patientMedication", false);
            }
            Assert.assertFalse((boolean)editor.isValid());
            CustomerChargeTestHelper.checkSavePopup(queue, "act.patientInvestigation", false);
            Assert.assertFalse((boolean)editor.isValid());
            CustomerChargeTestHelper.checkSavePopup(queue, "act.patientReminder", false);
            Assert.assertFalse((boolean)editor.isValid());
            CustomerChargeTestHelper.checkSavePopup(queue, "act.patientAlert", false);
            Assert.assertFalse((boolean)editor.isValid());
            CustomerChargeTestHelper.checkSavePopup(queue, "act.customerTask", false);
        }
        EditorTestHelper.assertValid((Modifiable)editor);
        this.checkSave(charge, editor);
        charge = (FinancialAct)this.get((IMObject)charge);
        item = (FinancialAct)this.get((IMObject)item);
        Assert.assertNotNull((Object)charge);
        Assert.assertNotNull((Object)item);
        FinancialTestHelper.checkItem((FinancialAct)item, (String)item.getArchetype(), (Party)patient1, (Product)product1, null, (int)-1, (User)this.user, (User)clinician1, (BigDecimal)BigDecimal.ZERO, (BigDecimal)quantity1, (BigDecimal)unitCost1, (BigDecimal)unitPrice1IncTax, (BigDecimal)fixedCost1, (BigDecimal)fixedPrice1IncTax, (BigDecimal)discount1, (BigDecimal)tax1, (BigDecimal)total1, (boolean)true);
        IMObjectBean itemBean = this.getBean((IMObject)item);
        if (item.isA("act.customerAccountInvoiceItem")) {
            this.checkBatch(item, batch1);
            if (product1.isA("product.medication")) {
                this.checkMedication(item, patient1, product1, this.user, clinician1, batch1, batchExpiry1);
            } else {
                Assert.assertTrue((boolean)itemBean.getTargets("dispensing").isEmpty());
            }
            Assert.assertEquals((long)1L, (long)itemBean.getTargets("investigations").size());
            Assert.assertEquals((long)1L, (long)itemBean.getTargets("reminders").size());
            Assert.assertEquals((long)2L, (long)itemBean.getTargets("documents").size());
            Assert.assertEquals((long)1L, (long)itemBean.getTargets("alerts").size());
            Assert.assertNotNull((Object)investigationType);
            this.checkInvestigation((Act)item, patient1, investigationType, this.user, clinician1);
            this.checkReminder((Act)item, patient1, product1, reminderType, this.user, clinician1);
            this.checkDocument((Act)item, patient1, product1, template1, this.user, clinician1, false);
            this.checkDocument((Act)item, patient1, product1, template2, this.user, clinician1, false);
            this.checkAlert((Act)item, patient1, product1, alertType, this.user, clinician1);
        } else {
            Assert.assertFalse((boolean)itemBean.hasNode("investigations"));
            Assert.assertFalse((boolean)itemBean.hasNode("reminders"));
            Assert.assertFalse((boolean)itemBean.hasNode("documents"));
            Assert.assertFalse((boolean)itemBean.hasNode("alerts"));
        }
        this.authenticationContext.setUser(user2);
        if (itemBean.hasNode("patient")) {
            editor.setPatient(patient2);
        }
        if (item.isA("act.customerAccountInvoiceItem")) {
            CustomerChargeTestHelper.checkSavePopup(queue, "act.patientInvestigation", false);
            CustomerChargeTestHelper.checkSavePopup(queue, "act.patientReminder", false);
            CustomerChargeTestHelper.checkSavePopup(queue, "act.patientAlert", false);
        }
        editor.setProduct(product2);
        editor.setQuantity(quantity2);
        editor.setDiscount(discount2);
        if (itemBean.hasNode("clinician")) {
            editor.setClinician(clinician2);
        }
        Assert.assertNull((Object)queue.getCurrent());
        EditorTestHelper.assertValid((Modifiable)editor);
        this.checkSave(charge, editor);
        item = (FinancialAct)this.get((IMObject)item);
        Assert.assertNotNull((Object)item);
        FinancialTestHelper.checkItem((FinancialAct)item, (String)item.getArchetype(), (Party)patient2, (Product)product2, null, (int)-1, (User)this.user, (User)clinician2, (BigDecimal)BigDecimal.ZERO, (BigDecimal)quantity2, (BigDecimal)unitCost2, (BigDecimal)roundedPrice, (BigDecimal)fixedCost2, (BigDecimal)roundedPrice, (BigDecimal)discount2, (BigDecimal)tax2, (BigDecimal)total2, (boolean)true);
        Assert.assertEquals((Object)user2.getObjectReference(), (Object)item.getUpdatedBy());
        itemBean = this.getBean((IMObject)item);
        if (itemBean.isA(new String[]{"act.customerAccountInvoiceItem"})) {
            if (product2.isA("product.medication")) {
                Act medication = this.checkMedication(item, patient2, product2, this.user, clinician2, null, null);
                Assert.assertEquals((Object)user2.getObjectReference(), (Object)medication.getUpdatedBy());
            } else {
                Assert.assertTrue((boolean)itemBean.getTargets("dispensing").isEmpty());
            }
            Assert.assertTrue((boolean)itemBean.getTargets("investigations").isEmpty());
            Assert.assertTrue((boolean)itemBean.getTargets("reminders").isEmpty());
            Assert.assertTrue((boolean)itemBean.getTargets("documents").isEmpty());
            Assert.assertTrue((boolean)itemBean.getTargets("alerts").isEmpty());
        } else {
            Assert.assertFalse((boolean)itemBean.hasNode("dispensing"));
            Assert.assertFalse((boolean)itemBean.hasNode("investigations"));
            Assert.assertFalse((boolean)itemBean.hasNode("reminders"));
            Assert.assertFalse((boolean)itemBean.hasNode("documents"));
            Assert.assertFalse((boolean)itemBean.hasNode("alerts"));
        }
        if (itemBean.hasNode("clinician")) {
            editor.setClinician(null);
            EditorTestHelper.assertValid((Modifiable)editor);
            this.checkSave(charge, editor);
            item = (FinancialAct)this.get((IMObject)item);
            Assert.assertNotNull((Object)item);
            FinancialTestHelper.checkItem((FinancialAct)item, (String)item.getArchetype(), (Party)patient2, (Product)product2, null, (int)-1, (User)this.user, null, (BigDecimal)BigDecimal.ZERO, (BigDecimal)quantity2, (BigDecimal)unitCost2, (BigDecimal)roundedPrice, (BigDecimal)fixedCost2, (BigDecimal)roundedPrice, (BigDecimal)discount2, (BigDecimal)tax2, (BigDecimal)total2, (boolean)true);
            Assert.assertEquals((Object)user2.getObjectReference(), (Object)item.getUpdatedBy());
        }
        editor.setProduct(null);
        Assert.assertFalse((boolean)editor.isValid());
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    private void checkBatch(FinancialAct item, Entity batch) {
        IMObjectBean bean = this.getBean((IMObject)item);
        if (batch == null) {
            Assert.assertNull((Object)bean.getTargetRef("batch"));
        } else {
            Assert.assertEquals((Object)batch.getObjectReference(), (Object)bean.getTargetRef("batch"));
        }
    }

    private void checkItemWithTemplate(Charge charge) {
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        context.getContext().setPractice(this.getPractice());
        Party patient = this.patientFactory.createPatient(this.customer);
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal unitCost = BigDecimal.valueOf(5L);
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal fixedCost = BigDecimal.valueOf(1L);
        BigDecimal fixedPrice = new BigDecimal("1.82");
        Product product = (Product)((TestTemplateProductBuilder)((TestTemplateProductBuilder)this.productFactory.newTemplate().fixedPrice(fixedCost, fixedPrice)).unitPrice(unitCost, unitPrice)).build();
        User clinician = this.userFactory.createClinician();
        context.getContext().setClinician(clinician);
        FinancialAct item = charge.getItem();
        DefaultCustomerChargeActItemEditor editor = new DefaultCustomerChargeActItemEditor(item, (Act)charge.getCharge(), this.createEditContext((LayoutContext)context), (LayoutContext)context);
        editor.getComponent();
        Assert.assertFalse((boolean)editor.isValid());
        editor.setQuantity(quantity);
        if (!item.isA("act.customerAccountCounterItem")) {
            editor.setPatient(patient);
        }
        editor.setProduct(product);
        EditorTestHelper.assertValid((Modifiable)editor);
        try {
            this.save(charge.getCharge(), (CustomerChargeActItemEditor)editor);
            Assert.fail((String)"Expected save to fail");
        }
        catch (IllegalStateException expected) {
            Assert.assertEquals((Object)("Cannot save with product template: " + product.getName()), (Object)expected.getMessage());
        }
        FinancialTestHelper.checkItem((FinancialAct)item, (String)item.getArchetype(), (Party)patient, (Product)product, null, (int)-1, null, (User)clinician, (BigDecimal)BigDecimal.ZERO, (BigDecimal)quantity, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (boolean)true);
        if (item.isA("act.customerAccountInvoiceItem")) {
            IMObjectBean itemBean = this.getBean((IMObject)item);
            Assert.assertTrue((boolean)itemBean.getTargets("dispensing").isEmpty());
        }
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    private void checkDiscounts(FinancialAct charge, FinancialAct item, boolean negativeQuantity) {
        BigDecimal quantity = negativeQuantity ? BigDecimal.valueOf(-2L) : BigDecimal.valueOf(2L);
        BigDecimal unitCost = BigDecimal.valueOf(5L);
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal unitPriceIncTax = BigDecimal.TEN;
        BigDecimal fixedCost = BigDecimal.valueOf(1L);
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal fixedPriceIncTax = new BigDecimal(2);
        User clinician = this.userFactory.createClinician();
        Entity discount = (Entity)this.productFactory.newDiscount().percentage(10).discountFixedPrice(true).build();
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedCost, fixedPrice)).unitPrice(unitCost, unitPrice)).addDiscounts(new Entity[]{discount})).build();
        Party patient = this.patientFactory.createPatient(this.customer);
        this.customerFactory.updateCustomer(this.customer).addDiscounts(new Entity[]{discount}).build();
        this.context.setClinician(clinician);
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        CustomerChargeEditContext context = this.createEditContext((LayoutContext)layout);
        context.setEditorQueue(null);
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, context, (LayoutContext)layout);
        Assert.assertFalse((boolean)editor.isValid());
        if (!item.isA("act.customerAccountCounterItem")) {
            editor.setPatient(patient);
        }
        editor.setProduct(product);
        editor.setQuantity(quantity);
        EditorTestHelper.assertValid((Modifiable)editor);
        this.checkSave(charge, editor);
        item = (FinancialAct)this.get((IMObject)item);
        BigDecimal discount1 = new BigDecimal("2.20");
        BigDecimal tax1 = new BigDecimal("1.80");
        BigDecimal total1 = new BigDecimal("19.80");
        if (negativeQuantity) {
            tax1 = tax1.negate();
            total1 = total1.negate();
        }
        FinancialTestHelper.checkItem((FinancialAct)item, (String)item.getArchetype(), (Party)patient, (Product)product, null, (int)-1, (User)this.user, (User)clinician, (BigDecimal)BigDecimal.ZERO, (BigDecimal)quantity, (BigDecimal)unitCost, (BigDecimal)unitPriceIncTax, (BigDecimal)fixedCost, (BigDecimal)fixedPriceIncTax, (BigDecimal)discount1, (BigDecimal)tax1, (BigDecimal)total1, (boolean)true);
        editor.setDiscount(BigDecimal.ZERO);
        this.checkSave(charge, editor);
        item = (FinancialAct)this.get((IMObject)item);
        BigDecimal discount2 = BigDecimal.ZERO;
        BigDecimal tax2 = new BigDecimal("2.00");
        BigDecimal total2 = new BigDecimal("22.00");
        if (negativeQuantity) {
            tax2 = tax2.negate();
            total2 = total2.negate();
        }
        FinancialTestHelper.checkItem((FinancialAct)item, (String)item.getArchetype(), (Party)patient, (Product)product, null, (int)-1, (User)this.user, (User)clinician, (BigDecimal)BigDecimal.ZERO, (BigDecimal)quantity, (BigDecimal)unitCost, (BigDecimal)unitPriceIncTax, (BigDecimal)fixedCost, (BigDecimal)fixedPriceIncTax, (BigDecimal)discount2, (BigDecimal)tax2, (BigDecimal)total2, (boolean)true);
    }

    private void checkProductDose(FinancialAct charge, FinancialAct item) {
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        Party patient = this.patientFactory.createPatient(this.customer);
        PatientTestHelper.createWeight((Party)patient, (Date)new Date(), (BigDecimal)new BigDecimal("4.2"), (WeightUnits)WeightUnits.KILOGRAMS);
        User clinician = this.userFactory.createClinician();
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal unitCost = BigDecimal.valueOf(5L);
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal unitPriceIncTax = BigDecimal.TEN;
        BigDecimal fixedCost = BigDecimal.valueOf(1L);
        BigDecimal fixedPrice = new BigDecimal("1.82");
        BigDecimal fixedPriceIncTax = BigDecimal.valueOf(2L);
        BigDecimal discount = BigDecimal.ZERO;
        BigDecimal doseQuantity = new BigDecimal("4.2");
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedCost, fixedPrice)).unitPrice(unitCost, unitPrice)).build();
        this.productFactory.updateMedication(product).concentration(1).newDose().weightRange(0, 10).rate(1).quantity(1).add().build();
        CustomerChargeEditContext editContext = this.createEditContext((LayoutContext)layout);
        editContext.setEditorQueue(null);
        TestCustomerChargeActItemEditor editor = this.createEditor(charge, item, editContext, (LayoutContext)layout);
        Assert.assertFalse((boolean)editor.isValid());
        Assert.assertFalse((boolean)editor.isDefaultQuantity());
        editor.setQuantity(quantity);
        Assert.assertFalse((boolean)editor.isDefaultQuantity());
        editor.setPatient(patient);
        editor.setClinician(clinician);
        editor.setProduct(product);
        this.checkEquals(doseQuantity, editor.getQuantity());
        Assert.assertTrue((boolean)editor.isDefaultQuantity());
        EditorTestHelper.assertValid((Modifiable)editor);
        this.checkSave(charge, editor);
        charge = (FinancialAct)this.get((IMObject)charge);
        item = (FinancialAct)this.get((IMObject)item);
        Assert.assertNotNull((Object)charge);
        Assert.assertNotNull((Object)item);
        BigDecimal tax = new BigDecimal("4.0");
        BigDecimal total = new BigDecimal("44.00");
        FinancialTestHelper.checkItem((FinancialAct)item, (String)item.getArchetype(), (Party)patient, (Product)product, null, (int)-1, (User)this.user, (User)clinician, (BigDecimal)BigDecimal.ZERO, (BigDecimal)doseQuantity, (BigDecimal)unitCost, (BigDecimal)unitPriceIncTax, (BigDecimal)fixedCost, (BigDecimal)fixedPriceIncTax, (BigDecimal)discount, (BigDecimal)tax, (BigDecimal)total, (boolean)true);
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    private void checkSave(FinancialAct charge, CustomerChargeActItemEditor editor) {
        boolean result = this.save(charge, editor);
        Assert.assertTrue((boolean)result);
    }

    private boolean save(FinancialAct charge, CustomerChargeActItemEditor editor) {
        TransactionTemplate template = new TransactionTemplate(ServiceHelper.getTransactionManager());
        return (Boolean)template.execute(status -> {
            PatientHistoryChanges changes = new PatientHistoryChanges(null, (ArchetypeService)this.getArchetypeService());
            ChargeSaveContext context1 = editor.getSaveContext();
            context1.setHistoryChanges(changes);
            editor.getEditContext().getInvestigations().save();
            boolean saved = SaveHelper.save((IMObject)charge);
            editor.save();
            if (saved) {
                context1.save();
            }
            context1.setHistoryChanges(null);
            return saved;
        });
    }

    private Charge createInvoice() {
        return this.createInvoice(null);
    }

    private Charge createInvoice(Party patient) {
        return this.createCharge((TestCustomerChargeBuilder<?, ?>)this.accountFactory.newInvoice(), patient);
    }

    private Charge createCounterSale() {
        return this.createCharge((TestCustomerChargeBuilder<?, ?>)this.accountFactory.newCounterSale(), null);
    }

    private Charge createCredit() {
        return this.createCredit(null);
    }

    private Charge createCredit(Party patient) {
        return this.createCharge((TestCustomerChargeBuilder<?, ?>)this.accountFactory.newCredit(), patient);
    }

    private Charge createCharge(TestCustomerChargeBuilder<?, ?> builder, Party patient) {
        FinancialAct charge = (FinancialAct)((TestCustomerChargeBuilder)((TestCustomerChargeBuilder)builder.customer(this.customer)).status("IN_PROGRESS")).item().patient(patient).add().build(false);
        return new Charge(charge, (FinancialAct)builder.getItems().get(0));
    }

    private static class Charge {
        private final FinancialAct charge;
        private final FinancialAct item;

        public Charge(FinancialAct charge, FinancialAct item) {
            this.charge = charge;
            this.item = item;
        }

        public FinancialAct getCharge() {
            return this.charge;
        }

        public FinancialAct getItem() {
            return this.item;
        }
    }

    private static class TestCustomerChargeActItemEditor
    extends CustomerChargeActItemEditor {
        TestCustomerChargeActItemEditor(FinancialAct act, Act parent, CustomerChargeEditContext context, LayoutContext layoutContext) {
            super(act, parent, context, layoutContext);
        }

        public ActRelationshipCollectionEditor getDispensingEditor() {
            return super.getDispensingEditor();
        }
    }
}

