/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.WindowPane;
import org.apache.commons.lang3.mutable.MutableObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.reminder.AccountReminderRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerChargeBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.account.AccountActActions;
import org.openvpms.web.workspace.customer.charge.ChargePoster;
import org.springframework.beans.factory.annotation.Autowired;

public class ChargePosterTestCase
extends AbstractAppTest {
    private final List<String> errors = new ArrayList<String>();
    @Autowired
    private CustomerAccountRules accountRules;
    @Autowired
    private AccountReminderRules reminderRules;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    private Context context;

    @Before
    public void setUp() {
        super.setUp();
        this.context = new LocalContext();
        this.context.setPractice(this.practiceFactory.getPractice());
        this.context.setLocation(this.practiceFactory.createLocation());
        this.initErrorHandler(this.errors);
    }

    @Test
    public void testPost() {
        this.checkPost((TestCustomerChargeBuilder<?, ?>)this.accountFactory.newInvoice(10, "IN_PROGRESS"));
        this.checkPost((TestCustomerChargeBuilder<?, ?>)this.accountFactory.newCredit(10, "IN_PROGRESS"));
        this.checkPost((TestCustomerChargeBuilder<?, ?>)this.accountFactory.newCounterSale(10, "IN_PROGRESS"));
    }

    @Test
    public void testPostAlreadyPosted() {
        FinancialAct charge = this.accountFactory.createInvoice(10, "POSTED");
        ChargePoster poster = this.createChargePoster(charge);
        MutableObject latest = new MutableObject();
        poster.post(arg_0 -> ((MutableObject)latest).setValue(arg_0));
        Assert.assertNull((Object)EchoTestHelper.findWindowPane(WindowPane.class));
        Assert.assertEquals((Object)charge, (Object)latest.getValue());
        Assert.assertEquals((long)charge.getVersion(), (long)((FinancialAct)latest.getValue()).getVersion());
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    @Test
    public void testPostDeleted() {
        FinancialAct charge = this.accountFactory.createInvoice(10, "IN_PROGRESS");
        this.remove((IMObject)charge);
        ChargePoster poster = this.createChargePoster(charge);
        MutableObject latest = new MutableObject();
        poster.post(arg_0 -> ((MutableObject)latest).setValue(arg_0));
        String displayName = this.getDisplayName((IMObject)charge);
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)("Finalise " + displayName), (String)("Are you sure you want to Finalise the " + displayName + "?"), (String)"ok");
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)(this.getDisplayName((IMObject)charge) + " may have been deleted by another user"), (Object)this.errors.get(0));
        Assert.assertNull((Object)EchoTestHelper.findWindowPane(WindowPane.class));
    }

    @Test
    public void testUndispensedOrders() {
        Party customer = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient(customer);
        Date now = new Date();
        FinancialAct invoice = (FinancialAct)((TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceBuilder)this.accountFactory.newInvoice().customer(customer)).item().patient(patient)).medicationProduct()).quantity(10)).unitPrice(10)).status("ORDERED")).receivedQuantity(5)).add()).status("IN_PROGRESS")).build();
        ChargePoster poster = this.createChargePoster(invoice);
        MutableObject latest = new MutableObject();
        poster.post(arg_0 -> ((MutableObject)latest).setValue(arg_0));
        String displayName = this.getDisplayName((IMObject)invoice);
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)("Finalise " + displayName + "?"), (String)("The following products have been ordered but not dispensed.\n\nAre you sure you want to finalise the " + displayName + "?"), (String)"ok");
        FinancialAct reloaded = (FinancialAct)this.get((IMObject)invoice);
        Assert.assertEquals((Object)"POSTED", (Object)reloaded.getStatus());
        Assert.assertTrue((DateRules.compareTo((Date)reloaded.getActivityStartTime(), (Date)now, (boolean)true) >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)reloaded, (Object)latest.getValue());
        Assert.assertEquals((long)reloaded.getVersion(), (long)((FinancialAct)latest.getValue()).getVersion());
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    private void checkPost(TestCustomerChargeBuilder<?, ?> builder) {
        this.errors.clear();
        Date now = new Date();
        FinancialAct charge = (FinancialAct)((TestCustomerChargeBuilder)builder.startTime(DateRules.getYesterday())).build();
        ChargePoster poster = this.createChargePoster(charge);
        MutableObject latest = new MutableObject();
        poster.post(arg_0 -> ((MutableObject)latest).setValue(arg_0));
        String displayName = this.getDisplayName((IMObject)charge);
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)("Finalise " + displayName), (String)("Are you sure you want to Finalise the " + displayName + "?"), (String)"ok");
        FinancialAct reloaded = (FinancialAct)this.get((IMObject)charge);
        Assert.assertEquals((Object)"POSTED", (Object)reloaded.getStatus());
        Assert.assertTrue((DateRules.compareTo((Date)reloaded.getActivityStartTime(), (Date)now, (boolean)true) >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)reloaded, (Object)latest.getValue());
        Assert.assertEquals((long)reloaded.getVersion(), (long)((FinancialAct)latest.getValue()).getVersion());
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    private ChargePoster createChargePoster(FinancialAct charge) {
        AccountActActions actions = new AccountActActions(this.accountRules, this.reminderRules, this.getPracticeService());
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        return new ChargePoster(charge, actions, (LayoutContext)layoutContext);
    }
}

