/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.junit.Assert;
import org.junit.Before;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientAlertVerifier;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeTestHelper;
import org.openvpms.web.workspace.customer.charge.EditorQueue;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCustomerChargeActEditorTest
extends AbstractAppTest {
    @Autowired
    protected TestCustomerFactory customerFactory;
    @Autowired
    protected TestDocumentFactory documentFactory;
    @Autowired
    protected TestPatientFactory patientFactory;
    @Autowired
    protected TestPracticeFactory practiceFactory;
    @Autowired
    protected TestProductFactory productFactory;
    @Autowired
    protected TestReminderFactory reminderFactory;
    @Autowired
    protected TestSchedulingFactory schedulingFactory;
    @Autowired
    protected TestUserFactory userFactory;
    private Party practice;

    @Before
    public void setUp() {
        this.practice = (Party)this.practiceFactory.newPractice().taxTypes(new BigDecimal[]{BigDecimal.TEN}).minimumQuantities(true).minimumQuantitiesOverride(null).pharmacyOrderDiscontinuePeriod(0, DateUnits.MINUTES).build();
        super.setUp();
    }

    protected Party getPractice() {
        return this.practice;
    }

    protected CustomerChargeActItemEditor addItem(CustomerChargeActEditor editor, Party patient, Product product, BigDecimal quantity, EditorQueue queue) {
        return CustomerChargeTestHelper.addItem(editor, patient, product, quantity, queue);
    }

    protected void setItem(CustomerChargeActEditor editor, CustomerChargeActItemEditor itemEditor, Party patient, Product product, BigDecimal quantity, EditorQueue queue) {
        CustomerChargeTestHelper.setItem(editor, itemEditor, patient, product, quantity, queue);
    }

    protected void checkCharge(FinancialAct charge, Party customer, User author, User clinician, BigDecimal tax, BigDecimal total) {
        Assert.assertNotNull((Object)charge);
        IMObjectBean bean = this.getBean((IMObject)charge);
        Assert.assertEquals((Object)customer.getObjectReference(), (Object)bean.getTargetRef("customer"));
        Assert.assertEquals((Object)author.getObjectReference(), (Object)charge.getCreatedBy());
        if (bean.hasNode("clinician") && bean.getNode("clinician").getMaxCardinality() != 0) {
            this.checkClinician((Act)charge, clinician);
        }
        this.checkEquals(tax, bean.getBigDecimal("tax"));
        this.checkEquals(total, bean.getBigDecimal("amount"));
    }

    protected void checkClinician(Act act, User clinician) {
        IMObjectBean bean = this.getBean((IMObject)act);
        Reference expected = clinician != null ? clinician.getObjectReference() : null;
        Assert.assertEquals((Object)expected, (Object)bean.getTargetRef("clinician"));
    }

    protected IMObjectBean checkItem(List<FinancialAct> items, String archetype, Party patient, Product product, Product template, int group, User author, User clinician, BigDecimal minimumQuantity, BigDecimal quantity, BigDecimal unitCost, BigDecimal unitPrice, BigDecimal fixedCost, BigDecimal fixedPrice, BigDecimal discount, BigDecimal tax, BigDecimal total, boolean print, Act event, int childActs) {
        int count = 0;
        FinancialAct item = (FinancialAct)FinancialTestHelper.find(items, (Party)patient, (Product)product, (BigDecimal)quantity);
        Assert.assertNotNull((Object)item);
        FinancialTestHelper.checkItem((FinancialAct)item, (String)archetype, (Party)patient, (Product)product, (Product)template, (int)group, (User)author, (User)clinician, (BigDecimal)minimumQuantity, (BigDecimal)quantity, (BigDecimal)unitCost, (BigDecimal)unitPrice, (BigDecimal)fixedCost, (BigDecimal)fixedPrice, (BigDecimal)discount, (BigDecimal)tax, (BigDecimal)total, (boolean)print);
        IMObjectBean itemBean = this.getBean((IMObject)item);
        IMObjectBean bean = this.getBean((IMObject)product);
        if (item.isA("act.customerAccountInvoiceItem")) {
            if (product.isA("product.medication")) {
                if (quantity.signum() >= 0) {
                    Act medication = this.checkMedication(item, patient, product, author, clinician, null, null);
                    if (event != null) {
                        this.checkEventRelationship(event, medication);
                    }
                    ++count;
                } else {
                    Assert.assertEquals((long)0L, (long)itemBean.getTargets("dispensing").size());
                }
            } else {
                this.checkNoTargets((Act)item, "act.patientMedication");
            }
            Set<Entity> investigations = this.getInvestigationTypes(bean);
            Assert.assertEquals((long)investigations.size(), (long)itemBean.getTargets("investigations", Act.class).size());
            for (Entity entity : investigations) {
                Act investigation = this.checkInvestigation((Act)item, patient, entity, author, clinician);
                if (event != null) {
                    this.checkEventRelationship(event, investigation);
                }
                ++count;
            }
            List reminderTypes = bean.getTargets("reminders", Entity.class);
            Assert.assertEquals((long)reminderTypes.size(), (long)itemBean.getTargets("reminders").size());
            for (Object reminderType : reminderTypes) {
                this.checkReminder((Act)item, patient, product, (Entity)reminderType, author, clinician);
                ++count;
            }
            List list = bean.getTargets("alerts", Entity.class);
            Assert.assertEquals((long)list.size(), (long)itemBean.getTargets("alerts", Act.class).size());
            for (Entity alertType : list) {
                this.checkAlert((Act)item, patient, product, alertType, author, clinician);
                ++count;
            }
            List templates = bean.getTargets("documents", Entity.class);
            Assert.assertEquals((long)templates.size(), (long)itemBean.getTargets("documents").size());
            for (Entity docTemplate : templates) {
                DocumentAct document = this.checkDocument((Act)item, patient, product, docTemplate, author, clinician);
                if (event != null) {
                    this.checkEventRelationship(event, (Act)document);
                }
                ++count;
            }
        } else {
            this.checkNoTargets((Act)item, "act.patientMedication");
            this.checkNoTargets((Act)item, "act.patientInvestigation");
            this.checkNoTargets((Act)item, "act.patientReminder");
            this.checkNoTargets((Act)item, "act.patientAlert");
            this.checkNoTargets((Act)item, "act.customerTask");
            this.checkNoTargets((Act)item, "act.patientDocument*");
        }
        Assert.assertEquals((long)childActs, (long)count);
        return itemBean;
    }

    protected void checkEventRelationship(Act event, Act act) {
        this.checkEventRelationship(event, act, true);
    }

    protected void checkEventRelationship(Act event, Act act, boolean exists) {
        IMObjectBean bean = this.getBean((IMObject)event);
        Relationship relationship = act.isA("act.customerAccountInvoiceItem") ? (Relationship)bean.getValue("chargeItems", Relationship.class, Predicates.targetEquals((IMObject)act)) : (Relationship)bean.getValue("items", Relationship.class, Predicates.targetEquals((IMObject)act));
        if (exists) {
            Assert.assertNotNull((Object)relationship);
        } else {
            Assert.assertNull((Object)relationship);
        }
    }

    protected void checkEventRelationships(Act event, Act ... acts) {
        Assert.assertEquals((long)event.getSourceActRelationships().size(), (long)acts.length);
        for (Act act : acts) {
            this.checkEventRelationship(event, act);
        }
    }

    protected Act checkMedication(FinancialAct item, Party patient, Product product, User author, User clinician, Entity batch, Date batchExpiry) {
        IMObjectBean itemBean = this.getBean((IMObject)item);
        List dispensing = itemBean.getTargets("dispensing", Act.class);
        Assert.assertEquals((long)1L, (long)dispensing.size());
        Act medication = (Act)dispensing.get(0);
        IMObjectBean bean = this.getBean((IMObject)medication);
        Assert.assertEquals((Object)item.getActivityStartTime(), (Object)medication.getActivityStartTime());
        if (batchExpiry == null) {
            Assert.assertNull((Object)medication.getActivityEndTime());
        } else {
            batchExpiry = DateUtils.truncate((Date)new Date(batchExpiry.getTime()), (int)13);
            Assert.assertEquals((Object)batchExpiry, (Object)medication.getActivityEndTime());
        }
        Assert.assertTrue((boolean)bean.isA(new String[]{"act.patientMedication"}));
        Assert.assertEquals((Object)product.getObjectReference(), (Object)bean.getTargetRef("product"));
        Assert.assertEquals((Object)patient.getObjectReference(), (Object)bean.getTargetRef("patient"));
        Assert.assertEquals((Object)author.getObjectReference(), (Object)medication.getCreatedBy());
        Reference clinicianRef = clinician != null ? clinician.getObjectReference() : null;
        Assert.assertEquals((Object)clinicianRef, (Object)bean.getTargetRef("clinician"));
        this.checkEquals(item.getQuantity(), bean.getBigDecimal("quantity"));
        Assert.assertEquals((Object)bean.getTargetRef("batch"), (Object)(batch != null ? batch.getObjectReference() : null));
        return medication;
    }

    protected DocumentAct getInvestigation(Act item, Entity investigationType) {
        IMObjectBean itemBean = this.getBean((IMObject)item);
        List investigations = itemBean.getTargets("investigations", Act.class);
        for (Act investigation : investigations) {
            IMObjectBean bean = this.getBean((IMObject)investigation);
            Assert.assertTrue((boolean)bean.isA(new String[]{"act.patientInvestigation"}));
            if (!Objects.equals(bean.getTargetRef("investigationType"), investigationType.getObjectReference())) continue;
            return (DocumentAct)investigation;
        }
        Assert.fail((String)"Investigation not found");
        return null;
    }

    protected Act checkInvestigation(Act item, Party patient, Entity investigationType, User author, User clinician) {
        DocumentAct investigation = this.getInvestigation(item, investigationType);
        IMObjectBean bean = this.getBean((IMObject)investigation);
        Assert.assertEquals((Object)patient.getObjectReference(), (Object)bean.getTargetRef("patient"));
        Assert.assertEquals((Object)investigationType.getObjectReference(), (Object)bean.getTargetRef("investigationType"));
        Assert.assertEquals((Object)author.getObjectReference(), (Object)investigation.getCreatedBy());
        Assert.assertEquals((Object)clinician.getObjectReference(), (Object)bean.getTargetRef("clinician"));
        return investigation;
    }

    protected Act getReminder(Act item, Entity reminderType) {
        IMObjectBean itemBean = this.getBean((IMObject)item);
        List reminders = itemBean.getTargets("reminders", Act.class);
        for (Act reminder : reminders) {
            IMObjectBean bean = this.getBean((IMObject)reminder);
            Assert.assertTrue((boolean)bean.isA(new String[]{"act.patientReminder"}));
            if (!Objects.equals(bean.getTargetRef("reminderType"), reminderType.getObjectReference())) continue;
            return reminder;
        }
        Assert.fail((String)"Reminder not found");
        return null;
    }

    protected Act checkReminder(Act item, Party patient, Product product, Entity reminderType, User author, User clinician) {
        Act reminder = this.getReminder(item, reminderType);
        IMObjectBean productBean = this.getBean((IMObject)product);
        ReminderRules rules = (ReminderRules)ServiceHelper.getBean(ReminderRules.class);
        List rels = productBean.getValues("reminders", Relationship.class, Predicates.targetEquals((IMObject)reminderType));
        Assert.assertEquals((long)1L, (long)rels.size());
        IMObjectBean bean = this.getBean((IMObject)reminder);
        Date initialTime = DateUtils.truncate((Date)bean.getDate("initialTime"), (int)13);
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)item.getActivityStartTime(), (Date)initialTime));
        Date dueDate = rules.calculateProductReminderDueDate(item.getActivityStartTime(), (Relationship)rels.get(0));
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)reminder.getActivityEndTime(), (Date)dueDate));
        Assert.assertEquals((Object)product.getObjectReference(), (Object)bean.getTargetRef("product"));
        Assert.assertEquals((Object)patient.getObjectReference(), (Object)bean.getTargetRef("patient"));
        Assert.assertEquals((Object)reminderType.getObjectReference(), (Object)bean.getTargetRef("reminderType"));
        Assert.assertEquals((Object)author.getObjectReference(), (Object)reminder.getCreatedBy());
        if (clinician != null) {
            Assert.assertEquals((Object)clinician.getObjectReference(), (Object)bean.getTargetRef("clinician"));
        } else {
            Assert.assertNull((Object)bean.getTargetRef("clinician"));
        }
        return reminder;
    }

    protected Act getAlert(Act item, Entity alertType) {
        IMObjectBean itemBean = this.getBean((IMObject)item);
        List alerts = itemBean.getTargets("alerts", Act.class);
        for (Act alert : alerts) {
            IMObjectBean bean = this.getBean((IMObject)alert);
            Assert.assertTrue((boolean)bean.isA(new String[]{"act.patientAlert"}));
            if (!Objects.equals(bean.getTargetRef("alertType"), alertType.getObjectReference())) continue;
            return alert;
        }
        Assert.fail((String)"Alert not found");
        return null;
    }

    protected Act getTask(Act item, Entity taskType) {
        IMObjectBean itemBean = this.getBean((IMObject)item);
        List tasks = itemBean.getTargets("tasks", Act.class);
        for (Act task : tasks) {
            IMObjectBean bean = this.getBean((IMObject)task);
            Assert.assertTrue((boolean)bean.isA(new String[]{"act.customerTask"}));
            if (!Objects.equals(bean.getTargetRef("taskType"), taskType.getObjectReference())) continue;
            return task;
        }
        Assert.fail((String)"Task not found");
        return null;
    }

    protected Act checkAlert(Act item, Party patient, Product product, Entity alertType, User author, User clinician) {
        Act alert = this.getAlert(item, alertType);
        ((TestPatientAlertVerifier)((TestPatientAlertVerifier)((TestPatientAlertVerifier)((TestPatientAlertVerifier)new TestPatientAlertVerifier((ArchetypeService)this.getArchetypeService()).alertType(alertType).startTime(item.getActivityStartTime())).calculateEndTime().product(product).patient(patient)).createdBy(author)).clinician(clinician)).verify((IMObject)alert);
        return alert;
    }

    protected DocumentAct getDocument(Act item, Entity template) {
        IMObjectBean itemBean = this.getBean((IMObject)item);
        List documents = itemBean.getTargets("documents", DocumentAct.class);
        for (DocumentAct document : documents) {
            IMObjectBean bean = this.getBean((IMObject)document);
            Assert.assertTrue((boolean)bean.isA(new String[]{"act.patientDocument*"}));
            if (!Objects.equals(bean.getTargetRef("documentTemplate"), template.getObjectReference())) continue;
            return document;
        }
        Assert.fail((String)"Document not found");
        return null;
    }

    protected DocumentAct checkDocument(Act item, Party patient, Product product, Entity template, User author, User clinician) {
        DocumentAct document = this.getDocument(item, template);
        DocumentTemplate documentTemplate = new DocumentTemplate(template, (ArchetypeService)this.getArchetypeService());
        IMObjectBean bean = this.getBean((IMObject)document);
        Assert.assertTrue((boolean)bean.isA(new String[]{documentTemplate.getType()}));
        Assert.assertEquals((Object)product.getObjectReference(), (Object)bean.getTargetRef("product"));
        Assert.assertEquals((Object)patient.getObjectReference(), (Object)bean.getTargetRef("patient"));
        Assert.assertEquals((Object)template.getObjectReference(), (Object)bean.getTargetRef("documentTemplate"));
        Assert.assertEquals((Object)author.getObjectReference(), (Object)document.getCreatedBy());
        if (clinician != null) {
            Assert.assertEquals((Object)clinician.getObjectReference(), (Object)bean.getTargetRef("clinician"));
        } else {
            Assert.assertNull((Object)bean.getTargetRef("clinician"));
        }
        return document;
    }

    protected DocumentAct checkDocument(Act item, Party patient, Product product, Entity template, User author, User clinician, boolean hasDocument) {
        DocumentAct act = this.checkDocument(item, patient, product, template, author, clinician);
        if (hasDocument) {
            Assert.assertNotNull((Object)act.getDocument());
        } else {
            Assert.assertNull((Object)act.getDocument());
        }
        return act;
    }

    protected void checkChargeEventNote(IMObjectBean chargeItem, Party patient, String note) {
        Act event = this.getEvent(chargeItem);
        this.checkEventNote(event, patient, note);
    }

    protected void checkEventNote(Act event, Party patient, String note) {
        int found = 0;
        IMObjectBean eventBean = this.getBean((IMObject)event);
        Assert.assertEquals((Object)patient, (Object)eventBean.getTarget("patient"));
        for (Act item : eventBean.getTargets("items", Act.class)) {
            if (!TypeHelper.isA((IMObject)item, (String)"act.patientClinicalNote")) continue;
            IMObjectBean bean = this.getBean((IMObject)item);
            Assert.assertEquals((Object)patient, (Object)bean.getTarget("patient"));
            if (!StringUtils.equals((CharSequence)note, (CharSequence)bean.getString("note"))) continue;
            ++found;
        }
        Assert.assertEquals((long)1L, (long)found);
    }

    protected Act getEvent(IMObjectBean item) {
        Act event = (Act)item.getSource("event", Act.class);
        Assert.assertNotNull((Object)event);
        return event;
    }

    protected Entity addDocumentTemplate(Product product) {
        return this.addDocumentTemplate(product, "act.patientDocumentForm");
    }

    protected Entity addDocumentTemplate(Product product, String type) {
        return this.addDocumentTemplate(product, type, false);
    }

    protected Entity addDocumentTemplate(Product product, String type, boolean parameters) {
        TestDocumentTemplateBuilder builder = this.documentFactory.newTemplate().type(type);
        if (parameters) {
            builder.documentWithParameters();
        } else {
            builder.blankDocument();
        }
        Entity template = (Entity)builder.build();
        this.productFactory.updateProduct(product).addDocument(template).build();
        return template;
    }

    protected Entity addReminder(Product product) {
        Entity reminderType = this.reminderFactory.createReminderType();
        this.addReminder(product, reminderType);
        return reminderType;
    }

    protected void addReminder(Product product, Entity reminderType) {
        this.productFactory.updateProduct(product).newProductReminder().reminderType(reminderType).interactive(true).add().build();
    }

    protected Entity createAlertType() {
        return (Entity)this.patientFactory.newAlertType().interactive(true).build();
    }

    protected void addTaxExemption(Party customer) {
        IMObjectBean bean = this.getBean((IMObject)this.getPractice());
        List taxes = bean.getValues("taxes", Lookup.class);
        Assert.assertEquals((long)1L, (long)taxes.size());
        customer.addClassification((Lookup)taxes.get(0));
        this.save((IMObject)customer);
    }

    protected void addDiscount(Entity entity, Entity discount) {
        IMObjectBean bean = this.getBean((IMObject)entity);
        bean.addTarget("discounts", (IMObject)discount);
        bean.save();
    }

    protected void setPharmacyOrderDiscontinuePeriod(int period) {
        this.practiceFactory.updatePractice(this.practice).pharmacyOrderDiscontinuePeriod(period, DateUnits.MINUTES).build();
    }

    protected void save(CustomerChargeActEditor editor) {
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        editor.getDocumentManager().process(editor.getEditorQueue());
    }

    private Set<Entity> getInvestigationTypes(IMObjectBean bean) {
        HashSet<Entity> result = new HashSet<Entity>();
        for (Entity test : bean.getTargets("tests", Entity.class)) {
            IMObjectBean testBean = this.getBean((IMObject)test);
            result.add((Entity)testBean.getTarget("investigationType", Entity.class));
        }
        return result;
    }

    private void checkNoTargets(Act act, String targetArchetype) {
        ActRelationship match = act.getActRelationships().stream().filter(Predicates.targetIsA((String[])new String[]{targetArchetype})).findFirst().orElse(null);
        Assert.assertNull((Object)match);
    }
}

