/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.statement.StatementRules;
import org.openvpms.archetype.rules.finance.statement.StatementService;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCounterSaleBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCounterSaleItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.print.impl.locator.DefaultDocumentPrinterServiceLocator;
import org.openvpms.print.impl.service.DefaultDocumentPrinterService;
import org.openvpms.print.locator.DocumentPrinterServiceLocator;
import org.openvpms.print.service.DocumentPrinterService;
import org.openvpms.report.DocumentConverter;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.print.PrinterContext;
import org.openvpms.web.component.im.report.ReporterFactory;
import org.openvpms.web.component.im.report.TemplatedReporter;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.customer.account.StatementPrinter;
import org.springframework.beans.factory.annotation.Autowired;

public class StatementPrinterTestCase
extends AbstractAppTest {
    @Autowired
    private CustomerAccountRules accountRules;
    @Autowired
    private LaboratoryRules laboratoryRules;
    @Autowired
    private ReporterFactory reporterFactory;
    @Autowired
    private DocumentHandlers documentHandlers;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestCustomerAccountFactory customerAccountFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    private StatementRules statementRules;
    private StatementService statementService;
    @Autowired
    private DomainService domainService;
    private Context context;

    @Before
    public void setUp() {
        super.setUp();
        this.context = new LocalContext();
        Party practice = this.practiceFactory.getPractice();
        this.context.setPractice(practice);
        this.statementRules = new StatementRules(practice, this.getArchetypeService(), this.accountRules);
        this.statementService = new StatementService((IArchetypeRuleService)this.getArchetypeService(), this.accountRules, this.laboratoryRules, this.getPracticeService());
        ((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.customerAccountOpeningBalance").blankDocument()).build();
    }

    @Test
    public void testParameters() {
        Date now = new Date();
        Date yesterday = DateRules.getYesterday();
        Lookup accountType = (Lookup)this.customerFactory.newAccountType().paymentTerms(30, DateUnits.DAYS).build();
        Party customer = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().addClassifications(new Lookup[]{accountType})).build();
        ((TestCounterSaleBuilder)((TestCounterSaleItemBuilder)((TestCounterSaleItemBuilder)((TestCounterSaleBuilder)((TestCounterSaleBuilder)((TestCounterSaleBuilder)this.customerAccountFactory.newCounterSale().startTime(DateRules.getDate((Date)now, (int)-40, (DateUnits)DateUnits.DAYS))).status("POSTED")).customer(customer)).item().fixedPrice(100)).medicationProduct()).add()).build();
        this.context.setCustomer(customer);
        DefaultDocumentPrinterServiceLocator printerLocator = new DefaultDocumentPrinterServiceLocator((DocumentPrinterService)new DefaultDocumentPrinterService(this.documentHandlers));
        PrinterContext printerContext = new PrinterContext((DocumentPrinterServiceLocator)printerLocator, this.getArchetypeService(), (DocumentConverter)Mockito.mock(DocumentConverter.class), this.documentHandlers, this.domainService);
        StatementPrinter printer = new StatementPrinter(this.context, this.accountRules, printerContext, this.reporterFactory);
        printer.setPrintCurrent(true, false);
        Date statementDate1 = this.checkParameters(printer, 100);
        Assert.assertTrue((statementDate1.compareTo(now) >= 0 ? 1 : 0) != 0);
        this.statementService.endPeriod(customer, yesterday, false);
        FinancialAct closingBalance = this.statementRules.getClosingBalance(customer, yesterday);
        Assert.assertNotNull((Object)closingBalance);
        printer.setPrintStatement(closingBalance);
        this.checkParameters(printer, 0, closingBalance.getActivityStartTime());
        printer.setPrintRange(yesterday, DateRules.getToday());
        this.checkParameters(printer, 0, DateRules.getToday());
        printer.setPrintRange(null, yesterday);
        this.checkParameters(printer, 0, yesterday);
        printer.setPrintRange(null, null);
        Date statementDate2 = this.checkParameters(printer, 0);
        Assert.assertTrue((statementDate2.compareTo(now) >= 0 ? 1 : 0) != 0);
    }

    private void checkParameters(StatementPrinter printer, int overdueBalance, Date statementDate) {
        Date actual = this.checkParameters(printer, overdueBalance);
        Assert.assertEquals((Object)statementDate, (Object)actual);
    }

    private Date checkParameters(StatementPrinter printer, int overdueBalance) {
        TemplatedReporter reporter = printer.getReporter();
        Map parameters = reporter.getParameters();
        this.checkEquals(overdueBalance, (BigDecimal)parameters.get("overdueBalance"));
        Date statementDate = (Date)parameters.get("statementDate");
        Assert.assertNotNull((Object)statementDate);
        return statementDate;
    }
}

