/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.customer.account.CustomerAccountQuery;

public class CustomerAccountQueryTestCase
extends AbstractAppTest {
    private Party customer;

    @Before
    public void setUp() {
        super.setUp();
        this.customer = TestHelper.createCustomer();
    }

    @Test
    public void testQuery() {
        TestCustomerAccountQuery query = new TestCustomerAccountQuery(this.customer);
        ResultSet results = query.query();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)0L, (long)results.getResults());
        Party patient1 = TestHelper.createPatient();
        Party patient2 = TestHelper.createPatient();
        List invoice1 = FinancialTestHelper.createChargesInvoice((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Party)patient1, (Product)TestHelper.createProduct(), (String)"POSTED");
        List invoice2 = FinancialTestHelper.createChargesInvoice((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Party)patient2, (Product)TestHelper.createProduct(), (String)"POSTED");
        List credit = FinancialTestHelper.createChargesCredit((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Party)patient1, (Product)TestHelper.createProduct(), (String)"POSTED");
        FinancialAct payment = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Entity)TestHelper.createTill(), (String)"POSTED");
        this.save(invoice1);
        this.save(invoice2);
        this.save(credit);
        this.save((IMObject)payment);
        results = query.query();
        Assert.assertEquals((long)4L, (long)results.getResults());
        Assert.assertTrue((results.getPages() >= 1 ? 1 : 0) != 0);
        query.setPatient(patient1);
        results = query.query();
        Assert.assertEquals((long)2L, (long)results.getResults());
        query.setPatient(patient2);
        results = query.query();
        Assert.assertEquals((long)1L, (long)results.getResults());
        query.setShortName("act.customerAccountRefund");
        results = query.query();
        Assert.assertEquals((long)0L, (long)results.getResults());
    }

    private static class TestCustomerAccountQuery
    extends CustomerAccountQuery<Act> {
        public TestCustomerAccountQuery(Party customer) {
            super(customer, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        }

        public void setShortName(String name) {
            super.setShortName(name);
        }
    }
}

