/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.button.AbstractButton;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.account.AccountCRUDWindow;

public class AccountCRUDWindowTestCase
extends AbstractAppTest {
    @Test
    public void testEditPayment() {
        Party customer = TestHelper.createCustomer();
        FinancialAct payment = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.TEN, (Party)customer, (Entity)TestHelper.createTill(), (String)"POSTED");
        this.save((IMObject)payment);
        List invoice = FinancialTestHelper.createChargesInvoice((BigDecimal)BigDecimal.TEN, (Party)customer, (Party)TestHelper.createPatient(), (Product)TestHelper.createProduct(), (String)"POSTED");
        this.save(invoice);
        LocalContext context1 = new LocalContext();
        context1.setUser(TestHelper.createUser((boolean)false));
        TestAccountCRUDWindow window1 = new TestAccountCRUDWindow((Context)context1);
        Assert.assertNull((Object)window1.getButtons().getButton("button.edit"));
        window1.setObject(payment);
        Assert.assertNull((Object)window1.getButtons().getButton("button.edit"));
        window1.setObject((FinancialAct)invoice.get(0));
        Assert.assertNull((Object)window1.getButtons().getButton("button.edit"));
        LocalContext context2 = new LocalContext();
        context2.setUser(TestHelper.createAdministrator((boolean)false));
        TestAccountCRUDWindow window2 = new TestAccountCRUDWindow((Context)context2);
        AbstractButton button = window2.getButtons().getButton("button.edit");
        Assert.assertNotNull((Object)button);
        Assert.assertFalse((boolean)button.isEnabled());
        window2.setObject(payment);
        Assert.assertTrue((boolean)button.isEnabled());
        window2.setObject((FinancialAct)invoice.get(0));
        Assert.assertFalse((boolean)button.isEnabled());
    }

    @Test
    public void testEditPaymentForClearedTill() {
        ArrayList errors = new ArrayList();
        this.initErrorHandler(errors);
        LocalContext context = new LocalContext();
        context.setUser(TestHelper.createAdministrator((boolean)false));
        TestAccountCRUDWindow window = new TestAccountCRUDWindow((Context)context);
        Party customer = TestHelper.createCustomer();
        FinancialAct payment = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.TEN, (Party)customer, (Entity)TestHelper.createTill(), (String)"POSTED");
        this.save((IMObject)payment);
        IMObjectBean bean = this.getBean((IMObject)payment);
        FinancialAct balance = (FinancialAct)bean.getSource("tillBalance", FinancialAct.class);
        Assert.assertNotNull((Object)balance);
        Assert.assertEquals((Object)"UNCLEARED", (Object)balance.getStatus());
        window.administerPayment(payment);
        EditDialog dialog1 = EchoTestHelper.findEditDialog();
        Assert.assertNotNull((Object)dialog1);
        EchoTestHelper.fireDialogButton((PopupDialog)dialog1, (String)"ok");
        Assert.assertNull((Object)EchoTestHelper.findEditDialog());
        balance.setStatus("IN_PROGRESS");
        this.save((IMObject)balance);
        window.administerPayment(payment);
        EditDialog dialog2 = EchoTestHelper.findEditDialog();
        Assert.assertNotNull((Object)dialog2);
        EchoTestHelper.fireDialogButton((PopupDialog)dialog2, (String)"ok");
        Assert.assertNull((Object)EchoTestHelper.findEditDialog());
        balance.setStatus("CLEARED");
        this.save((IMObject)balance);
        window.administerPayment(payment);
        Assert.assertNull((Object)EchoTestHelper.findEditDialog());
        ErrorDialog errorDialog = (ErrorDialog)EchoTestHelper.findWindowPane(ErrorDialog.class);
        Assert.assertEquals((Object)"This payment cannot be edited as it linked to a Cleared Till Balance", (Object)errorDialog.getMessage());
    }

    private static class TestAccountCRUDWindow
    extends AccountCRUDWindow {
        public TestAccountCRUDWindow(Context context) {
            super(Archetypes.create((String)"act.customerAccount*", FinancialAct.class), context, new HelpContext("foo", null));
            this.getComponent();
        }

        public ButtonSet getButtons() {
            return super.getButtons();
        }
    }
}

