/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.user;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.delete.Deletable;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandler;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandlerFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.admin.user.UserDeletionHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class UserDeletionHandlerTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectDeletionHandlerFactory factory;

    @Test
    public void testFactory() {
        User user = TestHelper.createClinician((boolean)false);
        Assert.assertTrue((boolean)(this.factory.create((IMObject)user) instanceof UserDeletionHandler));
    }

    @Test
    public void testDeleteUserWithParticipations() {
        User user = TestHelper.createClinician();
        IMObjectDeletionHandler handler = this.factory.create((IMObject)user);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        Assert.assertTrue((boolean)handler.canDeactivate());
        PatientTestHelper.createNote((Date)new Date(), (Party)TestHelper.createPatient(), (User)user);
        Deletable deletable = handler.getDeletable();
        Assert.assertFalse((boolean)deletable.canDelete());
        Assert.assertEquals((Object)"User has relationships and cannot be deleted.", (Object)deletable.getReason());
        Assert.assertTrue((boolean)handler.canDeactivate());
    }

    @Test
    public void testDeleteUserWhoIsEntityRelationshipTarget() {
        User user = TestHelper.createUser();
        Entity group = (Entity)this.create("entity.userGroup", Entity.class);
        group.setName(TestHelper.randomName((String)"ZGroup"));
        IMObjectBean bean = this.getBean((IMObject)group);
        bean.addTarget("users", (IMObject)user, "groups");
        bean.save(new IMObject[]{user});
        IMObjectDeletionHandler handler = this.factory.create((IMObject)user);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        Assert.assertTrue((boolean)handler.canDeactivate());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)user));
    }

    @Test
    public void testDeleteUserWhoIsEntityLinkSource() {
        User user = TestHelper.createUser();
        Party worklist = ScheduleTestHelper.createWorkList();
        IMObjectBean bean = this.getBean((IMObject)user);
        bean.addTarget("followupWorkLists", (IMObject)worklist);
        bean.save();
        IMObjectDeletionHandler handler = this.factory.create((IMObject)user);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        Assert.assertTrue((boolean)handler.canDeactivate());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)user));
        Assert.assertNotNull((Object)this.get((IMObject)worklist));
    }

    @Test
    public void testDeleteUserWhoIsEntityLinkTarget() {
        User user = TestHelper.createUser();
        Entity preferences = (Entity)this.create("entity.preferences", Entity.class);
        IMObjectBean bean = this.getBean((IMObject)preferences);
        bean.setTarget("user", (IMObject)user);
        bean.save(new IMObject[]{user});
        IMObjectDeletionHandler handler = this.factory.create((IMObject)user);
        Deletable deletable = handler.getDeletable();
        Assert.assertFalse((boolean)deletable.canDelete());
        Assert.assertEquals((Object)"User has relationships and cannot be deleted.", (Object)deletable.getReason());
        Assert.assertTrue((boolean)handler.canDeactivate());
    }

    @Test
    public void testDeleteUserAssociatedWithJob() {
        User user = TestHelper.createUser();
        IMObjectDeletionHandler handler = this.factory.create((IMObject)user);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        Assert.assertTrue((boolean)handler.canDeactivate());
        IMObject job = this.create("entity.jobPharmacyOrderDiscontinuation");
        IMObjectBean bean = this.getBean(job);
        bean.addTarget("runAs", (IMObject)user);
        bean.save();
        Deletable deletable1 = handler.getDeletable();
        Assert.assertFalse((boolean)deletable1.canDelete());
        Assert.assertEquals((Object)"User is required by the Pharmacy Order Discontinuation Job", (Object)deletable1.getReason());
        Assert.assertFalse((boolean)handler.canDeactivate());
        job.setActive(false);
        this.save(job);
        Deletable deletable2 = handler.getDeletable();
        Assert.assertFalse((boolean)deletable2.canDelete());
        Assert.assertEquals((Object)"User has relationships and cannot be deleted.", (Object)deletable2.getReason());
        Assert.assertTrue((boolean)handler.canDeactivate());
        this.factory.create(job).delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get(job));
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)user));
    }
}

