/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.workspace.admin.template.PrinterUseManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class PrinterUseManagerTestCase
extends ArchetypeServiceTest {
    @Autowired
    private PracticeService practiceService;
    @Autowired
    private LocationRules locationRules;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Test
    public void testChange() {
        PrinterReference printerA = PrinterReference.fromString((String)"printerA");
        PrinterReference printerB = PrinterReference.fromString((String)"printerB");
        PrinterReference printerC = PrinterReference.fromString((String)"printerC");
        Party location1 = (Party)this.practiceFactory.newLocation().defaultPrinter(printerB).printers(new PrinterReference[]{printerA, printerB, printerC}).build();
        Party location2 = (Party)this.practiceFactory.newLocation().defaultPrinter(printerB).printers(new PrinterReference[]{printerB}).build();
        Entity template1 = (Entity)this.documentFactory.newTemplate().printer().printer(printerA).location(location1).add().build();
        Entity template2 = (Entity)this.documentFactory.newTemplate().printer().printer(printerB).location(location2).add().build();
        TestPrinterUseManager manager = new TestPrinterUseManager(Arrays.asList(location1, location2), Arrays.asList(template1, template2));
        Assert.assertFalse((boolean)manager.hasPrinters());
        manager.refresh();
        this.checkPrinters(manager, printerA, printerB, printerC);
        this.checkUse(printerA, manager, new Entity[]{location1, template1});
        this.checkUse(printerB, manager, new Entity[]{location1, location2, template2});
        this.checkUse(printerC, manager, new Entity[]{location1});
        this.checkLocation(location1, printerB, printerA, printerB, printerC);
        this.checkLocation(location2, printerB, printerB);
        manager.replace(printerB, printerA);
        manager.refresh();
        this.checkPrinters(manager, printerA, printerC);
        this.checkUse(printerA, manager, new Entity[]{location1, location2, template1, template2});
        this.checkUse(printerB, manager, new Entity[0]);
        this.checkUse(printerC, manager, new Entity[]{location1});
        this.checkLocation(location1, printerA, printerA, printerC);
        this.checkLocation(location2, printerA, printerA);
    }

    @Test
    public void testRemove() {
        PrinterReference printerA = PrinterReference.fromString((String)"printerA");
        PrinterReference printerB = PrinterReference.fromString((String)"printerB");
        Party location1 = (Party)this.practiceFactory.newLocation().defaultPrinter(printerA).printers(new PrinterReference[]{printerA}).build();
        Party location2 = (Party)this.practiceFactory.newLocation().defaultPrinter(printerB).printers(new PrinterReference[]{printerB}).build();
        Entity template1 = (Entity)this.documentFactory.newTemplate().printer().printer(printerA).location(location1).add().build();
        Entity template2 = (Entity)this.documentFactory.newTemplate().printer().printer(printerB).location(location2).add().build();
        TestPrinterUseManager manager = new TestPrinterUseManager(Arrays.asList(location1, location2), Arrays.asList(template1, template2));
        Assert.assertFalse((boolean)manager.hasPrinters());
        manager.refresh();
        this.checkPrinters(manager, printerA, printerB);
        this.checkUse(printerA, manager, new Entity[]{location1, template1});
        this.checkUse(printerB, manager, new Entity[]{location2, template2});
        this.checkLocation(location1, printerA, printerA);
        this.checkLocation(location2, printerB, printerB);
        manager.remove(printerA);
        manager.refresh();
        this.checkPrinters(manager, printerB);
        this.checkUse(printerA, manager, new Entity[0]);
        this.checkUse(printerB, manager, new Entity[]{location2, template2});
        this.checkLocation(location1, null, new PrinterReference[0]);
        this.checkLocation(location2, printerB, printerB);
    }

    private void checkLocation(Party location, PrinterReference expectedDefault, PrinterReference ... expected) {
        location = (Party)this.get((IMObject)location);
        PrinterReference actualDefault = this.locationRules.getDefaultPrinter(location);
        Assert.assertEquals((Object)expectedDefault, (Object)actualDefault);
        HashSet actual = new HashSet(this.locationRules.getPrinters(location));
        Assert.assertEquals(new HashSet<PrinterReference>(Arrays.asList(expected)), actual);
    }

    private void checkPrinters(PrinterUseManager manager, PrinterReference ... expected) {
        Assert.assertEquals((Object)(expected.length != 0 ? 1 : 0), (Object)manager.hasPrinters());
        List printers = manager.getPrinters();
        Assert.assertEquals((long)expected.length, (long)printers.size());
        for (PrinterReference printer : expected) {
            Assert.assertTrue((boolean)printers.contains(printer));
        }
    }

    private void checkUse(PrinterReference reference, PrinterUseManager manager, Entity ... expected) {
        List use = manager.getUse(reference);
        Assert.assertEquals((long)expected.length, (long)use.size());
        for (Entity entity : expected) {
            Assert.assertTrue((boolean)use.contains(entity));
        }
    }

    private class TestPrinterUseManager
    extends PrinterUseManager {
        private List<Party> locations;
        private List<Entity> templates;

        public TestPrinterUseManager(List<Party> locations, List<Entity> templates) {
            super((ArchetypeService)PrinterUseManagerTestCase.this.getArchetypeService(), PrinterUseManagerTestCase.this.practiceService, PrinterUseManagerTestCase.this.locationRules, PrinterUseManagerTestCase.this.transactionManager);
            this.locations = locations;
            this.templates = templates;
        }

        public void refresh() {
            this.locations = this.reload(this.locations);
            this.templates = this.reload(this.templates);
            super.refresh();
        }

        protected List<Party> getLocations() {
            return this.locations;
        }

        protected Iterator<Entity> getTemplates() {
            return this.templates.iterator();
        }

        private <T extends IMObject> List<T> reload(List<T> current) {
            ArrayList<IMObject> result = new ArrayList<IMObject>();
            for (IMObject object : current) {
                if ((object = PrinterUseManagerTestCase.this.get(object)) == null) continue;
                result.add(object);
            }
            return result;
        }
    }
}

