/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.role;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.security.SecurityRole;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.admin.role.RoleEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class RoleEditorTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectEditorFactory factory;

    @Test
    public void testDuplicate() {
        SecurityRole role1 = (SecurityRole)this.create("security.role", SecurityRole.class);
        String name1 = TestHelper.randomName((String)"zrole");
        SecurityRole role2 = (SecurityRole)this.create("security.role", SecurityRole.class);
        String name2 = TestHelper.randomName((String)"zrole");
        role2.setName(name2);
        this.save((IMObject)role2);
        RoleEditor editor = new RoleEditor(role1, null, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        Assert.assertFalse((boolean)editor.isValid());
        editor.setName(name1);
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        editor.setName(name2);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)("A role already exists with name '" + editor.getName() + "'"));
        editor.setName(name1);
        Assert.assertTrue((boolean)editor.isValid());
    }

    @Test
    public void testFactory() {
        SecurityRole role = (SecurityRole)this.create("security.role", SecurityRole.class);
        IMObjectEditor editor = this.factory.create((IMObject)role, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        Assert.assertTrue((boolean)(editor instanceof RoleEditor));
    }

    @Test
    public void testNewInstance() {
        SecurityRole role = (SecurityRole)this.create("security.role", SecurityRole.class);
        RoleEditor editor = new RoleEditor(role, null, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        IMObjectEditor newInstance = editor.newInstance();
        Assert.assertTrue((boolean)(newInstance instanceof RoleEditor));
        Assert.assertEquals((Object)role, (Object)newInstance.getObject());
    }
}

