/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.organisation.schedule;

import java.sql.Time;
import java.util.Date;
import nextapp.echo2.app.Component;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestCalendarBlockBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditorTest;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.admin.organisation.schedule.ScheduleEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class ScheduleEditorTestCase
extends AbstractIMObjectEditorTest<ScheduleEditor> {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;

    public ScheduleEditorTestCase() {
        super(ScheduleEditor.class, "party.organisationSchedule");
    }

    @Test
    public void testTimesValidation() {
        Entity schedule = (Entity)this.schedulingFactory.newSchedule().build(false);
        LocalContext local = new LocalContext();
        local.setLocation(this.practiceFactory.createLocation());
        DefaultLayoutContext context = new DefaultLayoutContext((Context)local, new HelpContext("foo", null));
        ScheduleEditor editor = new ScheduleEditor(schedule, null, (LayoutContext)context);
        editor.getComponent();
        editor.getProperty("name").setValue((Object)"Test Schedule");
        Assert.assertTrue((boolean)editor.isValid());
        Property startTime = editor.getProperty("startTime");
        Property endTime = editor.getProperty("endTime");
        startTime.setValue((Object)Time.valueOf("08:00:00"));
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"Both Start Time and End Time must be specified");
        startTime.setValue(null);
        endTime.setValue((Object)Time.valueOf("08:00:00"));
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"Both Start Time and End Time must be specified");
        startTime.setValue((Object)Time.valueOf("09:00:00"));
        endTime.setValue((Object)Time.valueOf("09:00:00"));
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"Start Time must be less than End Time");
        endTime.setValue((Object)Time.valueOf("17:00:00"));
        Assert.assertTrue((boolean)editor.isValid());
    }

    @Test
    public void testMaxDurationValidation() {
        LocalContext local = new LocalContext();
        local.setLocation(this.practiceFactory.createLocation());
        Entity schedule = (Entity)this.schedulingFactory.newSchedule().location(local.getLocation()).maxDuration(72, DateUnits.HOURS).build();
        Date yesterday = DateRules.getYesterday();
        ((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(DateRules.getPreviousDate((Date)yesterday))).endTime(DateRules.getToday())).schedule(schedule).appointmentType(this.schedulingFactory.createAppointmentType()).customer(this.customerFactory.createCustomer())).patient(this.patientFactory.createPatient())).build();
        ((TestCalendarBlockBuilder)((TestCalendarBlockBuilder)((TestCalendarBlockBuilder)this.schedulingFactory.newCalendarBlock().startTime(yesterday)).endTime(DateRules.getToday())).schedule(schedule)).type(this.schedulingFactory.createCalendarBlockType()).build();
        Act act = (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(yesterday)).endTime(DateRules.getTomorrow())).schedule(schedule).appointmentType(this.schedulingFactory.createAppointmentType()).customer(this.customerFactory.createCustomer())).patient(this.patientFactory.createPatient())).build();
        local.setLocation(this.practiceFactory.createLocation());
        DefaultLayoutContext context = new DefaultLayoutContext((Context)local, new HelpContext("foo", null));
        ScheduleEditor editor = new ScheduleEditor(schedule, null, (LayoutContext)context);
        editor.getComponent();
        editor.setMaxDuration(12, DateUnits.HOURS);
        Assert.assertFalse((boolean)editor.isValid());
        String durationReductionMessage = "The Max Duration has been reduced. This can affect the retrieval of historical appointments and calendar blocks.\n\nDo you want to keep this change?";
        ConfirmationDialog confirmationDialog = (ConfirmationDialog)EchoTestHelper.getWindowPane(ConfirmationDialog.class);
        Assert.assertEquals((Object)durationReductionMessage, (Object)confirmationDialog.getMessage());
        Assert.assertFalse((boolean)editor.isValid());
        EchoTestHelper.fireButton((Component)confirmationDialog, (String)"no");
        Assert.assertEquals((long)72L, (long)editor.getMaxDuration());
        Assert.assertEquals((Object)DateUnits.HOURS, (Object)editor.getMaxDurationUnits());
        editor.setMaxDuration(60, DateUnits.HOURS);
        Assert.assertNull((Object)EchoTestHelper.findWindowPane(ConfirmationDialog.class));
        Assert.assertTrue((boolean)editor.isValid());
        editor.setMaxDuration(12, DateUnits.HOURS);
        String message = "Max Duration must be >= 2 Days to support Appointment on " + DateFormatter.formatDate((Date)act.getActivityStartTime(), (boolean)false) + " at " + DateFormatter.formatTime((Date)act.getActivityStartTime(), (boolean)false);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)message);
        editor.setMaxDuration(48, DateUnits.HOURS);
        Assert.assertTrue((boolean)editor.isValid());
    }
}

