/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.organisation.schedule;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandler;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandlerFactory;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.admin.organisation.schedule.ScheduleDeletionHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class ScheduleDeletionHandlerTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectEditorFactory factory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;

    @Test
    public void testDeleteScheduleNoRelationships() {
        Entity schedule = this.schedulingFactory.createSchedule(this.practiceFactory.createLocation());
        ScheduleDeletionHandler handler = this.createDeletionHandler(schedule);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)schedule));
    }

    @Test
    public void testDeleteScheduleWithAppointmentTypes() {
        Entity appointmentType = this.schedulingFactory.createAppointmentType();
        Entity schedule = (Entity)this.schedulingFactory.newSchedule().location(this.practiceFactory.createLocation()).addAppointmentType(appointmentType, 1, true).build();
        ScheduleDeletionHandler handler = this.createDeletionHandler(schedule);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)schedule));
        Assert.assertNotNull((Object)this.get((IMObject)appointmentType));
    }

    @Test
    public void testDeleteScheduleWithWorkLists() {
        Entity workList = this.schedulingFactory.createWorkList();
        Entity schedule = (Entity)this.schedulingFactory.newSchedule().location(this.practiceFactory.createLocation()).addWorkLists(new Entity[]{workList}).build();
        ScheduleDeletionHandler handler = this.createDeletionHandler(schedule);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)schedule));
        Assert.assertNotNull((Object)this.get((IMObject)workList));
    }

    @Test
    public void testDeleteScheduleWithTemplates() {
        Entity template = this.documentFactory.createTemplate("act.patientDocumentLetter");
        Entity schedule = (Entity)this.schedulingFactory.newSchedule().location(this.practiceFactory.createLocation()).addTemplates(new Entity[]{template}).build();
        ScheduleDeletionHandler handler = this.createDeletionHandler(schedule);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)schedule));
        Assert.assertNotNull((Object)this.get((IMObject)template));
    }

    @Test
    public void testDeleteScheduleWithActs() {
        Entity schedule = this.schedulingFactory.createSchedule(this.practiceFactory.createLocation());
        ScheduleDeletionHandler handler = this.createDeletionHandler(schedule);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        ((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(new Date())).schedule(schedule).appointmentType(this.schedulingFactory.createAppointmentType()).customer(this.customerFactory.createCustomer())).patient(this.patientFactory.createPatient())).build();
        Assert.assertFalse((boolean)handler.getDeletable().canDelete());
    }

    @Test
    public void testDeleteScheduleInViews() {
        Entity schedule = this.schedulingFactory.createSchedule(this.practiceFactory.createLocation());
        Entity view = this.schedulingFactory.createScheduleView(new Entity[]{schedule});
        ScheduleDeletionHandler handler = this.createDeletionHandler(schedule);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)schedule));
        Assert.assertNotNull((Object)this.get((IMObject)view));
    }

    @Test
    public void testDeactivate() {
        Entity schedule = this.schedulingFactory.createSchedule(this.practiceFactory.createLocation());
        Assert.assertTrue((boolean)schedule.isActive());
        ScheduleDeletionHandler handler = this.createDeletionHandler(schedule);
        handler.deactivate();
        Assert.assertFalse((boolean)((Entity)this.get((IMObject)schedule)).isActive());
    }

    @Test
    public void testFactory() {
        IMObjectDeletionHandlerFactory factory = new IMObjectDeletionHandlerFactory(this.getArchetypeService());
        Assert.assertNotNull((Object)this.applicationContext);
        factory.setApplicationContext(this.applicationContext);
        Entity schedule = this.schedulingFactory.createSchedule(this.practiceFactory.createLocation());
        IMObjectDeletionHandler handler = factory.create((IMObject)schedule);
        Assert.assertTrue((boolean)(handler instanceof ScheduleDeletionHandler));
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)schedule));
    }

    protected ScheduleDeletionHandler createDeletionHandler(Entity schedule) {
        return new ScheduleDeletionHandler(schedule, this.factory, ServiceHelper.getTransactionManager(), ServiceHelper.getArchetypeService());
    }
}

