/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.lookup;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.admin.lookup.LookupEditor;

public class LookupEditorTestCase
extends AbstractAppTest {
    @Test
    public void testDuplicate() {
        String duplicate = "CBA";
        TestHelper.getLookup((String)"lookup.bank", (String)duplicate);
        Lookup lookup = (Lookup)this.create("lookup.bank", Lookup.class);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        IMObjectEditor editor = ((IMObjectEditorFactory)ServiceHelper.getBean(IMObjectEditorFactory.class)).create((IMObject)lookup, (LayoutContext)context);
        Assert.assertTrue((boolean)(editor instanceof LookupEditor));
        Property name = editor.getProperty("name");
        Assert.assertNotNull((Object)name);
        name.setValue((Object)"Foo Bank");
        Assert.assertEquals((Object)"FOO_BANK", (Object)lookup.getCode());
        Assert.assertTrue((boolean)editor.isValid());
        name.setValue((Object)duplicate);
        Assert.assertEquals((Object)"CBA", (Object)lookup.getCode());
        Assert.assertFalse((boolean)editor.isValid());
        DefaultValidator validator = new DefaultValidator();
        Assert.assertFalse((boolean)editor.validate((Validator)validator));
        List errors = validator.getErrors((Modifiable)editor);
        Assert.assertEquals((long)1L, (long)errors.size());
        ValidatorError error = (ValidatorError)errors.get(0);
        String editorDisplay = editor.getDisplayName();
        String codeDisplay = editor.getProperty("code").getDisplayName();
        String message = Messages.format((String)"lookup.validation.duplicate", (Object[])new Object[]{editorDisplay, codeDisplay, duplicate});
        String expected = Messages.format((String)ValidatorError.NODE_KEY, (Object[])new Object[]{editorDisplay, codeDisplay, message});
        Assert.assertEquals((Object)expected, (Object)error.toString());
    }
}

