/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.job;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandler;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandlerFactory;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.admin.job.JobDeletionHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class JobDeletionHandlerTestCase
extends AbstractAppTest {
    @Autowired
    IMObjectEditorFactory factory;

    @Test
    public void testDelete() {
        User runAs = TestHelper.createUser();
        Entity job = this.createJob(runAs);
        JobDeletionHandler handler = this.createDeletionHandler(job);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)job));
        Assert.assertEquals((Object)runAs, (Object)this.get((IMObject)runAs));
    }

    @Test
    public void testDeactivate() {
        User runAs = TestHelper.createUser();
        Entity job = this.createJob(runAs);
        Assert.assertTrue((boolean)job.isActive());
        JobDeletionHandler handler = this.createDeletionHandler(job);
        handler.deactivate();
        Assert.assertFalse((boolean)((Entity)this.get((IMObject)job)).isActive());
    }

    @Test
    public void testFactory() {
        IMObjectDeletionHandlerFactory factory = new IMObjectDeletionHandlerFactory(this.getArchetypeService());
        Assert.assertNotNull((Object)this.applicationContext);
        factory.setApplicationContext(this.applicationContext);
        User runAs = TestHelper.createUser();
        Entity job = this.createJob(runAs);
        IMObjectDeletionHandler handler = factory.create((IMObject)job);
        Assert.assertTrue((boolean)(handler instanceof JobDeletionHandler));
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)job));
    }

    private JobDeletionHandler createDeletionHandler(Entity job) {
        IMObjectEditorFactory factory = (IMObjectEditorFactory)this.applicationContext.getBean(IMObjectEditorFactory.class);
        return new JobDeletionHandler(job, factory, ServiceHelper.getTransactionManager(), ServiceHelper.getArchetypeService());
    }

    private Entity createJob(User user) {
        Entity job = (Entity)this.create("entity.jobPharmacyOrderDiscontinuation", Entity.class);
        IMObjectBean bean = this.getBean((IMObject)job);
        bean.setTarget("runAs", (IMObject)user);
        bean.setTarget("notify", (IMObject)user);
        bean.save();
        return job;
    }
}

