/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.job;

import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.web.workspace.admin.job.CronHelper;

public class CronHelperTestCase {
    @Test
    public void testMinutes() {
        this.checkValid("*", CronHelper.MINUTES);
        this.checkValid("0", CronHelper.MINUTES);
        this.checkValid("0-59", CronHelper.MINUTES);
        this.checkValid("0,1,2,3,4,5", CronHelper.MINUTES);
        this.checkValid("0,1,2,3,4,5-10", CronHelper.MINUTES);
        this.checkValid("*/5", CronHelper.MINUTES);
        this.checkInvalid("?", CronHelper.MINUTES);
        this.checkInvalid("-1", CronHelper.MINUTES);
        this.checkInvalid("60", CronHelper.MINUTES);
    }

    @Test
    public void testHours() {
        this.checkValid("*", CronHelper.HOURS);
        this.checkValid("0", CronHelper.HOURS);
        this.checkValid("0-23", CronHelper.HOURS);
        this.checkValid("0,1,2,3,4,5", CronHelper.HOURS);
        this.checkValid("0,1,2,3,4,5-10", CronHelper.HOURS);
        this.checkValid("*/2", CronHelper.HOURS);
        this.checkInvalid("?", CronHelper.HOURS);
        this.checkInvalid("-1", CronHelper.HOURS);
        this.checkInvalid("24", CronHelper.HOURS);
    }

    @Test
    public void testDayOfMonth() {
        this.checkValid("*", CronHelper.DAY_OF_MONTH);
        this.checkValid("?", CronHelper.DAY_OF_MONTH);
        this.checkValid("1", CronHelper.DAY_OF_MONTH);
        this.checkValid("1-31", CronHelper.DAY_OF_MONTH);
        this.checkValid("01,02,9,10-24", CronHelper.DAY_OF_MONTH);
        this.checkValid("*/5", CronHelper.DAY_OF_MONTH);
        this.checkInvalid("0", CronHelper.DAY_OF_MONTH);
        this.checkInvalid("-1", CronHelper.DAY_OF_MONTH);
        this.checkInvalid("32", CronHelper.DAY_OF_MONTH);
    }

    @Test
    public void testMonth() {
        this.checkValid("*", CronHelper.MONTH);
        this.checkValid("1", CronHelper.MONTH);
        this.checkValid("1-12", CronHelper.MONTH);
        this.checkValid("jan,feb,mar,apr,may,jun,jul,aug,sep,oct,nov,dec", CronHelper.MONTH);
        this.checkValid("jan-dec", CronHelper.MONTH);
        this.checkValid("MAR,AUG", CronHelper.MONTH);
        this.checkValid("*/2", CronHelper.MONTH);
        this.checkInvalid("?", CronHelper.MONTH);
        this.checkInvalid("0", CronHelper.MONTH);
        this.checkInvalid("13", CronHelper.MONTH);
    }

    @Test
    public void testDayOfWeek() {
        this.checkValid("*", CronHelper.DAY_OF_WEEK);
        this.checkValid("?", CronHelper.DAY_OF_WEEK);
        this.checkValid("1", CronHelper.DAY_OF_WEEK);
        this.checkValid("1-7", CronHelper.DAY_OF_WEEK);
        this.checkValid("sun,mon,tue,wed,thu,fri,sat", CronHelper.DAY_OF_WEEK);
        this.checkValid("sun-sat", CronHelper.DAY_OF_WEEK);
        this.checkValid("*/2", CronHelper.DAY_OF_WEEK);
        this.checkInvalid("0", CronHelper.DAY_OF_WEEK);
        this.checkInvalid("8", CronHelper.DAY_OF_WEEK);
    }

    private void checkValid(String value, Pattern pattern) {
        Assert.assertTrue((boolean)pattern.matcher(value).matches());
    }

    private void checkInvalid(String value, Pattern pattern) {
        Assert.assertFalse((String)value, (boolean)pattern.matcher(value).matches());
    }
}

