/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.hl7;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.lookup.LookupRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.web.workspace.admin.hl7.AbstractLookupMappingTest;
import org.openvpms.web.workspace.admin.hl7.LookupMapping;
import org.openvpms.web.workspace.admin.hl7.LookupMappingCSVWriter;
import org.openvpms.web.workspace.admin.hl7.LookupMappingImporter;
import org.openvpms.web.workspace.admin.hl7.LookupMappings;

public class LookupMappingImporterTestCase
extends AbstractLookupMappingTest {
    @Before
    public void setUp() {
        this.removeLookup("lookup.species", "SPECIES_1");
        this.removeLookup("lookup.species", "SPECIES_2");
        this.removeLookup("lookup.species", "SPECIES_3");
        this.removeLookup("lookup.speciesIDEXX", "SPECIES_A");
        this.removeLookup("lookup.speciesIDEXX", "SPECIES_B");
        this.removeLookup("lookup.speciesIDEXX", "SPECIES_C");
    }

    @Test
    public void testImport() throws IOException {
        String[][] data = new String[][]{{"lookup.species", "SPECIES_1", "species1", "lookup.speciesIDEXX", "SPECIES_A", "speciesA"}, {"lookup.species", "SPECIES_2", "species2", "lookup.speciesIDEXX", "SPECIES_B", "speciesB"}, {"lookup.species", "SPECIES_3", "species3", "lookup.speciesIDEXX", "SPECIES_C", "speciesC"}};
        LookupMappings mappings = this.load(data);
        Assert.assertEquals((long)3L, (long)mappings.getMappings().size());
        Assert.assertEquals((long)0L, (long)mappings.getErrors().size());
        this.checkMappings(data);
    }

    @Test
    public void testLoadDuplicate() throws IOException {
        String[][] data = new String[][]{{"lookup.species", "SPECIES_1", "species1", "lookup.speciesIDEXX", "SPECIES_A", "speciesA"}, {"lookup.species", "SPECIES_1", "species1", "lookup.speciesIDEXX", "SPECIES_A", "speciesA"}};
        LookupMappings mappings = this.load(data);
        Assert.assertEquals((long)1L, (long)mappings.getMappings().size());
        Assert.assertEquals((long)0L, (long)mappings.getErrors().size());
        this.checkMappings(data);
    }

    @Test
    public void testMismatchName() throws IOException {
        this.getSpecies("SPECIES_1", "species1");
        this.getSpecies("SPECIES_2", "species2");
        this.getIDEXXSpecies("SPECIES_A", "speciesA");
        this.getIDEXXSpecies("SPECIES_B", "speciesB");
        String[][] invalid1 = new String[][]{{"lookup.species", "SPECIES_1", "species 1", "lookup.speciesIDEXX", "SPECIES_A", "speciesA"}};
        String[][] invalid2 = new String[][]{{"lookup.species", "SPECIES_2", "species2", "lookup.speciesIDEXX", "SPECIES_B", "species B"}};
        LookupMappings mappings = this.load(invalid1);
        Assert.assertEquals((long)0L, (long)mappings.getMappings().size());
        List errors = mappings.getErrors();
        Assert.assertEquals((long)1L, (long)errors.size());
        this.checkMapping((LookupMapping)errors.get(0), "lookup.species", "SPECIES_1", "species 1", "lookup.speciesIDEXX", "SPECIES_A", "speciesA", 2, "Expected species1 for SPECIES_1 but got species 1");
        mappings = this.load(invalid2);
        Assert.assertEquals((long)0L, (long)mappings.getMappings().size());
        errors = mappings.getErrors();
        Assert.assertEquals((long)1L, (long)errors.size());
        this.checkMapping((LookupMapping)errors.get(0), "lookup.species", "SPECIES_2", "species2", "lookup.speciesIDEXX", "SPECIES_B", "species B", 2, "Expected speciesB for SPECIES_B but got species B");
    }

    @Test
    public void testMapToInvalidArchetype() throws IOException {
        String[][] data = new String[][]{{"lookup.species", "SPECIES_1", "species1", "lookup.species", "SPECIES_2", "species2"}};
        LookupMappings mappings = this.load(data);
        Assert.assertEquals((long)0L, (long)mappings.getMappings().size());
        List errors = mappings.getErrors();
        Assert.assertEquals((long)1L, (long)errors.size());
        this.checkMapping((LookupMapping)errors.get(0), "lookup.species", "SPECIES_1", "species1", "lookup.species", "SPECIES_2", "species2", 2, "Cannot add target with archetype lookup.species to node named mapping in archetype lookup.species");
    }

    @Test
    public void testDoubleMapping() throws IOException {
        String[][] data = new String[][]{{"lookup.species", "SPECIES_1", "species1", "lookup.speciesIDEXX", "SPECIES_A", "speciesA"}, {"lookup.species", "SPECIES_1", "species1", "lookup.speciesIDEXX", "SPECIES_B", "speciesB"}};
        LookupMappings mappings = this.load(data);
        Assert.assertEquals((long)1L, (long)mappings.getMappings().size());
        List errors = mappings.getErrors();
        Assert.assertEquals((long)1L, (long)errors.size());
        this.checkMapping((LookupMapping)errors.get(0), "lookup.species", "SPECIES_1", "species1", "lookup.speciesIDEXX", "SPECIES_B", "speciesB", 3, "Failed to validate Mapping of Species: There are multiple mappings of the same type");
    }

    private void checkMappings(String[][] data) {
        LookupService service = this.getLookupService();
        for (String[] mapping : data) {
            Lookup from = service.getLookup(mapping[0], mapping[1]);
            Assert.assertNotNull((Object)from);
            Assert.assertEquals((Object)mapping[2], (Object)from.getName());
            Lookup to = service.getLookup(mapping[3], mapping[4]);
            Assert.assertNotNull((Object)to);
            Assert.assertEquals((Object)mapping[5], (Object)to.getName());
            IMObjectBean bean = this.getBean((IMObject)from);
            Assert.assertTrue((boolean)bean.getTargetRefs("mapping").contains(to.getObjectReference()));
        }
    }

    private LookupMappings load(String[][] data) throws IOException {
        Document document = this.createCSV(data);
        LookupMappingImporter importer = new LookupMappingImporter((ArchetypeService)this.getArchetypeService(), this.getLookupService(), new DocumentHandlers((ArchetypeService)this.getArchetypeService()), ',');
        return importer.load((org.openvpms.component.model.document.Document)document);
    }

    private void removeLookup(String shortName, String code) {
        Lookup lookup = this.getLookupService().getLookup(shortName, code);
        ArrayList<Lookup> toSave = new ArrayList<Lookup>();
        if (lookup != null) {
            toSave.add(lookup);
            IArchetypeService service = this.getArchetypeService();
            for (LookupRelationship relationship : new ArrayList(lookup.getSourceLookupRelationships())) {
                lookup.removeLookupRelationship(relationship);
                Lookup target = (Lookup)service.get(relationship.getTarget(), Lookup.class);
                if (target == null) continue;
                target.removeLookupRelationship(relationship);
                toSave.add(target);
            }
            for (LookupRelationship relationship : new ArrayList(lookup.getTargetLookupRelationships())) {
                Lookup source = (Lookup)service.get(relationship.getSource(), Lookup.class);
                lookup.removeLookupRelationship(relationship);
                source.removeLookupRelationship(relationship);
                toSave.add(source);
            }
            service.save(toSave);
            this.remove((IMObject)lookup);
        }
        Assert.assertNull((Object)this.getLookupService().getLookup(shortName, code));
    }

    private Document createCSV(String[][] data) throws IOException {
        StringWriter writer = new StringWriter();
        CSVWriter csv = new CSVWriter((Writer)writer, ',');
        csv.writeNext(LookupMappingCSVWriter.HEADER);
        for (String[] line : data) {
            csv.writeNext(line);
        }
        csv.close();
        DocumentHandlers handlers = new DocumentHandlers((ArchetypeService)this.getArchetypeService());
        DocumentHandler handler = handlers.get("Dummy.csv", "text/csv");
        return handler.create("Dummy.csv", (InputStream)new ByteArrayInputStream(writer.toString().getBytes(StandardCharsets.UTF_8)), "text/csv", -1);
    }
}

