/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.calendar;

import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.workspace.admin.calendar.CalendarEventSeries;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractScheduleEventSeriesTest;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeries;

public class CalendarEventSeriesTestCase
extends AbstractScheduleEventSeriesTest {
    private Entity schedule;
    private Party location;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.location = TestHelper.createLocation();
        this.schedule = ScheduleTestHelper.createSchedule((int)15, (String)DateUnits.MINUTES.toString(), (int)1, null, (Party)this.location);
    }

    @Override
    protected Act createEvent(Date startTime, Date endTime) {
        return ScheduleTestHelper.createCalendarEvent((Date)startTime, (Date)endTime, (Entity)this.schedule, (Party)this.location);
    }

    @Override
    protected List<Act> checkSeries(ScheduleEventSeries series, Act event, int interval, DateUnits units, int count, User author) {
        List acts = series.getEvents();
        Assert.assertEquals((long)count, (long)acts.size());
        Date from = event.getActivityStartTime();
        Date to = event.getActivityEndTime();
        Assert.assertEquals((Object)event, acts.get(0));
        IMObjectBean bean = this.getBean((IMObject)event);
        Entity schedule = (Entity)bean.getTarget("schedule", Entity.class);
        String status = event.getStatus();
        for (Act act : acts) {
            this.checkCalendarEvent(act, from, to, schedule, (Entity)this.location, status, author);
            from = DateRules.getDate((Date)from, (int)interval, (DateUnits)units);
            to = DateRules.getDate((Date)to, (int)interval, (DateUnits)units);
        }
        return acts;
    }

    @Override
    protected ScheduleEventSeries createSeries(Act event) {
        return new CalendarEventSeries(event, this.getArchetypeService());
    }

    private void checkCalendarEvent(Act act, Date startTime, Date endTime, Entity schedule, Entity location, String status, User author) {
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)startTime, (Date)act.getActivityStartTime()));
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)endTime, (Date)act.getActivityEndTime()));
        IMObjectBean bean = this.getBean((IMObject)act);
        Assert.assertEquals((Object)schedule, (Object)bean.getTarget("schedule"));
        Assert.assertEquals((Object)location, (Object)bean.getTarget("location"));
        Assert.assertEquals((Object)status, (Object)act.getStatus());
        Assert.assertEquals((Object)author.getObjectReference(), (Object)act.getCreatedBy());
    }
}

