/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.authority;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.security.ArchetypeAwareGrantedAuthority;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.admin.authority.AuthorityEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthorityEditorTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectEditorFactory factory;

    @Test
    public void testDuplicate() {
        ArchetypeAwareGrantedAuthority auth1 = this.createAuthority();
        String name1 = TestHelper.randomName((String)"zauth");
        ArchetypeAwareGrantedAuthority auth2 = this.createAuthority();
        String name2 = TestHelper.randomName((String)"zauth");
        auth2.setName(name2);
        this.save((IMObject)auth2);
        DefaultLayoutContext layoutContext = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        AuthorityEditor editor = new AuthorityEditor(auth1, null, (LayoutContext)layoutContext);
        Assert.assertFalse((boolean)editor.isValid());
        editor.setName(name1);
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        editor.setName(name2);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)("An authority already exists with name '" + editor.getName() + "'"));
        editor.setName(name1);
        Assert.assertTrue((boolean)editor.isValid());
    }

    @Test
    public void testFactory() {
        ArchetypeAwareGrantedAuthority authority = this.createAuthority();
        IMObjectEditor editor = this.factory.create((IMObject)authority, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        Assert.assertTrue((boolean)(editor instanceof AuthorityEditor));
    }

    @Test
    public void testNewInstance() {
        ArchetypeAwareGrantedAuthority authority = this.createAuthority();
        AuthorityEditor editor = new AuthorityEditor(authority, null, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        IMObjectEditor newInstance = editor.newInstance();
        Assert.assertTrue((boolean)(newInstance instanceof AuthorityEditor));
        Assert.assertEquals((Object)authority, (Object)newInstance.getObject());
    }

    private ArchetypeAwareGrantedAuthority createAuthority() {
        ArchetypeAwareGrantedAuthority result = (ArchetypeAwareGrantedAuthority)this.create("security.archetypeAuthority", ArchetypeAwareGrantedAuthority.class);
        result.setServiceName("archetypeService");
        result.setMethod("create");
        result.setShortName("*");
        return result;
    }
}

