/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.util;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandlers;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.customer.CustomerQuery;
import org.openvpms.web.component.im.patient.PatientQuery;
import org.openvpms.web.component.im.query.AutoQuery;
import org.openvpms.web.component.im.query.DefaultQuery;
import org.openvpms.web.component.im.query.EntityQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.test.AbstractAppTest;

public class ArchetypeHandlersTestCase
extends AbstractAppTest {
    private ArchetypeHandlers<?> propertiesHandlers;
    private ArchetypeHandlers<?> xmlHandlers;
    private static final String PROPERTIES = "org/openvpms/web/component/im/util/ArchetypeHandlersTestCase.properties";
    private static final String XML = "org/openvpms/web/component/im/util/ArchetypeHandlersTestCase.xml";

    public void setUp() {
        super.setUp();
        this.propertiesHandlers = new ArchetypeHandlers(PROPERTIES, null, Query.class, "query.", (ArchetypeService)this.getArchetypeService());
        this.xmlHandlers = new ArchetypeHandlers(XML, Query.class, (ArchetypeService)this.getArchetypeService());
    }

    @Test
    public void testCreateAutoQuery() throws Exception {
        this.checkCreateAutoQuery(this.propertiesHandlers);
        this.checkCreateAutoQuery(this.xmlHandlers);
    }

    @Test
    public void testCreatePatientQuery() throws Exception {
        this.checkCreatePatientQuery(this.propertiesHandlers);
        this.checkCreatePatientQuery(this.xmlHandlers);
    }

    @Test
    public void testMultipleHandlersForSameArchetype() {
        ArchetypeHandler customer1 = this.propertiesHandlers.getHandler("party.customer*");
        ArchetypeHandler customer2 = this.propertiesHandlers.getHandler("party.customerperson");
        Assert.assertEquals(EntityQuery.class, (Object)customer1.getType());
        Assert.assertEquals(CustomerQuery.class, (Object)customer2.getType());
    }

    @Test
    public void testNoMatch() {
        this.checkNoMatch(this.propertiesHandlers);
        this.checkNoMatch(this.xmlHandlers);
    }

    @Test
    public void testNoCompleteMatch() {
        this.checkNoCompleteMatch(this.propertiesHandlers);
        this.checkNoCompleteMatch(this.xmlHandlers);
    }

    @Test
    public void testSameHandlerImplementationType() {
        this.checkSameHandlerImplementationType(this.propertiesHandlers);
        this.checkSameHandlerImplementationType(this.xmlHandlers);
    }

    @Test
    public void checkAnonymous() throws Exception {
        DefaultQuery query1 = new DefaultQuery(new String[]{"lookup.species"}, Lookup.class);
        Assert.assertFalse((boolean)query1.isAuto());
        Assert.assertFalse((boolean)query1.isContains());
        ArchetypeHandler handler = this.propertiesHandlers.getHandler(DefaultQuery.class);
        Assert.assertNotNull((Object)handler);
        Assert.assertEquals(DefaultQuery.class, (Object)handler.getType());
        Query query = (Query)handler.create(new Object[]{new String[]{"lookup.species"}, Lookup.class});
        Assert.assertTrue((boolean)query.isAuto());
        Assert.assertTrue((boolean)query.isContains());
    }

    private void checkCreateAutoQuery(ArchetypeHandlers<?> handlers) throws Exception {
        String[] shortNames = DescriptorHelper.getShortNames((String)"lookup.*", (ArchetypeService)this.getArchetypeService());
        ArchetypeHandler lookup = handlers.getHandler("lookup.*");
        Assert.assertNotNull((Object)lookup);
        Assert.assertEquals((Object)lookup.getType(), AutoQuery.class);
        Query query = (Query)lookup.create(new Object[]{shortNames});
        Assert.assertNotNull((Object)query);
    }

    private void checkCreatePatientQuery(ArchetypeHandlers<?> handlers) throws Exception {
        String[] shortNames = DescriptorHelper.getShortNames((String)"party.patient*", (ArchetypeService)this.getArchetypeService());
        ArchetypeHandler patient = handlers.getHandler("party.patient*");
        Assert.assertNotNull((Object)patient);
        Assert.assertEquals((Object)patient.getType(), PatientQuery.class);
        Query query = (Query)patient.create(new Object[]{shortNames, new LocalContext()});
        Assert.assertNotNull((Object)query);
        Assert.assertEquals((long)25L, (long)query.getMaxResults());
    }

    private void checkNoMatch(ArchetypeHandlers<?> handlers) {
        ArchetypeHandler handler1 = handlers.getHandler("act.*");
        Assert.assertNull((Object)handler1);
        ArchetypeHandler handler2 = handlers.getHandler(new String[]{"act.*", "actRelationship.*"});
        Assert.assertNull((Object)handler2);
    }

    private void checkNoCompleteMatch(ArchetypeHandlers<?> handlers) {
        ArchetypeHandler handler1 = handlers.getHandler("*.*");
        Assert.assertNull((Object)handler1);
        ArchetypeHandler handler2 = handlers.getHandler(new String[]{"party.patient*", "lookup.*"});
        Assert.assertNull((Object)handler2);
    }

    private void checkSameHandlerImplementationType(ArchetypeHandlers<?> handlers) {
        ArchetypeHandler handler = handlers.getHandler(new String[]{"lookup.*", "security.*"});
        Assert.assertNotNull((Object)handler);
        Assert.assertEquals((Object)handler.getType(), AutoQuery.class);
        ArchetypeHandler org = handlers.getHandler(new String[]{"party.organisation*"});
        Assert.assertNotNull((Object)org);
        Assert.assertEquals((Object)org.getType(), AutoQuery.class);
        ArchetypeHandler entity = handlers.getHandler(new String[]{"party.organisationOTC", "party.customer*"});
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((Object)entity.getType(), EntityQuery.class);
        handler = handlers.getHandler(new String[]{"lookup.*", "security.*", "party.organisation*"});
        Assert.assertNull((Object)handler);
    }
}

