/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.act;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.math.Weight;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.component.system.common.cache.SoftRefIMObjectCache;
import org.openvpms.web.component.im.edit.act.ProductTemplateExpander;
import org.openvpms.web.component.im.edit.act.TemplateProduct;
import org.openvpms.web.test.AbstractAppTest;

public class ProductTemplateExpanderTestCase
extends AbstractAppTest {
    @Test
    public void testExpand() {
        Product productX = TestHelper.createProduct();
        Product productY = TestHelper.createProduct();
        Product productZ = TestHelper.createProduct();
        Product templateA = ProductTestHelper.createTemplate((String)"templateA");
        Product templateB = ProductTestHelper.createTemplate((String)"templateB");
        Product templateC = ProductTestHelper.createTemplate((String)"templateC");
        ProductTestHelper.addInclude((Product)templateA, (Product)templateB, (int)1, (int)2);
        ProductTestHelper.addInclude((Product)templateA, (Product)templateC, (int)2, (int)2);
        ProductTestHelper.addInclude((Product)templateB, (Product)productX, (int)5, (int)5);
        ProductTestHelper.addInclude((Product)templateB, (Product)productY, (int)2, (int)2);
        ProductTestHelper.addInclude((Product)templateC, (Product)productX, (int)1, (int)1);
        ProductTestHelper.addInclude((Product)templateC, (Product)productZ, (int)10, (int)10);
        Collection<TemplateProduct> includes1 = this.expand(templateA, Weight.ZERO, BigDecimal.ONE);
        Assert.assertEquals((long)3L, (long)includes1.size());
        this.checkInclude(includes1, productX, 7, 12, false, 0);
        this.checkInclude(includes1, productY, 2, 4, false, 1);
        this.checkInclude(includes1, productZ, 20, 20, false, 2);
        Collection<TemplateProduct> includes2 = this.expand(templateA, Weight.ZERO, BigDecimal.TEN);
        Assert.assertEquals((long)3L, (long)includes2.size());
        this.checkInclude(includes2, productX, 70, 120, false, 0);
        this.checkInclude(includes2, productY, 20, 40, false, 1);
        this.checkInclude(includes2, productZ, 200, 200, false, 2);
    }

    @Test
    public void testExpandWeightRange() {
        Product productX = TestHelper.createProduct();
        Product productY = TestHelper.createProduct();
        Product productZ = TestHelper.createProduct();
        Product templateA = ProductTestHelper.createTemplate((String)"templateA");
        Product templateB = ProductTestHelper.createTemplate((String)"templateB");
        Product templateC = ProductTestHelper.createTemplate((String)"templateC");
        ProductTestHelper.addInclude((Product)templateA, (Product)templateB, (int)1, (int)1, (int)0, (int)2);
        ProductTestHelper.addInclude((Product)templateA, (Product)templateC, (int)2, (int)4, (int)2, (int)4);
        ProductTestHelper.addInclude((Product)templateB, (Product)productX, (int)1, (int)1, (int)0, (int)2);
        ProductTestHelper.addInclude((Product)templateB, (Product)productY, (int)1, (int)1, (int)2, (int)4);
        ProductTestHelper.addInclude((Product)templateC, (Product)productX, (int)1, (int)1, (int)0, (int)2);
        ProductTestHelper.addInclude((Product)templateC, (Product)productZ, (int)1, (int)1, (int)2, (int)4);
        Collection<TemplateProduct> includes = this.expand(templateA, Weight.ZERO, BigDecimal.ONE);
        Assert.assertEquals((long)0L, (long)includes.size());
        includes = this.expand(templateA, new Weight(BigDecimal.ONE, WeightUnits.KILOGRAMS), BigDecimal.ONE);
        Assert.assertEquals((long)1L, (long)includes.size());
        this.checkInclude(includes, productX, 1, 1, false, 0);
        includes = this.expand(templateA, new Weight(BigDecimal.valueOf(2L), WeightUnits.KILOGRAMS), BigDecimal.ONE);
        Assert.assertEquals((long)1L, (long)includes.size());
        this.checkInclude(includes, productZ, 2, 4, false, 0);
        includes = this.expand(templateA, new Weight(BigDecimal.valueOf(4L), WeightUnits.KILOGRAMS), BigDecimal.ONE);
        Assert.assertEquals((long)0L, (long)includes.size());
    }

    @Test
    public void testRecursion() {
        Product productX = TestHelper.createProduct();
        Product templateA = ProductTestHelper.createTemplate((String)"templateA");
        Product templateB = ProductTestHelper.createTemplate((String)"templateB");
        Product templateC = ProductTestHelper.createTemplate((String)"templateC");
        ProductTestHelper.addInclude((Product)templateA, (Product)templateB, (int)1, (int)1);
        ProductTestHelper.addInclude((Product)templateA, (Product)productX, (int)1, (int)1);
        ProductTestHelper.addInclude((Product)templateB, (Product)templateC, (int)1, (int)1);
        ProductTestHelper.addInclude((Product)templateB, (Product)productX, (int)1, (int)1);
        ProductTestHelper.addInclude((Product)templateC, (Product)templateA, (int)1, (int)1);
        ProductTestHelper.addInclude((Product)templateC, (Product)productX, (int)1, (int)1);
        Collection<TemplateProduct> includes = this.expand(templateA, Weight.ZERO, BigDecimal.ONE);
        Assert.assertEquals((long)0L, (long)includes.size());
    }

    @Test
    public void testZeroPrice() {
        Product productX = TestHelper.createProduct();
        Product productY = TestHelper.createProduct();
        Product productZ = TestHelper.createProduct();
        Product templateA = ProductTestHelper.createTemplate((String)"templateA");
        Product templateB = ProductTestHelper.createTemplate((String)"templateB");
        Product templateC = ProductTestHelper.createTemplate((String)"templateC");
        ProductTestHelper.addInclude((Product)templateA, (Product)templateB, (int)1, (boolean)false);
        ProductTestHelper.addInclude((Product)templateA, (Product)templateC, (int)1, (boolean)true);
        ProductTestHelper.addInclude((Product)templateA, (Product)productY, (int)1, (boolean)true);
        ProductTestHelper.addInclude((Product)templateB, (Product)productX, (int)1, (boolean)false);
        ProductTestHelper.addInclude((Product)templateB, (Product)productY, (int)1, (boolean)false);
        ProductTestHelper.addInclude((Product)templateC, (Product)productY, (int)1, (boolean)false);
        ProductTestHelper.addInclude((Product)templateC, (Product)productZ, (int)1, (boolean)false);
        Collection<TemplateProduct> includes = this.expand(templateA, Weight.ZERO, BigDecimal.ONE);
        Assert.assertEquals((long)4L, (long)includes.size());
        this.checkInclude(includes, productX, 1, 1, false, 0);
        this.checkInclude(includes, productY, 1, 1, false, 1);
        this.checkInclude(includes, productY, 2, 2, true, 2);
        this.checkInclude(includes, productZ, 1, 1, true, 3);
    }

    @Test
    public void testUseLocationProducts() {
        Party locationA = TestHelper.createLocation();
        Party stockLocationA = ProductTestHelper.createStockLocation();
        Party locationB = TestHelper.createLocation();
        Party stockLocationB = ProductTestHelper.createStockLocation();
        Product product1 = ProductTestHelper.createMedication();
        Product product2 = ProductTestHelper.createService();
        Product templateA = ProductTestHelper.createTemplate((String)"templateA");
        ProductTestHelper.addInclude((Product)templateA, (Product)product1, (int)1, (int)1, (int)0, (int)0, (boolean)false, (boolean)true);
        ProductTestHelper.addInclude((Product)templateA, (Product)product2, (int)1, (int)1, (int)0, (int)0, (boolean)false, (boolean)true);
        Collection<TemplateProduct> includes1 = this.expand(templateA, Weight.ZERO, BigDecimal.ONE, locationA, stockLocationA);
        Assert.assertEquals((long)1L, (long)includes1.size());
        this.checkInclude(includes1, product2, 1, 1, false, 0);
        Product product3 = ProductTestHelper.createMerchandise();
        Product product4 = ProductTestHelper.createService();
        ProductTestHelper.setStockQuantity((Product)product3, (Party)stockLocationB, (BigDecimal)BigDecimal.ONE);
        ProductTestHelper.addLocationExclusion((Product)product4, (Party)locationA);
        Product templateB = ProductTestHelper.createTemplate((String)"templateB");
        ProductTestHelper.addInclude((Product)templateB, (Product)product3, (int)1, (int)1, (int)0, (int)0, (boolean)false, (boolean)false);
        ProductTestHelper.addInclude((Product)templateB, (Product)product4, (int)1, (int)1, (int)0, (int)0, (boolean)false, (boolean)false);
        Collection<TemplateProduct> includes2 = this.expand(templateB, Weight.ZERO, BigDecimal.ONE, locationA, stockLocationA);
        Assert.assertEquals((long)0L, (long)includes2.size());
        Collection<TemplateProduct> includes3 = this.expand(templateB, Weight.ZERO, BigDecimal.ONE, locationB, stockLocationB);
        this.checkInclude(includes3, product3, 1, 1, false, 0);
        this.checkInclude(includes3, product4, 1, 1, false, 1);
        Product templateC = ProductTestHelper.createTemplate((String)"templateC");
        ProductTestHelper.addInclude((Product)templateC, (Product)product2, (int)1, (int)1, (int)0, (int)0, (boolean)false, (boolean)false);
        ProductTestHelper.addInclude((Product)templateC, (Product)product3, (int)1, (int)1, (int)0, (int)0, (boolean)false, (boolean)true);
        ProductTestHelper.addInclude((Product)templateC, (Product)product4, (int)1, (int)1, (int)0, (int)0, (boolean)false, (boolean)true);
        Collection<TemplateProduct> includes4 = this.expand(templateC, Weight.ZERO, BigDecimal.ONE, locationA, stockLocationA);
        Assert.assertEquals((long)1L, (long)includes4.size());
        this.checkInclude(includes4, product2, 1, 1, false, 0);
        Collection<TemplateProduct> includes5 = this.expand(templateC, Weight.ZERO, BigDecimal.ONE, locationB, stockLocationB);
        Assert.assertEquals((long)3L, (long)includes5.size());
        this.checkInclude(includes5, product2, 1, 1, false, 0);
        this.checkInclude(includes5, product3, 1, 1, false, 1);
        this.checkInclude(includes5, product4, 1, 1, false, 2);
    }

    @Test
    public void testInactiveInclude() {
        Product productX = TestHelper.createProduct();
        Product productY = TestHelper.createProduct();
        Product productZ = TestHelper.createProduct();
        Product templateA = ProductTestHelper.createTemplate((String)"templateA");
        Product templateB = ProductTestHelper.createTemplate((String)"templateB");
        Product templateC = ProductTestHelper.createTemplate((String)"templateC");
        ProductTestHelper.addInclude((Product)templateA, (Product)templateB, (int)1, (int)2);
        ProductTestHelper.addInclude((Product)templateA, (Product)templateC, (int)2, (int)2);
        ProductTestHelper.addInclude((Product)templateB, (Product)productX, (int)5, (int)5);
        ProductTestHelper.addInclude((Product)templateB, (Product)productY, (int)2, (int)2);
        ProductTestHelper.addInclude((Product)templateC, (Product)productX, (int)1, (int)1);
        ProductTestHelper.addInclude((Product)templateC, (Product)productZ, (int)10, (int)10);
        templateB.setActive(false);
        productZ.setActive(false);
        this.save((IMObject[])new Product[]{templateB, productZ});
        Collection<TemplateProduct> includes1 = this.expand(templateA, Weight.ZERO, BigDecimal.ONE);
        Assert.assertEquals((long)1L, (long)includes1.size());
        this.checkInclude(includes1, productX, 2, 2, false, 0);
    }

    @Test
    public void testNegativeQuantities() {
        Product productX = TestHelper.createProduct();
        Product template = ProductTestHelper.createTemplate((String)"templateA");
        ProductTestHelper.addInclude((Product)template, (Product)productX, (int)-2, (int)-1);
        Collection<TemplateProduct> includes = this.expand(template, Weight.ZERO, BigDecimal.ONE);
        Assert.assertEquals((long)1L, (long)includes.size());
        this.checkInclude(includes, productX, -2, -1, false, 0);
    }

    private Collection<TemplateProduct> expand(Product template, Weight weight, BigDecimal quantity) {
        ProductTemplateExpander expander = new ProductTemplateExpander();
        return expander.expand(template, weight, quantity, (IMObjectCache)new SoftRefIMObjectCache((ArchetypeService)this.getArchetypeService()));
    }

    private Collection<TemplateProduct> expand(Product template, Weight weight, BigDecimal quantity, Party location, Party stockLocation) {
        ProductTemplateExpander expander = new ProductTemplateExpander(true, location, stockLocation);
        return expander.expand(template, weight, quantity, (IMObjectCache)new SoftRefIMObjectCache((ArchetypeService)this.getArchetypeService()));
    }

    private void checkInclude(Collection<TemplateProduct> includes, Product product, int lowQuantity, int highQuantity, boolean zeroPrice, int index) {
        Assert.assertTrue((index < includes.size() ? 1 : 0) != 0);
        TemplateProduct include = new ArrayList<TemplateProduct>(includes).get(index);
        Assert.assertEquals((Object)product, (Object)include.getProduct());
        Assert.assertEquals((Object)zeroPrice, (Object)include.getZeroPrice());
        this.checkEquals(BigDecimal.valueOf(lowQuantity), include.getLowQuantity());
        this.checkEquals(BigDecimal.valueOf(highQuantity), include.getHighQuantity());
    }
}

