/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.contact.EmailEditor;
import org.openvpms.web.component.im.contact.LocationEditor;
import org.openvpms.web.component.im.doc.DocumentTemplateEditor;
import org.openvpms.web.component.im.doc.EmailDocumentTemplateAttachmentEditor;
import org.openvpms.web.component.im.edit.DefaultIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.edit.payment.PaymentItemEditor;
import org.openvpms.web.component.im.edit.payment.SupplierPaymentEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.patient.PatientParticipationEditor;
import org.openvpms.web.component.im.product.ProductEditor;
import org.openvpms.web.component.im.product.ProductIncludesEditor;
import org.openvpms.web.component.im.product.ProductParticipationEditor;
import org.openvpms.web.component.im.product.ProductPriceEditor;
import org.openvpms.web.component.im.product.ProductReminderRelationshipEditor;
import org.openvpms.web.component.im.product.ProductStockLocationEditor;
import org.openvpms.web.component.im.product.ProductTaskEditor;
import org.openvpms.web.component.im.product.ProductTemplateEditor;
import org.openvpms.web.component.im.relationship.EntityLinkEditor;
import org.openvpms.web.component.im.relationship.EntityRelationshipEditor;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.admin.hl7.PharmacyGroupEditor;
import org.openvpms.web.workspace.admin.job.scheduledreport.ScheduledReportTemplateEditor;
import org.openvpms.web.workspace.admin.lookup.CurrencyEditor;
import org.openvpms.web.workspace.admin.lookup.CustomerAlertTypeEditor;
import org.openvpms.web.workspace.admin.lookup.LookupEditor;
import org.openvpms.web.workspace.admin.lookup.MacroEditor;
import org.openvpms.web.workspace.admin.lookup.SpeciesLookupEditor;
import org.openvpms.web.workspace.admin.lookup.SuburbLookupEditor;
import org.openvpms.web.workspace.admin.template.DocumentTemplatePrinterEditor;
import org.openvpms.web.workspace.admin.type.ReminderConfigurationGroupTemplateEditor;
import org.openvpms.web.workspace.admin.type.ReminderCountTemplateEditor;
import org.openvpms.web.workspace.customer.CustomerEditor;
import org.openvpms.web.workspace.customer.PatientOwnerRelationshipEditor;
import org.openvpms.web.workspace.customer.account.AdjustmentActEditor;
import org.openvpms.web.workspace.customer.charge.DefaultCustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.DefaultCustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.estimate.EstimateEditor;
import org.openvpms.web.workspace.customer.estimate.EstimateItemEditor;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentEditor;
import org.openvpms.web.workspace.customer.payment.EFTPaymentItemEditor;
import org.openvpms.web.workspace.patient.PatientEditor;
import org.openvpms.web.workspace.patient.mr.PatientClinicalEventActEditor;
import org.openvpms.web.workspace.patient.mr.PatientClinicalProblemActEditor;
import org.openvpms.web.workspace.product.stock.StockAdjustEditor;
import org.openvpms.web.workspace.product.stock.StockAdjustItemEditor;
import org.openvpms.web.workspace.product.stock.StockTransferEditor;
import org.openvpms.web.workspace.product.stock.StockTransferItemEditor;
import org.openvpms.web.workspace.reporting.till.TillBalanceAdjustmentEditor;
import org.openvpms.web.workspace.supplier.SupplierStockLocationRelationshipESCIEditor;
import org.openvpms.web.workspace.supplier.charge.SupplierChargeActEditor;
import org.openvpms.web.workspace.supplier.charge.SupplierChargeActItemEditor;
import org.openvpms.web.workspace.supplier.delivery.DeliveryEditor;
import org.openvpms.web.workspace.supplier.delivery.DeliveryItemEditor;
import org.openvpms.web.workspace.supplier.insurer.InsurerDocumentTemplateEditor;
import org.openvpms.web.workspace.supplier.order.OrderEditor;
import org.openvpms.web.workspace.supplier.order.OrderItemEditor;
import org.openvpms.web.workspace.workflow.checkin.ScheduleTemplateRelationshipEditor;
import org.openvpms.web.workspace.workflow.messaging.messages.UserMessageEditor;
import org.openvpms.web.workspace.workflow.roster.RosterAreaScheduleEditor;

public class IMObjectEditorFactoryTestCase
extends AbstractAppTest {
    private IArchetypeService service;

    @Test
    public void testCreateDefaultEditor() {
        this.checkCreate("contact.phoneNumber", DefaultIMObjectEditor.class);
    }

    @Test
    public void testCreateEntityRelationshipEditor() {
        String[] shortNames;
        String[] stringArray = shortNames = DescriptorHelper.getShortNames((String)"entityRelationship.*", (ArchetypeService)this.getArchetypeService());
        int n = stringArray.length;
        block13: for (int i = 0; i < n; ++i) {
            String shortName;
            switch (shortName = stringArray[i]) {
                case "entityRelationship.patientOwner": {
                    this.checkCreate(shortName, PatientOwnerRelationshipEditor.class);
                    continue block13;
                }
                case "entityRelationship.documentTemplatePrinter": {
                    this.checkCreate(shortName, DocumentTemplatePrinterEditor.class);
                    continue block13;
                }
                case "entityRelationship.supplierStockLocationESCI": {
                    this.checkCreate(shortName, SupplierStockLocationRelationshipESCIEditor.class);
                    continue block13;
                }
                case "entityRelationship.scheduleDocumentTemplate": 
                case "entityRelationship.worklistDocumentTemplate": {
                    this.checkCreate(shortName, ScheduleTemplateRelationshipEditor.class);
                    continue block13;
                }
                default: {
                    this.checkCreate(shortName, EntityRelationshipEditor.class);
                }
            }
        }
    }

    @Test
    public void testEntityLinkEditor() {
        String[] archetypes;
        String[] stringArray = archetypes = DescriptorHelper.getShortNames((String)"entityLink.*", (ArchetypeService)this.getArchetypeService());
        int n = stringArray.length;
        block25: for (int i = 0; i < n; ++i) {
            String archetype;
            switch (archetype = stringArray[i]) {
                case "entityLink.documentTemplateEmailAttachment": {
                    this.checkCreate(archetype, EmailDocumentTemplateAttachmentEditor.class);
                    continue block25;
                }
                case "entityLink.insurerDocumentTemplate": {
                    this.checkCreate(archetype, InsurerDocumentTemplateEditor.class);
                    continue block25;
                }
                case "entityLink.jobScheduledReportTemplate": {
                    this.checkCreate(archetype, ScheduledReportTemplateEditor.class);
                    continue block25;
                }
                case "entityLink.productIncludes": {
                    this.checkCreate(archetype, ProductIncludesEditor.class);
                    continue block25;
                }
                case "entityLink.productReminder": {
                    this.checkCreate(archetype, ProductReminderRelationshipEditor.class);
                    continue block25;
                }
                case "entityLink.productStockLocation": {
                    this.checkCreate(archetype, ProductStockLocationEditor.class);
                    continue block25;
                }
                case "entityLink.productTask": {
                    this.checkCreate(archetype, ProductTaskEditor.class);
                    continue block25;
                }
                case "entityLink.reminderConfigurationTemplateCustomer": 
                case "entityLink.reminderConfigurationTemplatePatient": {
                    this.checkCreate(archetype, ReminderConfigurationGroupTemplateEditor.class);
                    continue block25;
                }
                case "entityLink.reminderCountTemplate": {
                    this.checkCreate(archetype, ReminderCountTemplateEditor.class);
                    continue block25;
                }
                case "entityLink.rosterAreaSchedule": {
                    this.checkCreate(archetype, RosterAreaScheduleEditor.class);
                    continue block25;
                }
                default: {
                    this.checkCreate(archetype, EntityLinkEditor.class);
                }
            }
        }
    }

    @Test
    public void testCreatePatientParticipationEditor() {
        this.checkCreate("participation.patient", "act.customerEstimationItem", PatientParticipationEditor.class);
    }

    @Test
    public void testCreateProductParticipationEditor() {
        this.checkCreate("participation.product", "act.customerEstimationItem", ProductParticipationEditor.class);
    }

    @Test
    public void testCreateEstimationEditor() {
        this.checkCreate("act.customerEstimation", EstimateEditor.class);
    }

    @Test
    public void testCreateEstimationItemEditor() {
        this.checkNoValidConstructor("act.customerEstimationItem", "act.customerEstimation", EstimateItemEditor.class);
    }

    @Test
    public void testCreateChargeEditor() {
        this.checkCreate("act.customerAccountChargesInvoice", DefaultCustomerChargeActEditor.class);
        this.checkCreate("act.customerAccountChargesCredit", DefaultCustomerChargeActEditor.class);
        this.checkCreate("act.customerAccountChargesCounter", DefaultCustomerChargeActEditor.class);
    }

    @Test
    public void testCreateCustomerInvoiceItemEditor() {
        this.checkNoValidConstructor("act.customerAccountInvoiceItem", "act.customerAccountChargesInvoice", DefaultCustomerChargeActItemEditor.class);
        this.checkNoValidConstructor("act.customerAccountCreditItem", "act.customerAccountChargesCredit", DefaultCustomerChargeActItemEditor.class);
        this.checkNoValidConstructor("act.customerAccountCounterItem", "act.customerAccountChargesCounter", DefaultCustomerChargeActItemEditor.class);
    }

    @Test
    public void testCreateSupplierInvoiceEditor() {
        this.checkCreate("act.supplierAccountChargesInvoice", SupplierChargeActEditor.class);
        this.checkCreate("act.supplierAccountChargesCredit", SupplierChargeActEditor.class);
    }

    @Test
    public void testCreatePaymentEditor() {
        this.checkCreate("act.customerAccountPayment", CustomerPaymentEditor.class);
        this.checkCreate("act.customerAccountRefund", CustomerPaymentEditor.class);
    }

    @Test
    public void testCreatePaymentItemEditor() {
        this.checkCreate("act.customerAccountPaymentCash", PaymentItemEditor.class);
        this.checkCreate("act.customerAccountPaymentCheque", PaymentItemEditor.class);
        this.checkCreate("act.customerAccountPaymentCredit", PaymentItemEditor.class);
        this.checkCreate("act.customerAccountPaymentEFT", "act.customerAccountPayment", EFTPaymentItemEditor.class);
        this.checkCreate("act.customerAccountRefundCash", PaymentItemEditor.class);
        this.checkCreate("act.customerAccountRefundCheque", PaymentItemEditor.class);
        this.checkCreate("act.customerAccountRefundCredit", PaymentItemEditor.class);
        this.checkCreate("act.customerAccountRefundEFT", "act.customerAccountRefund", EFTPaymentItemEditor.class);
        this.checkCreate("act.supplierAccountPaymentCash", PaymentItemEditor.class);
        this.checkCreate("act.supplierAccountPaymentCheque", PaymentItemEditor.class);
        this.checkCreate("act.supplierAccountPaymentCredit", PaymentItemEditor.class);
        this.checkCreate("act.supplierAccountPaymentEFT", PaymentItemEditor.class);
        this.checkCreate("act.supplierAccountRefundCash", PaymentItemEditor.class);
        this.checkCreate("act.supplierAccountRefundCheque", PaymentItemEditor.class);
        this.checkCreate("act.supplierAccountRefundCredit", PaymentItemEditor.class);
        this.checkCreate("act.supplierAccountRefundEFT", PaymentItemEditor.class);
    }

    @Test
    public void testCreateSupplierPaymentEditor() {
        this.checkCreate("act.supplierAccountPayment", SupplierPaymentEditor.class);
        this.checkCreate("act.supplierAccountRefund", SupplierPaymentEditor.class);
    }

    @Test
    public void testCreateProductEditor() {
        for (String shortName : DescriptorHelper.getShortNames((String)"product.*", (ArchetypeService)this.getArchetypeService())) {
            if ("product.template".equals(shortName)) {
                this.checkCreate(shortName, ProductTemplateEditor.class);
                continue;
            }
            this.checkCreate(shortName, ProductEditor.class);
        }
    }

    @Test
    public void testCreateOrderEditor() {
        this.checkCreate("act.supplierOrder", OrderEditor.class);
    }

    @Test
    public void testCreateOrderItemEditor() {
        this.checkCreate("act.supplierOrderItem", "act.supplierOrder", OrderItemEditor.class);
    }

    @Test
    public void testCreateDeliveryEditor() {
        this.checkCreate("act.supplierDelivery", DeliveryEditor.class);
        this.checkCreate("act.supplierReturn", DeliveryEditor.class);
    }

    @Test
    public void testCreateDeliveryItemEditor() {
        this.checkCreate("act.supplierDeliveryItem", "act.supplierDelivery", DeliveryItemEditor.class);
        this.checkCreate("act.supplierReturnItem", "act.supplierReturn", DeliveryItemEditor.class);
    }

    @Test
    public void testCreateSupplierInvoiceItemEditor() {
        this.checkCreate("act.supplierAccountInvoiceItem", "act.supplierAccountChargesInvoice", SupplierChargeActItemEditor.class);
        this.checkCreate("act.supplierAccountCreditItem", "act.supplierAccountChargesCredit", SupplierChargeActItemEditor.class);
    }

    @Test
    public void testCreateStockAdjustEditor() {
        this.checkCreate("act.stockAdjust", StockAdjustEditor.class);
    }

    @Test
    public void testCreateStockAdjustItemEditor() {
        this.checkCreate("act.stockAdjustItem", StockAdjustItemEditor.class);
    }

    @Test
    public void testCreateStockTransferEditor() {
        this.checkCreate("act.stockTransfer", StockTransferEditor.class);
    }

    @Test
    public void testCreateStockTransferItemEditor() {
        this.checkCreate("act.stockTransferItem", StockTransferItemEditor.class);
    }

    @Test
    public void testCreateAdjustmentActEditor() {
        this.checkCreate("act.customerAccountBadDebt", AdjustmentActEditor.class);
        this.checkCreate("act.customerAccountCreditAdjust", AdjustmentActEditor.class);
        this.checkCreate("act.customerAccountDebitAdjust", AdjustmentActEditor.class);
    }

    @Test
    public void testCreateUserMessageActEditor() {
        this.checkCreate("act.userMessage", UserMessageEditor.class);
    }

    @Test
    public void testCreateDocumentTemplateEditor() {
        this.checkCreate("entity.documentTemplate", DocumentTemplateEditor.class);
    }

    @Test
    public void testCreateCustomerEditor() {
        String[] shortNames;
        for (String shortName : shortNames = DescriptorHelper.getShortNames((String)"party.customer*", (ArchetypeService)this.getArchetypeService())) {
            this.checkCreate(shortName, CustomerEditor.class);
        }
    }

    @Test
    public void testCreatePatientEditor() {
        this.checkCreate("party.patientpet", PatientEditor.class);
    }

    @Test
    public void testCreateLookupEditor() {
        this.checkCreate("lookup.fileNameFormat", LookupEditor.class);
    }

    @Test
    public void testCreateMacroEditor() {
        this.checkCreate("lookup.macro", MacroEditor.class);
    }

    @Test
    public void testCreateSpeciesLookupEditor() {
        this.checkCreate("lookup.species", SpeciesLookupEditor.class);
    }

    @Test
    public void testCreateSuburbLookupEditor() {
        this.checkCreate("lookup.suburb", SuburbLookupEditor.class);
    }

    @Test
    public void testCreateCurrencyEditor() {
        this.checkCreate("lookup.currency", CurrencyEditor.class);
    }

    @Test
    public void testCreateAlertTypeEditor() {
        this.checkCreate("lookup.customerAlertType", CustomerAlertTypeEditor.class);
    }

    @Test
    public void testCreatePatientClinicalEventActEditor() {
        this.checkCreate("act.patientClinicalEvent", PatientClinicalEventActEditor.class);
    }

    @Test
    public void testCreatePatientClinicalProblemActEditor() {
        this.checkCreate("act.patientClinicalProblem", PatientClinicalProblemActEditor.class);
    }

    @Test
    public void testCreateProductPriceEditor() {
        this.checkCreate("productPrice.fixedPrice", ProductPriceEditor.class);
        this.checkCreate("productPrice.unitPrice", ProductPriceEditor.class);
    }

    @Test
    public void testEmailEditor() {
        this.checkCreate("contact.email", EmailEditor.class);
    }

    @Test
    public void testLocationEditor() {
        this.checkCreate("contact.location", LocationEditor.class);
    }

    @Test
    public void testTillBalanceAdjustmentEditor() {
        this.checkCreate("act.tillBalanceAdjustment", TillBalanceAdjustmentEditor.class);
    }

    @Test
    public void testPharmacyGroupEditor() {
        this.checkCreate("entity.HL7ServicePharmacyGroup", PharmacyGroupEditor.class);
    }

    public void setUp() {
        super.setUp();
        this.service = ServiceHelper.getArchetypeService();
    }

    private void checkCreate(String shortName, Class type) {
        LocalContext context = new LocalContext();
        context.setPractice(TestHelper.getPractice());
        context.setCustomer(TestHelper.createCustomer());
        context.setLocation(TestHelper.createLocation());
        DefaultLayoutContext layout = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        IMObject object = this.service.create(shortName);
        Assert.assertNotNull((String)("Failed to create object with shortname=" + shortName), (Object)object);
        IMObjectEditor editor = ((IMObjectEditorFactory)ServiceHelper.getBean(IMObjectEditorFactory.class)).create((org.openvpms.component.model.object.IMObject)object, (LayoutContext)layout);
        Assert.assertNotNull((String)"Failed to create editor", (Object)editor);
        Assert.assertEquals((Object)type, editor.getClass());
    }

    private void checkCreate(String shortName, String parentShortName, Class type) {
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        context.getContext().setPractice(TestHelper.getPractice());
        IMObject object = this.service.create(shortName);
        Assert.assertNotNull((String)("Failed to create object with shortname=" + shortName), (Object)object);
        IMObject parent = this.service.create(parentShortName);
        Assert.assertNotNull((String)("Failed to create object with shortname=" + parentShortName), (Object)parent);
        IMObjectEditor editor = ((IMObjectEditorFactory)ServiceHelper.getBean(IMObjectEditorFactory.class)).create((org.openvpms.component.model.object.IMObject)object, (org.openvpms.component.model.object.IMObject)parent, (LayoutContext)context);
        Assert.assertNotNull((String)"Failed to create editor", (Object)editor);
        Assert.assertEquals((Object)type, editor.getClass());
    }

    private void checkNoValidConstructor(String shortName, String parentShortName, Class type) {
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        context.getContext().setPractice(TestHelper.getPractice());
        IMObject object = this.service.create(shortName);
        Assert.assertNotNull((String)("Failed to create object with shortname=" + shortName), (Object)object);
        IMObject parent = this.service.create(parentShortName);
        Assert.assertNotNull((String)("Failed to create object with shortname=" + parentShortName), (Object)parent);
        try {
            ((IMObjectEditorFactory)ServiceHelper.getBean(IMObjectEditorFactory.class)).create((org.openvpms.component.model.object.IMObject)object, (org.openvpms.component.model.object.IMObject)parent, (LayoutContext)context);
            Assert.fail((String)"Expected IllegalStateException to be thrown");
        }
        catch (IllegalStateException exception) {
            Assert.assertEquals((Object)("No valid constructor found for class: " + type.getName()), (Object)exception.getMessage());
        }
    }
}

