/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.worklist;

import java.util.Date;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleColours;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleTableModel;
import org.openvpms.web.workspace.workflow.worklist.TaskGrid;

public abstract class TaskTableModel
extends ScheduleTableModel {
    public TaskTableModel(TaskGrid grid, Context context, ScheduleColours colours) {
        super(grid, context, true, colours);
    }

    @Override
    public int getSlot(Schedule schedule, Reference eventRef) {
        return schedule.indexOf(eventRef);
    }

    @Override
    public String getStatus(PropertySet event) {
        String status;
        String code = event.getString("act.status");
        if ("PENDING".equals(code)) {
            Date startTime = event.getDate("act.startTime");
            String diff = DateFormatter.formatTimeDiff((Date)startTime, (Date)new Date());
            status = Messages.format((String)"workflow.scheduling.table.waiting", (Object[])new Object[]{diff});
        } else {
            status = event.getString("act.statusName");
        }
        return status;
    }
}

