/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.worklist;

import java.util.Date;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.ParticipationConstraint;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.system.ServiceHelper;

class TaskQueryHelper {
    TaskQueryHelper() {
    }

    public static boolean tooManyTasks(Act act) {
        boolean result = false;
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        IMObjectBean actBean = service.getBean((IMObject)act);
        Date startTime = act.getActivityStartTime();
        Party workList = (Party)actBean.getTarget("worklist", Party.class);
        if (startTime != null && workList != null) {
            Date endTime = act.getActivityEndTime();
            IMObjectBean bean = service.getBean((IMObject)workList);
            int maxSlots = bean.getInt("maxSlots");
            ArchetypeQuery query = new ArchetypeQuery("act.customerTask", false, true);
            JoinConstraint join = Constraints.join((String)"worklist");
            join.add((IConstraint)Constraints.eq((String)"entity", (Object)workList));
            join.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)"act.customerTask"));
            join.add(QueryHelper.createParticipationDateRangeConstraint((Date)startTime, (Date)endTime));
            query.add((IConstraint)join);
            query.add((IConstraint)Constraints.ne((String)"id", (Object)act.getId()));
            query.add((IConstraint)Constraints.and((IConstraint[])new IConstraint[]{Constraints.ne((String)"status", (Object)"CANCELLED"), Constraints.ne((String)"status", (Object)"COMPLETED")}));
            query.add(QueryHelper.createDateRangeConstraint((Date)startTime, (Date)endTime));
            query.setFirstResult(0);
            query.setMaxResults(0);
            query.setCountResults(true);
            int totalResults = service.get((IArchetypeQuery)query).getTotalResults();
            if (totalResults >= maxSlots) {
                result = true;
            }
        }
        return result;
    }
}

