/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.worklist;

import java.util.Date;
import java.util.Map;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.echo.table.Cell;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleBrowser;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleColours;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleTableModel;
import org.openvpms.web.workspace.workflow.worklist.MultiScheduleTaskTableModel;
import org.openvpms.web.workspace.workflow.worklist.SingleScheduleTaskTableModel;
import org.openvpms.web.workspace.workflow.worklist.TaskGrid;
import org.openvpms.web.workspace.workflow.worklist.TaskQuery;

public class TaskBrowser
extends ScheduleBrowser {
    private final ScheduleColours colours = (ScheduleColours)((Object)ServiceHelper.getBean(ScheduleColours.class));
    private final AppointmentRules rules = (AppointmentRules)ServiceHelper.getBean(AppointmentRules.class);

    public TaskBrowser(Preferences prefs, Context context) {
        super(new TaskQuery(context, prefs), context);
    }

    public void includeStatus(String status) {
        TaskQuery query = (TaskQuery)this.getQuery();
        query.includeStatus(status);
    }

    @Override
    public void query() {
        this.doQuery(true);
    }

    public boolean setSelected(Act task) {
        IMObjectBean bean = this.getBean((IMObject)task);
        PropertySet selected = null;
        Reference worklist = bean.getTargetRef("worklist");
        if (worklist != null) {
            Reference taskRef = task.getObjectReference();
            ScheduleTableModel model = this.getModel();
            Cell cell = model.getCell(worklist, taskRef);
            if (cell != null) {
                model.setSelected(cell);
                selected = model.getEvent(cell);
            }
        }
        this.setSelected(selected);
        return selected != null;
    }

    @Override
    protected Entity getSchedule(Act act) {
        return (Entity)this.getBean((IMObject)act).getTarget("worklist", Entity.class);
    }

    @Override
    protected ScheduleEventGrid createEventGrid(Date date, Map<Entity, ScheduleEvents> events) {
        return new TaskGrid(this.getScheduleView(), date, events, this.rules);
    }

    @Override
    protected ScheduleTableModel createTableModel(ScheduleEventGrid grid) {
        if (grid.getSchedules().size() == 1) {
            return new SingleScheduleTaskTableModel((TaskGrid)grid, this.getContext(), this.colours);
        }
        return new MultiScheduleTaskTableModel((TaskGrid)grid, this.getContext(), this.colours);
    }
}

