/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.scheduling;

import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SplitPane;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.prefs.PreferenceMonitor;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextApplicationInstance;
import org.openvpms.web.component.app.GlobalContext;
import org.openvpms.web.component.app.LocationMonitor;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.workspace.AbstractViewWorkspace;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.component.workspace.CRUDWindowListener;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.util.PeriodicTask;
import org.openvpms.web.echo.util.TaskQueues;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.CustomerPatientSummary;
import org.openvpms.web.workspace.patient.summary.CustomerPatientSummaryFactory;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleBrowser;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleBrowserListener;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleCRUDWindow;

public abstract class SchedulingWorkspace
extends AbstractViewWorkspace<Entity> {
    private final Preferences preferences;
    private final String preferenceGroup;
    private final PreferenceMonitor monitor;
    private final PeriodicTask refresher;
    private final LocationMonitor locationMonitor;
    private Component workspace;
    private ScheduleBrowser browser;
    private ScheduleCRUDWindow window;
    private Party location;
    private static final int MIN_REFRESH_INTERVAL = 5;

    public SchedulingWorkspace(String id, Archetypes<Entity> archetypes, Context context, Preferences preferences, String preferenceGroup) {
        super(id, archetypes, context, false);
        this.locationMonitor = new LocationMonitor((GlobalContext)context, this::locationChanged);
        this.preferences = preferences;
        this.preferenceGroup = preferenceGroup;
        this.monitor = new PreferenceMonitor(preferences);
        this.monitor.add(preferenceGroup);
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)context.getPractice());
        int refreshInterval = bean.getInt("schedulingRefresh");
        if (refreshInterval > 0) {
            if (refreshInterval < 5) {
                refreshInterval = 5;
            }
            TaskQueues tasks = ContextApplicationInstance.getInstance().getTaskQueues();
            this.refresher = tasks.newTask(refreshInterval, () -> this.browser.refresh());
        } else {
            this.refresher = null;
        }
    }

    public void setObject(Entity object) {
        this.setScheduleView(object, new Date());
    }

    public Component getSummary() {
        if (this.window != null) {
            Act act = (Act)this.window.getObject();
            CustomerPatientSummaryFactory factory = (CustomerPatientSummaryFactory)ServiceHelper.getBean(CustomerPatientSummaryFactory.class);
            CustomerPatientSummary summary = factory.createCustomerPatientSummary(this.getContext(), this.getHelpContext(), this.preferences);
            return summary.getSummary(act);
        }
        return null;
    }

    public void show() {
        this.locationMonitor.register();
        this.checkPreferences();
        this.updateButtons();
        if (this.refresher != null) {
            this.refresher.start();
        }
    }

    public void hide() {
        this.locationMonitor.unregister();
        if (this.refresher != null) {
            this.refresher.stop();
        }
    }

    public void preferencesChanged() {
        this.checkPreferences();
    }

    protected void query() {
        if (this.refresher != null) {
            this.refresher.restart();
        }
        this.browser.query();
    }

    protected Preferences getPreferences() {
        return this.preferences;
    }

    protected void checkPreferences() {
        if (this.monitor.changed()) {
            LocationRules rules;
            Entity view;
            Entity object = (Entity)this.getObject();
            Reference defaultValue = object != null ? object.getObjectReference() : null;
            Reference viewRef = this.preferences.getReference(this.preferenceGroup, "view", defaultValue);
            Party location = this.getContext().getLocation();
            if (location != null && viewRef != null && (view = (Entity)IMObjectHelper.getObject((Reference)viewRef, (Collection)(rules = (LocationRules)ServiceHelper.getBean(LocationRules.class)).getScheduleViews(location))) != null) {
                object = view;
            }
            this.setObject(object);
        }
    }

    protected void setScheduleView(Entity view, Date date) {
        this.setScheduleView(view);
        this.initQuery(view, date);
    }

    protected void setScheduleView(Entity view) {
        this.location = this.getContext().getLocation();
        super.setObject((IMObject)view);
        this.layoutWorkspace();
    }

    protected abstract ScheduleBrowser createBrowser();

    protected abstract ScheduleCRUDWindow createCRUDWindow();

    protected abstract Entity getDefaultView(Party var1, Preferences var2);

    protected boolean refreshWorkspace() {
        return true;
    }

    protected void onSaved(IMObject object, boolean isNew) {
        this.query();
        this.firePropertyChange("summary", null, null);
    }

    protected void onDeleted(IMObject object) {
        this.query();
        this.firePropertyChange("summary", null, null);
    }

    protected void onRefresh(IMObject object) {
        this.query();
        this.firePropertyChange("summary", null, null);
    }

    protected void eventSelected(PropertySet event) {
        Act act = this.browser.getAct(event);
        this.window.setObject((IMObject)act);
        this.firePropertyChange("summary", null, null);
    }

    protected void onEdit(PropertySet event) {
        Act act = this.browser.getAct(event);
        this.window.setObject((IMObject)act);
        this.firePropertyChange("summary", null, null);
        if (act != null) {
            this.window.edit();
        }
    }

    protected void layoutWorkspace() {
        this.setBrowser(this.createBrowser());
        this.setCRUDWindow(this.createCRUDWindow());
        this.setWorkspace(this.createWorkspace());
    }

    protected Component createWorkspace() {
        Component acts = this.browser.getComponent();
        Component window = this.getCRUDWindow().getComponent();
        return SplitPaneFactory.create((int)6, (String)"SchedulingWorkspace.Layout", (Component[])new Component[]{window, acts});
    }

    protected void setBrowser(ScheduleBrowser browser) {
        this.browser = browser;
        browser.addScheduleBrowserListener(new ScheduleBrowserListener(){

            public void query() {
                SchedulingWorkspace.this.onQuery();
            }

            public void selected(PropertySet object) {
                SchedulingWorkspace.this.eventSelected(object);
            }

            public void browsed(PropertySet object) {
                SchedulingWorkspace.this.eventSelected(object);
            }

            @Override
            public void edit(PropertySet set) {
                SchedulingWorkspace.this.onEdit(set);
            }

            @Override
            public void create() {
                SchedulingWorkspace.this.window.create();
            }
        });
    }

    protected ScheduleBrowser getBrowser() {
        return this.browser;
    }

    protected void setWorkspace(Component workspace) {
        SplitPane root = this.getRootComponent();
        if (this.workspace != null) {
            root.remove(this.workspace);
        }
        this.workspace = workspace;
        root.add(this.workspace);
    }

    protected void setCRUDWindow(ScheduleCRUDWindow window) {
        this.window = window;
        this.window.setListener((CRUDWindowListener)new CRUDWindowListener<Act>(){

            public void saved(Act object, boolean isNew) {
                SchedulingWorkspace.this.onSaved((IMObject)object, isNew);
            }

            public void deleted(Act object) {
                SchedulingWorkspace.this.onDeleted((IMObject)object);
            }

            public void refresh(Act object) {
                SchedulingWorkspace.this.onRefresh((IMObject)object);
            }
        });
    }

    protected CRUDWindow<Act> getCRUDWindow() {
        return this.window;
    }

    protected void initQuery(Entity view, Date date) {
        this.browser.setScheduleView(view);
        this.browser.setDate(date);
        this.browser.query();
        this.onQuery();
    }

    protected Component getWorkspace() {
        return this.workspace;
    }

    protected void onQuery() {
        this.firePropertyChange("summary", null, null);
    }

    protected void doLayout(Component container) {
        Entity latest = (Entity)this.getLatest();
        if (this.browser == null || !Objects.equals(this.location, this.getContext().getLocation())) {
            this.layoutWorkspace();
            latest = this.browser.getScheduleView();
            this.setObject(latest);
        } else if (latest != this.getObject()) {
            this.setObject(latest);
        } else {
            this.browser.query();
            Component workspace = this.getWorkspace();
            if (workspace != null) {
                container.add(workspace);
            }
        }
    }

    private void locationChanged(Party newLocation) {
        if (newLocation == null) {
            this.setObject((Entity)null);
        } else if (!Objects.equals(this.location, newLocation)) {
            this.setObject(this.getDefaultView(newLocation, this.preferences));
        }
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.monitor.changed() && this.window != null) {
            this.window.refreshButtons();
        }
    }
}

