/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.scheduling;

import java.util.Date;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;

public class SchedulingHelper {
    public static String evaluate(String expression, PropertySet event) {
        return SchedulingHelper.evaluate(expression, event, null);
    }

    public static String evaluate(String expression, PropertySet event, FunctionLibrary functions) {
        String text;
        String waiting = SchedulingHelper.getWaitingTime(event);
        waiting = waiting != null ? Messages.format((String)"scheduleview.expression.waiting", (Object[])new Object[]{waiting}) : "";
        event.set("waiting", (Object)waiting);
        JXPathContext context = functions != null ? JXPathHelper.newContext((Object)event, (Functions)functions) : JXPathHelper.newContext((Object)event);
        expression = expression.replace("'\\n'", "'\n'");
        try {
            Object value = context.getValue(expression);
            text = value != null ? value.toString() : null;
        }
        catch (Throwable exception) {
            text = "Expression Error";
        }
        return text;
    }

    public static String getWaitingTime(PropertySet event) {
        String waiting = null;
        String status = event.getString("act.status");
        boolean appointment = TypeHelper.isA((Reference)event.getReference("act.objectReference"), (String)"act.customerAppointment");
        if (appointment) {
            Date arrival;
            if ("CHECKED_IN".equals(status) && event.exists("arrivalTime") && (arrival = event.getDate("arrivalTime")) != null) {
                waiting = DateFormatter.formatTimeDiff((Date)arrival, (Date)new Date());
            }
        } else {
            Date start = event.getDate("act.startTime");
            Date end = "PENDING".equals(status) || !event.exists("consultStartTime") ? new Date() : event.getDate("consultStartTime");
            waiting = DateFormatter.formatTimeDiff((Date)start, (Date)end);
        }
        return waiting;
    }
}

