/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.scheduling;

import java.util.Comparator;
import java.util.Date;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.system.common.util.PropertySet;

public class IntersectComparator
implements Comparator<PropertySet> {
    private final int slotSize;
    private final AppointmentRules rules;

    public IntersectComparator(int slotSize, AppointmentRules rules) {
        this.slotSize = slotSize;
        this.rules = rules;
    }

    @Override
    public int compare(PropertySet o1, PropertySet o2) {
        Date start1 = this.rules.getSlotTime(o1.getDate("act.startTime"), this.slotSize, false);
        Date end1 = this.rules.getSlotTime(o1.getDate("act.endTime"), this.slotSize, true);
        Date start2 = this.rules.getSlotTime(o2.getDate("act.startTime"), this.slotSize, false);
        Date end2 = this.rules.getSlotTime(o2.getDate("act.endTime"), this.slotSize, true);
        if (start1.equals(end1) ? DateRules.between((Date)start1, (Date)start2, (Date)end2) : start2.equals(end2) && DateRules.between((Date)start2, (Date)start1, (Date)end1)) {
            return 0;
        }
        if (DateRules.compareTo((Date)end1, (Date)start2) <= 0) {
            return -1;
        }
        if (DateRules.compareTo((Date)start1, (Date)end2) >= 0) {
            return 1;
        }
        return 0;
    }
}

