/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.roster;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.roster.RosterBrowser;
import org.openvpms.web.workspace.workflow.roster.RosterEventGrid;
import org.openvpms.web.workspace.workflow.roster.RosterQuery;
import org.openvpms.web.workspace.workflow.roster.RosterTableModel;
import org.openvpms.web.workspace.workflow.roster.UserRosterQuery;
import org.openvpms.web.workspace.workflow.roster.UserRosterTableModel;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleColours;

class UserRosterBrowser
extends RosterBrowser {
    UserRosterBrowser(LayoutContext context) {
        super(new UserRosterQuery(context.getContext()), context);
    }

    @Override
    protected RosterEventGrid query(RosterQuery query) {
        RosterService service = (RosterService)ServiceHelper.getBean(RosterService.class);
        Date from = query.getDate();
        int days = 7;
        Date to = DateRules.getDate((Date)from, (int)days, (DateUnits)DateUnits.DAYS);
        List users = ((UserRosterQuery)query).getResults();
        LinkedHashMap<Entity, ScheduleEvents> events = new LinkedHashMap<Entity, ScheduleEvents>();
        for (User user : users) {
            ScheduleEvents userEvents = service.getUserEvents(user, from, to);
            events.put((Entity)user, userEvents);
        }
        return new RosterEventGrid(from, to, days, events);
    }

    @Override
    protected long getModHash(Entity entity, ScheduleEvents events, Date startDate, Date endDate, RosterService service) {
        return service.getUserModHash((User)entity, startDate, endDate);
    }

    @Override
    protected RosterTableModel createTableModel(RosterEventGrid grid, ScheduleColours colours) {
        return new UserRosterTableModel(grid, this.getContext(), colours);
    }
}

