/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.roster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.workspace.workflow.roster.EntityRoster;

public class RosterEventGrid {
    private final Map<Entity, ScheduleEvents> events;
    private final Date startDate;
    private final Date endDate;
    private final int days;
    private final List<Row> rows = new ArrayList<Row>();

    public RosterEventGrid(Date startDate, Date endDate, int days, Map<Entity, ScheduleEvents> events) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.days = days;
        this.events = events;
        for (Map.Entry<Entity, ScheduleEvents> entry : events.entrySet()) {
            Entity entity = entry.getKey();
            ScheduleEvents value = entry.getValue();
            EntityRoster<Entity> roster = new EntityRoster<Entity>(entity, startDate, days, value.getEvents());
            for (List<PropertySet> list : roster.getEvents()) {
                this.rows.add(new Row(roster, list));
            }
        }
    }

    public Map<Entity, ScheduleEvents> getEvents() {
        return this.events;
    }

    public int getRows() {
        return this.rows.size();
    }

    public int getColumns() {
        return this.days;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getDate(int column) {
        return DateRules.getDate((Date)this.startDate, (int)column, (DateUnits)DateUnits.DAYS);
    }

    public List<PropertySet> getEvents(int row) {
        return row <= this.rows.size() ? this.rows.get(row).events : Collections.emptyList();
    }

    public PropertySet getEvent(int column, int row) {
        List<PropertySet> events = this.getEvents(row);
        return column < events.size() ? events.get(column) : null;
    }

    public Entity getEntity(int row) {
        return this.rows.get(row).roster.getEntity();
    }

    public int findEntity(Reference entity) {
        return this.findEntity(0, entity);
    }

    public int findEntity(int index, Reference entity) {
        int result = -1;
        for (int i = index; i < this.rows.size(); ++i) {
            if (!this.getEntity(i).getObjectReference().equals((Object)entity)) continue;
            result = i;
        }
        return result;
    }

    public int findEvent(int row, Reference event) {
        int result = -1;
        List events = this.rows.get(row).events;
        for (int i = 0; i < events.size(); ++i) {
            if (!((PropertySet)events.get(i)).getReference("act.objectReference").equals((Object)event)) continue;
            result = i;
            break;
        }
        return result;
    }

    static class Row {
        private final EntityRoster roster;
        private final List<PropertySet> events;

        Row(EntityRoster roster, List<PropertySet> events) {
            this.roster = roster;
            this.events = events;
        }
    }
}

