/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.roster;

import echopointng.LabelEx;
import echopointng.table.TableActionEventEx;
import echopointng.xhtml.XhtmlFragment;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.table.TableModel;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.AbstractBrowser;
import org.openvpms.web.component.im.query.BrowserListener;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.table.Cell;
import org.openvpms.web.echo.table.TableEx;
import org.openvpms.web.echo.util.DoubleClickMonitor;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.roster.RosterBrowserListener;
import org.openvpms.web.workspace.workflow.roster.RosterEventGrid;
import org.openvpms.web.workspace.workflow.roster.RosterQuery;
import org.openvpms.web.workspace.workflow.roster.RosterTableModel;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleColours;

abstract class RosterBrowser
extends AbstractBrowser<PropertySet> {
    private final RosterQuery query;
    private final Context context;
    private final RosterService service;
    private final ScheduleColours colours;
    private final DoubleClickMonitor click = new DoubleClickMonitor();
    private RosterEventGrid grid;
    private RosterTableModel model;
    private TableEx table;
    private Component component;
    private PropertySet selected;
    private PropertySet marked;

    RosterBrowser(RosterQuery query, LayoutContext context) {
        this.query = query;
        this.context = context.getContext();
        this.service = (RosterService)ServiceHelper.getBean(RosterService.class);
        this.colours = (ScheduleColours)((Object)ServiceHelper.getBean(ScheduleColours.class));
        query.addQueryListener(this::query);
    }

    public void refresh() {
        if (this.updated()) {
            this.query();
        }
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = this.doLayout();
        }
        return this.component;
    }

    public PropertySet getSelected() {
        return this.selected;
    }

    public boolean setSelected(PropertySet object) {
        Cell cell;
        boolean found = false;
        this.selected = object;
        if (this.selected != null && (cell = this.model.getCell(object)) != null) {
            this.model.setSelected(cell);
            found = true;
        }
        if (!found) {
            this.model.setSelected(null);
            this.table.getSelectionModel().clearSelection();
        }
        return found;
    }

    public PropertySet getMarked() {
        return this.marked;
    }

    public void setMarked(PropertySet event, boolean isCut) {
        this.marked = event;
        boolean found = false;
        if (this.model != null) {
            Cell cell;
            if (this.marked != null && (cell = this.model.getCell(this.marked)) != null) {
                this.model.setMarked(cell, isCut);
                found = true;
            }
            if (!found) {
                this.model.setMarked(null, isCut);
            }
        }
    }

    public void clearMarked() {
        this.setMarked(null, this.isCut());
    }

    public boolean isCut() {
        return this.model != null && this.model.isCut();
    }

    public Entity getSelectedEntity() {
        return this.model != null ? this.model.getSelectedEntity() : null;
    }

    public Date getSelectedDate() {
        return this.model != null ? this.model.getSelectedDate() : null;
    }

    public void setFocusOnResults() {
    }

    public void query() {
        Cell cell = this.model != null ? this.model.getSelected() : null;
        this.grid = this.query(this.query);
        this.model = this.createTableModel(this.grid, this.colours);
        if (this.table == null) {
            this.table = this.createTable(this.model);
            this.addTable((Table)this.table, this.component);
        } else {
            this.table.setModel((TableModel)this.model);
            this.table.setColumnModel(this.model.getColumnModel());
        }
        if (this.selected != null) {
            this.setSelected(this.selected);
        } else if (cell != null) {
            this.setSelectedCell(cell);
        }
    }

    public List<PropertySet> getObjects() {
        return Collections.emptyList();
    }

    public Act getAct(PropertySet event) {
        return (Act)IMObjectHelper.getObject((Reference)event.getReference("act.objectReference"));
    }

    protected abstract long getModHash(Entity var1, ScheduleEvents var2, Date var3, Date var4, RosterService var5);

    protected RosterTableModel getModel() {
        return this.model;
    }

    protected Context getContext() {
        return this.context;
    }

    protected abstract RosterEventGrid query(RosterQuery var1);

    protected Component doLayout() {
        Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{this.layoutQuery()});
        SplitPane component = SplitPaneFactory.create((int)5, (String)"ScheduleBrowser", (Component[])new Component[]{column});
        if (this.table != null) {
            this.addTable((Table)this.table, (Component)component);
        }
        return component;
    }

    protected void addTable(Table table, Component component) {
        LabelEx spacer = new LabelEx(new XhtmlFragment("<div>&#160;</div>"));
        component.add((Component)ColumnFactory.create((String)"InsetCellSpacing", (Component[])new Component[]{spacer, table}));
    }

    protected Component layoutQuery() {
        Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
        FocusGroup group = this.getFocusGroup();
        row.add(this.query.getComponent());
        group.add(this.query.getFocusGroup());
        ButtonRow buttons = new ButtonRow(group);
        buttons.addButton("query", (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                RosterBrowser.this.onQuery();
            }
        });
        row.add((Component)buttons);
        return row;
    }

    protected void onQuery() {
        this.query();
        this.notifyBrowserListeners();
    }

    protected TableEx createTable(RosterTableModel model) {
        TableEx table = new TableEx((TableModel)model, model.getColumnModel());
        table.setStyleName("ScheduleTable");
        table.setHeaderFixed(true);
        table.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                RosterBrowser.this.onSelected((TableActionEventEx)event);
            }
        });
        return table;
    }

    protected void onSelected(TableActionEventEx event) {
        int column = event.getColumn();
        int row = event.getRow();
        boolean doubleClick = this.click.isDoubleClick() && column != 0 && this.model.isSelected(column, row);
        this.setSelectedCell(new Cell(column, row));
        if (doubleClick) {
            if (this.selected == null) {
                for (BrowserListener listener : this.getBrowserListeners()) {
                    if (!(listener instanceof RosterBrowserListener)) continue;
                    ((RosterBrowserListener)listener).create();
                }
            } else {
                for (BrowserListener listener : this.getBrowserListeners()) {
                    if (!(listener instanceof RosterBrowserListener)) continue;
                    ((RosterBrowserListener)listener).edit(this.selected);
                }
            }
        } else if (this.selected != null) {
            this.notifySelected(this.selected);
        }
        this.table.getSelectionModel().clearSelection();
    }

    protected void setSelectedCell(Cell cell) {
        this.model.setSelected(cell);
        this.selected = this.model.getEvent(cell);
    }

    protected abstract RosterTableModel createTableModel(RosterEventGrid var1, ScheduleColours var2);

    private boolean updated() {
        boolean result = false;
        if (this.grid != null) {
            Map<Entity, ScheduleEvents> events = this.grid.getEvents();
            Date from = this.grid.getStartDate();
            Date to = this.grid.getEndDate();
            for (Map.Entry<Entity, ScheduleEvents> entry : events.entrySet()) {
                ScheduleEvents entityEvents = entry.getValue();
                long hash = this.getModHash(entry.getKey(), entityEvents, from, to, this.service);
                if (hash != -1L && hash == entityEvents.getModHash()) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

