/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.roster;

import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.edit.AbstractIMObjectReferenceEditor;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.EntityObjectSetQuery;
import org.openvpms.web.component.im.query.EntityQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.relationship.EntityLinkEditor;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;

public class RosterAreaScheduleEditor
extends EntityLinkEditor {
    private Party location;

    public RosterAreaScheduleEditor(org.openvpms.component.business.domain.im.common.EntityLink relationship, Entity parent, LayoutContext context) {
        super((EntityLink)relationship, (IMObject)parent, context);
        this.location = parent != null ? (Party)this.getObject(this.getBean((IMObject)parent).getTargetRef("location")) : null;
    }

    public void setLocation(Party location) {
        this.location = location;
        this.resetValid();
    }

    protected IMObjectReferenceEditor<Entity> createTargetEditor(Property property, final LayoutContext context) {
        return new AbstractIMObjectReferenceEditor<Entity>(property, this.getObject(), context){

            protected Query<Entity> createQuery(String name) {
                EntityQuery query = new EntityQuery((EntityObjectSetQuery)new ScheduleObjectSetQuery(), context.getContext());
                query.setValue(name);
                return query;
            }

            protected ValidatorError createValidatorError(Reference reference) {
                Party schedule = (Party)RosterAreaScheduleEditor.this.getObject(reference);
                if (RosterAreaScheduleEditor.this.location != null && schedule != null) {
                    String message = Messages.format((String)"workflow.rostering.invalidschedule", (Object[])new Object[]{schedule.getName(), RosterAreaScheduleEditor.this.location.getName()});
                    return new ValidatorError(this.getProperty(), message);
                }
                return super.createValidatorError(reference);
            }
        };
    }

    private class ScheduleObjectSetQuery
    extends EntityObjectSetQuery {
        ScheduleObjectSetQuery() {
            super(new String[]{"party.organisationSchedule"});
            this.setAuto(true);
        }

        protected ResultSet<ObjectSet> createResultSet(SortConstraint[] sort) {
            this.setConstraints((IConstraint)Constraints.join((String)"location").add((IConstraint)Constraints.eq((String)"target", (Object)RosterAreaScheduleEditor.this.location)));
            return super.createResultSet(sort);
        }
    }
}

